/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;
import org.opendatafoundation.data.spss.SPSSUtils;

public class SPSSRecordType3
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int numberOfLabels;
    Map<byte[], String> valueLabel = new LinkedHashMap<byte[], String>();

    @Override
    public void read(SPSSFile sPSSFile) throws IOException, SPSSFileException {
        this.fileLocation = sPSSFile.getFilePointer();
        this.recordTypeCode = sPSSFile.readSPSSInt();
        if (this.recordTypeCode != 3) {
            throw new SPSSFileException("Error reading variableRecord: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 3.");
        }
        this.numberOfLabels = sPSSFile.readSPSSInt();
        for (int i = 0; i < this.numberOfLabels; ++i) {
            int n;
            byte[] byArray = new byte[8];
            sPSSFile.read(byArray);
            if (sPSSFile.isBigEndian) {
                for (n = 0; n < 3; ++n) {
                    byte by = byArray[n];
                    byArray[n] = byArray[7 - n];
                    byArray[7 - n] = by;
                }
            }
            n = sPSSFile.read();
            String string = sPSSFile.readSPSSString(n);
            if ((n + 1) % 8 != 0) {
                sPSSFile.skipBytes(8 - (n + 1) % 8);
            }
            this.valueLabel.put(byArray, string);
        }
    }

    @Override
    public String toString() {
        String string = "";
        string = string + "\nRECORD TYPE 3 - VALUE LABEL RECORD";
        string = string + "\nLocation        : " + this.fileLocation;
        string = string + "\nRecord Type     : " + this.recordTypeCode;
        string = string + "\nNumber labels   : " + this.numberOfLabels;
        for (Map.Entry<byte[], String> entry : this.valueLabel.entrySet()) {
            byte[] byArray = entry.getKey();
            String string2 = entry.getValue();
            string = string + "\n " + SPSSUtils.byte8ToDouble(byArray) + "=" + string2;
        }
        return string;
    }
}

