/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType7Subtype11
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int recordSubtypeCode;
    int dataElementLength;
    int numberOfDataElements;
    List<VariableDisplayParams> variableDisplayParams;

    @Override
    public void read(SPSSFile sPSSFile) throws IOException, SPSSFileException {
        this.fileLocation = sPSSFile.getFilePointer();
        this.recordTypeCode = sPSSFile.readSPSSInt();
        if (this.recordTypeCode != 7) {
            throw new SPSSFileException("Error reading record type 7 subtype 11: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 7.");
        }
        this.recordSubtypeCode = sPSSFile.readSPSSInt();
        if (this.recordSubtypeCode != 11) {
            throw new SPSSFileException("Error reading record type 7 subtype 11: bad subrecord type [" + this.recordSubtypeCode + "]. Expecting Record Subtype 11.");
        }
        this.dataElementLength = sPSSFile.readSPSSInt();
        if (this.dataElementLength != 4) {
            throw new SPSSFileException("Error reading record type 7 subtype 11: bad data element length [" + this.dataElementLength + "]. Expecting 4.");
        }
        this.numberOfDataElements = sPSSFile.readSPSSInt();
        int n = this.numberOfDataElements / 3;
        if (this.numberOfDataElements % 3 != 0) {
            throw new SPSSFileException("Error reading record type 7 subtype 11: number of data elements [" + this.dataElementLength + "] is not a multiple of 3.");
        }
        this.variableDisplayParams = new ArrayList<VariableDisplayParams>();
        for (int i = 0; i < n; ++i) {
            VariableDisplayParams variableDisplayParams = new VariableDisplayParams();
            variableDisplayParams.measure = sPSSFile.readSPSSInt();
            variableDisplayParams.width = sPSSFile.readSPSSInt();
            variableDisplayParams.alignment = sPSSFile.readSPSSInt();
            this.variableDisplayParams.add(variableDisplayParams);
        }
    }

    @Override
    public String toString() {
        String string = "";
        string = string + "\nRECORD TYPE 7 SUBTYPE 11 - VARIABLE DISPLAY PARAMETERS";
        string = string + "\nLocation        : " + this.fileLocation;
        string = string + "\nRecord Type     : " + this.recordTypeCode;
        string = string + "\nRecord Subtype  : " + this.recordSubtypeCode;
        string = string + "\nData elements   : " + this.numberOfDataElements;
        string = string + "\nElement length  : " + this.dataElementLength;
        int n = 0;
        for (VariableDisplayParams variableDisplayParams : this.variableDisplayParams) {
            string = string + "\nDisplay params  : Var " + ++n + " Measure=" + variableDisplayParams.measure + " Width=" + variableDisplayParams.width + " Alignment=" + variableDisplayParams.alignment;
        }
        return string;
    }

    public class VariableDisplayParams {
        int measure;
        int width;
        int alignment;
    }
}

