/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.List;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType7Subtype4
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int recordSubtypeCode;
    int dataElementLength;
    int numberOfDataElements;
    double sysmiss;
    double highest;
    double lowest;
    List<byte[]> dataElement;

    @Override
    public void read(SPSSFile sPSSFile) throws IOException, SPSSFileException {
        this.fileLocation = sPSSFile.getFilePointer();
        this.recordTypeCode = sPSSFile.readSPSSInt();
        if (this.recordTypeCode != 7) {
            throw new SPSSFileException("Error reading record type 7 subtype 4: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 7.");
        }
        this.recordSubtypeCode = sPSSFile.readSPSSInt();
        if (this.recordSubtypeCode != 4) {
            throw new SPSSFileException("Error reading record type 7 subtype 4: bad subrecord type [" + this.recordSubtypeCode + "]. Expecting Record Subtype 4.");
        }
        this.dataElementLength = sPSSFile.readSPSSInt();
        if (this.dataElementLength != 8) {
            throw new SPSSFileException("Error reading record type 7 subtype 3: bad data element length [" + this.dataElementLength + "]. Expecting 8.");
        }
        this.numberOfDataElements = sPSSFile.readSPSSInt();
        if (this.numberOfDataElements != 3) {
            throw new SPSSFileException("Error reading record type 7 subtype 3: bad number of data elements [" + this.dataElementLength + "]. Expecting 3.");
        }
        this.sysmiss = sPSSFile.readSPSSDouble();
        this.highest = sPSSFile.readSPSSDouble();
        this.lowest = sPSSFile.readSPSSDouble();
    }

    @Override
    public String toString() {
        String string = "";
        string = string + "\nRECORD TYPE 7 SUBTYPE 4 - RELEASE AND MACHINE SPECIFIC FLOAT INFORMATION";
        string = string + "\nLocation        : " + this.fileLocation;
        string = string + "\nRecord Type     : " + this.recordTypeCode;
        string = string + "\nRecord Subtype  : " + this.recordSubtypeCode;
        string = string + "\nData elements   : " + this.numberOfDataElements;
        string = string + "\nElement length  : " + this.dataElementLength;
        string = string + "\nSysmiss         : " + this.sysmiss;
        string = string + "\nHighest         : " + this.highest;
        string = string + "\nLowest          : " + this.lowest;
        return string;
    }
}

