/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.synthetica;

import com.macrofocus.synthetica.AnimationThreadFactory;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class ImagePainter {
    public static final int STRETCHED = 0;
    public static final int TILED = 1;
    private Graphics g;
    private int x;
    private int y;
    private int w;
    private int h;
    private int iw;
    private int ih;
    private Image image;
    private Insets sInsets;
    private Insets dInsets;
    private int xPolicy;
    private int yPolicy;
    private WeakReference weakComponent;
    private AnimationThreadFactory.AnimationThread animationThread;
    private String id;
    private static long initDuration = -1L;
    private static int initOperations = 0;
    private static long paintDuration = 0L;
    private static int paintOperations = 0;
    private static HashMap imageCache = new HashMap();
    private static boolean debug = System.getProperty("synthetica.debug") != null;
    static Class class$0;
    static Class class$1;

    public ImagePainter(JComponent c, int cycles, int delay, int type, int state, Graphics g, int x, int y, int w, int h, String imagePaths, Insets sourceInsets, Insets destinationInsets, int xPolicy, int yPolicy) {
        this(c, null, cycles, delay, type, state, g, x, y, w, h, imagePaths, sourceInsets, destinationInsets, xPolicy, yPolicy);
    }

    public ImagePainter(JComponent c, String id, int cycles, int delay, int type, int state, Graphics g, int x, int y, int w, int h, String imagePaths, Insets sourceInsets, Insets destinationInsets, int xPolicy, int yPolicy) {
        if (!debug && imagePaths == null) {
            return;
        }
        if (debug && initDuration == -1L) {
            Frame[] frames = Frame.getFrames();
            for (int i = 0; i < frames.length; ++i) {
                if (!(frames[i] instanceof JFrame)) continue;
                ((JFrame)frames[i]).getRootPane().registerKeyboardAction(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("inits: " + initOperations + " in " + initDuration + " ms");
                        System.out.println("paint: " + paintOperations + " in " + paintDuration + " ms");
                        initDuration = 0L;
                        initOperations = 0;
                        paintDuration = 0L;
                        paintOperations = 0;
                        Frame[] frames = Frame.getFrames();
                        for (int i = 0; i < frames.length; ++i) {
                            Frame frame = frames[i];
                            if (!(frame instanceof JFrame) || ((JFrame)frame).getRootPane() == null) continue;
                            frame.setSize(640, 550);
                            frame.validate();
                            ((JFrame)frame).getRootPane().repaint();
                        }
                    }
                }, "durationAction", KeyStroke.getKeyStroke(123, 10), 1);
            }
        }
        long start = System.currentTimeMillis();
        if (id == null) {
            id = "null";
        }
        this.id = id;
        String[] paths = imagePaths.split(",");
        if (c != null && delay > 0) {
            this.weakComponent = new WeakReference<JComponent>(c);
            AnimationThreadFactory.AnimationThread at = AnimationThreadFactory.createThread(delay);
            at.addComponent(c, this.id, state, type, paths, cycles, new Rectangle(x, y, w, h));
            this.animationThread = at;
        }
        this.g = g;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        for (String path : paths) {
            this.image = (Image)imageCache.get(path);
            if (this.image != null) continue;
            URL url = SyntheticaLookAndFeel.class.getResource(path);
            if (url == null) {
                throw new RuntimeException("File not found: " + path);
            }
            ImageIcon ii = new ImageIcon(url);
            this.image = ii.getImage();
            imageCache.put(path, this.image);
        }
        this.iw = this.image.getWidth(null);
        this.ih = this.image.getHeight(null);
        this.sInsets = sourceInsets;
        this.dInsets = destinationInsets;
        this.xPolicy = xPolicy;
        this.yPolicy = yPolicy;
        if (debug) {
            long stop = System.currentTimeMillis();
            long duration = stop - start;
            initDuration += duration;
            ++initOperations;
        }
    }

    public ImagePainter(Graphics g, int x, int y, int w, int h, String imagePath, Insets sourceInsets, Insets destinationInsets, int xPolicy, int yPolicy) {
        this(null, -1, -1, -1, -1, g, x, y, w, h, imagePath, sourceInsets, destinationInsets, xPolicy, yPolicy);
    }

    public ImagePainter(JComponent c, int red, int green, int blue, Insets colorizeInsets, Graphics g, int x, int y, int w, int h, String imagePath, Insets sourceInsets, Insets destinationInsets, int xPolicy, int yPolicy) {
        this(g, x, y, w, h, imagePath, sourceInsets, destinationInsets, xPolicy, yPolicy);
        if (!debug && imagePath == null) {
            return;
        }
        Image image = (Image)imageCache.get(imagePath);
        if (image == null || !(image instanceof BufferedImage)) {
            // empty if block
        }
        this.image = c.createImage(new FilteredImageSource(image.getSource(), new Colorizer(0, red, green, blue, image.getWidth(null), image.getHeight(null), colorizeInsets)));
    }

    public void draw() {
        this.drawBorder();
        this.drawCenter();
    }

    public void drawBorder() {
        this.drawTopLeft();
        this.drawTopCenter();
        this.drawTopRight();
        this.drawLeft();
        this.drawRight();
        this.drawBottomLeft();
        this.drawBottomCenter();
        this.drawBottomRight();
    }

    public void drawCenter() {
        if (this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        if (this.dInsets == null || this.sInsets == null) {
            return;
        }
        this.drawImage(this.image, this.g, this.x + this.dInsets.left, this.y + this.dInsets.top, this.x + this.w - this.dInsets.right, this.y + this.h - this.dInsets.bottom, this.sInsets.left, this.sInsets.top, this.iw - this.sInsets.right, this.ih - this.sInsets.bottom, this.xPolicy, this.yPolicy);
    }

    public void drawTopLeft() {
        if (this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        if (this.dInsets == null || this.sInsets == null) {
            return;
        }
        this.drawImage(this.image, this.g, this.x, this.y, this.x + this.dInsets.left, this.y + this.dInsets.top, 0, 0, this.sInsets.left, this.sInsets.top, 0, 0);
    }

    public void drawTopRight() {
        if (this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        if (this.dInsets == null || this.sInsets == null) {
            return;
        }
        this.drawImage(this.image, this.g, this.x + this.w - this.dInsets.right, this.y, this.x + this.w, this.y + this.dInsets.top, this.iw - this.sInsets.right, 0, this.iw, this.sInsets.top, 0, 0);
    }

    public void drawBottomLeft() {
        if (this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        if (this.dInsets == null || this.sInsets == null) {
            return;
        }
        this.drawImage(this.image, this.g, this.x, this.y + this.h - this.dInsets.bottom, this.x + this.dInsets.left, this.y + this.h, 0, this.ih - this.sInsets.bottom, this.sInsets.left, this.ih, 0, 0);
    }

    public void drawBottomRight() {
        if (this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        if (this.dInsets == null || this.sInsets == null) {
            return;
        }
        this.drawImage(this.image, this.g, this.x + this.w - this.dInsets.right, this.y + this.h - this.dInsets.bottom, this.x + this.w, this.y + this.h, this.iw - this.sInsets.right, this.ih - this.sInsets.bottom, this.iw, this.ih, 0, 0);
    }

    public void drawTopCenter() {
        if (this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        if (this.dInsets == null || this.sInsets == null) {
            return;
        }
        this.drawImage(this.image, this.g, this.x + this.dInsets.left, this.y, this.x + this.w - this.dInsets.right, this.y + this.dInsets.top, this.sInsets.left, 0, this.iw - this.sInsets.right, this.sInsets.top, this.xPolicy, this.yPolicy);
    }

    public void drawLeft() {
        if (this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        if (this.dInsets == null || this.sInsets == null) {
            return;
        }
        this.drawImage(this.image, this.g, this.x, this.y + this.dInsets.top, this.x + this.dInsets.left, this.y + this.h - this.dInsets.bottom, 0, this.sInsets.top, this.sInsets.left, this.ih - this.sInsets.bottom, this.xPolicy, this.yPolicy);
    }

    public void drawRight() {
        if (this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        if (this.dInsets == null || this.sInsets == null) {
            return;
        }
        this.drawImage(this.image, this.g, this.x + this.w - this.dInsets.right, this.y + this.dInsets.top, this.x + this.w, this.y + this.h - this.dInsets.bottom, this.iw - this.sInsets.right, this.sInsets.top, this.iw, this.ih - this.sInsets.bottom, this.xPolicy, this.yPolicy);
    }

    public void drawBottomCenter() {
        if (this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        if (this.dInsets == null || this.sInsets == null) {
            return;
        }
        this.drawImage(this.image, this.g, this.x + this.dInsets.left, this.y + this.h - this.dInsets.bottom, this.x + this.w - this.dInsets.right, this.y + this.h, this.sInsets.left, this.ih - this.sInsets.bottom, this.iw - this.sInsets.right, this.ih, this.xPolicy, this.yPolicy);
    }

    private void drawImage(Image image, Graphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, int xPolicy, int yPolicy) {
        if (image == null) {
            return;
        }
        long start = System.currentTimeMillis();
        if (xPolicy == 0 && yPolicy == 0) {
            g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
        } else {
            int dx = dx1;
            int deltaX = sx2 - sx1;
            int deltaY = sy2 - sy1;
            while (dy1 < dy2) {
                while (dx1 < dx2) {
                    int dx2_ = dx2;
                    if (xPolicy == 1) {
                        dx2_ = Math.min(dx2, dx1 + deltaX);
                    }
                    int dy2_ = dy2;
                    if (yPolicy == 1) {
                        dy2_ = Math.min(dy2, dy1 + deltaY);
                    }
                    int sx2_ = xPolicy != 1 ? sx2 : Math.min(sx2, sx1 + (dx2_ - dx1));
                    int sy2_ = yPolicy != 1 ? sy2 : Math.min(sy2, sy1 + (dy2_ - dy1));
                    g.drawImage(image, dx1, dy1, dx2_, dy2_, sx1, sy1, sx2_, sy2_, null);
                    if (xPolicy == 0) break;
                    dx1 += deltaX;
                }
                if (yPolicy == 0) break;
                dx1 = dx;
                dy1 += deltaY;
            }
        }
        long stop = System.currentTimeMillis();
        long duration = stop - start;
        if (debug && duration > 100L) {
            System.out.println("Paint performance lack: " + duration + " ms " + this.findImage(image));
        }
        paintDuration += duration;
        ++paintOperations;
    }

    private String findImage(Image image) {
        String path = null;
        Set entries = imageCache.entrySet();
        for (Map.Entry entry : entries) {
            if (entry.getValue() != image) continue;
            path = (String)entry.getKey();
            break;
        }
        return path;
    }

    private BufferedImage toCompatibleImage(Image image) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        BufferedImage compatibleImage = c.createCompatibleImage(image.getWidth(null), image.getHeight(null));
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    private static class Colorizer
    extends RGBImageFilter {
        private int a;
        private int r;
        private int g;
        private int b;
        private int w;
        private int h;
        private Insets insets;

        @Override
        public int filterRGB(int x, int y, int rgb) {
            if (x < this.insets.left || x > this.w - this.insets.right - 1 || y < this.insets.top || y > this.h - this.insets.bottom - 1) {
                return rgb;
            }
            Color c = new Color(rgb, true);
            int red = Math.min(Math.max(c.getRed() + c.getRed() * this.r / 100, 0), 255);
            int green = Math.min(Math.max(c.getGreen() + c.getGreen() * this.g / 100, 0), 255);
            int blue = Math.min(Math.max(c.getBlue() + c.getBlue() * this.b / 100, 0), 255);
            int alpha = Math.min(Math.max(c.getAlpha() + c.getAlpha() * this.a / 100, 0), 255);
            return new Color(red, green, blue, alpha).getRGB();
        }

        public Colorizer(int alpha, int r, int g, int b, int w, int h, Insets insets) {
            this.canFilterIndexColorModel = true;
            this.a = alpha;
            this.r = r;
            this.g = g;
            this.b = b;
            this.w = w;
            this.h = h;
            this.insets = insets;
        }
    }
}

