/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.Dockbar;
import de.javasoft.docking.controls.DockbarManager;
import de.javasoft.docking.controls.DockbarSlidePanel;
import de.javasoft.docking.controls.DockingUtility;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.InsetBorder;
import de.javasoft.docking.controls.RootWindow;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

class DockbarLayout {
    private DockbarManager manager;
    private JComponent leftPlacementGuide;
    private JComponent rightPlacementGuide;
    private JComponent bottomPlacementGuide;

    public DockbarLayout(DockbarManager mgr) {
        this.manager = mgr;
    }

    public void layout() {
        this.updateInsets();
        Rectangle rect = this.getLayoutArea(this.manager);
        int rightX = rect.x + rect.width;
        int bottomY = rect.y + rect.height;
        Dockbar leftBar = this.manager.getLeftBar();
        Dockbar rightBar = this.manager.getRightBar();
        Dockbar bottomBar = this.manager.getBottomBar();
        Dimension leftPref = leftBar.getPreferredSize();
        Dimension rightPref = rightBar.getPreferredSize();
        Dimension bottomPref = bottomBar.getPreferredSize();
        leftBar.setBounds(rect.x, rect.y, leftPref.width, rect.height - bottomPref.height);
        rightBar.setBounds(rightX - rightPref.width, rect.y, rightPref.width, rect.height - bottomPref.height);
        bottomBar.setBounds(rect.x, bottomY - bottomPref.height, rect.width, bottomPref.height);
        this.layoutSlidePanel();
    }

    public int getDesiredViewpaneSize() {
        IDockable dockable = this.manager.getActiveDockable();
        if (dockable == null) {
            return 0;
        }
        Rectangle rect = this.getViewArea(this.manager, dockable);
        float viewSize = dockable.getPreviewSize();
        int placement = this.manager.getActivePlacement();
        if (placement == 2 || placement == 4) {
            return (int)((float)rect.width * viewSize);
        }
        return (int)((float)rect.height * viewSize);
    }

    protected void layoutSlidePanel() {
        DockbarSlidePanel slidePanel = this.manager.getSlidePanel();
        IDockable dockable = this.manager.getActiveDockable();
        if (dockable == null) {
            slidePanel.setBounds(0, 0, 0, 0);
            return;
        }
        int placement = this.manager.getActivePlacement();
        int slidePanelSize = slidePanel.getPrefSize();
        if (slidePanelSize == -1) {
            slidePanelSize = this.getDesiredViewpaneSize();
        }
        Rectangle rect = this.getViewArea(this.manager, dockable);
        if (placement == 2 || placement == 4) {
            if (placement == 4) {
                rect.x = rect.x + rect.width - slidePanelSize;
            }
            rect.width = slidePanelSize;
        } else {
            if (placement == 3) {
                rect.y = rect.y + rect.height - slidePanelSize;
            }
            rect.height = slidePanelSize;
        }
        slidePanel.setBounds(rect);
    }

    private void updateInsets() {
        Insets emptyInsets = this.getEmptyInsets();
        boolean changed = this.resetGuideBorders();
        HashSet borderSet = new HashSet(3);
        this.add(borderSet, this.getInsetBorder(2));
        this.add(borderSet, this.getInsetBorder(4));
        this.add(borderSet, this.getInsetBorder(3));
        HashSet guideSet = new HashSet(3);
        this.add(guideSet, this.getCurrentPlacementGuide(2));
        this.add(guideSet, this.getCurrentPlacementGuide(4));
        this.add(guideSet, this.getCurrentPlacementGuide(3));
        for (InsetBorder border : borderSet) {
            boolean bl = changed = border.setEmptyInsets(emptyInsets) || changed;
        }
        if (changed) {
            for (JComponent guide : guideSet) {
                guide.revalidate();
            }
        }
    }

    private <T> void add(Set<T> set, T obj) {
        if (obj != null) {
            set.add(obj);
        }
    }

    private boolean resetGuideBorders() {
        boolean changed = this.resetGuide(2);
        changed = this.resetGuide(4) || changed;
        changed = this.resetGuide(3) || changed;
        this.toggleInsetBorder(2);
        this.toggleInsetBorder(4);
        this.toggleInsetBorder(3);
        return changed;
    }

    private boolean resetGuide(int placement) {
        InsetBorder insetBorder;
        JComponent currGuide = this.getCurrentPlacementGuide(placement);
        JComponent newGuide = this.queryPlacementGuide(placement);
        boolean changed = false;
        if (DockingUtility.isChanged(currGuide, newGuide)) {
            InsetBorder fakeBorder;
            changed = true;
            Border b = currGuide == null ? null : currGuide.getBorder();
            InsetBorder insetBorder2 = fakeBorder = b instanceof InsetBorder ? (InsetBorder)b : null;
            if (fakeBorder != null) {
                Border realBorder = fakeBorder.getWrappedBorder();
                currGuide.setBorder(realBorder);
                fakeBorder.togglePlacement(placement, false);
            }
        }
        if (newGuide == null) {
            return this.setCurrentPlacementGuide(placement, newGuide) || changed;
        }
        Border border = newGuide.getBorder();
        if (!(border instanceof InsetBorder)) {
            changed = true;
            insetBorder = InsetBorder.createBorder(border, true, SyntheticaLookAndFeel.getInstance().scaleInsets(-1, -1, -1, -1));
            newGuide.setBorder(insetBorder);
        }
        insetBorder = (InsetBorder)newGuide.getBorder();
        insetBorder.clearPlacements();
        return this.setCurrentPlacementGuide(placement, newGuide) || changed;
    }

    private void toggleInsetBorder(int placement) {
        InsetBorder border = this.getInsetBorder(placement);
        if (border != null) {
            border.togglePlacement(placement, true);
        }
    }

    private InsetBorder getInsetBorder(int placement) {
        JComponent comp = this.getCurrentPlacementGuide(placement);
        Border border = comp == null ? null : comp.getBorder();
        return border instanceof InsetBorder ? (InsetBorder)border : null;
    }

    private Insets getEmptyInsets() {
        return new Insets(0, this.getLeftInset(), this.getBottomInset(), this.getRightInset());
    }

    private int getLeftInset() {
        return this.getDockbarInset(this.manager.getLeftBar());
    }

    private int getRightInset() {
        return this.getDockbarInset(this.manager.getRightBar());
    }

    private int getBottomInset() {
        return this.getDockbarInset(this.manager.getBottomBar());
    }

    private int getDockbarInset(Dockbar dockbar) {
        boolean visible = dockbar.isVisible();
        if (!visible) {
            return 0;
        }
        Dimension dim = dockbar.getPreferredSize();
        if (dockbar == this.manager.getLeftBar() || dockbar == this.manager.getRightBar()) {
            return dim.width;
        }
        return dim.height;
    }

    private JComponent queryPlacementGuide(int constraint) {
        return this.getPlacementGuide(this.manager, constraint);
    }

    private JComponent getCurrentPlacementGuide(int constraint) {
        switch (constraint) {
            case 2: {
                return this.leftPlacementGuide;
            }
            case 4: {
                return this.rightPlacementGuide;
            }
            case 3: {
                return this.bottomPlacementGuide;
            }
        }
        return null;
    }

    private boolean setCurrentPlacementGuide(int constraint, JComponent comp) {
        boolean changed = this.getCurrentPlacementGuide(constraint) == comp;
        switch (constraint) {
            case 2: {
                this.leftPlacementGuide = comp;
                break;
            }
            case 4: {
                this.rightPlacementGuide = comp;
                break;
            }
            case 3: {
                this.bottomPlacementGuide = comp;
            }
        }
        return changed;
    }

    public Rectangle getViewArea(DockbarManager mgr, IDockable dockable) {
        if (mgr == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle leftBar = mgr.getLeftBar().getBounds();
        Rectangle bottomBar = mgr.getBottomBar().getBounds();
        Rectangle rightBar = mgr.getRightBar().getBounds();
        return new Rectangle(leftBar.x + leftBar.width, leftBar.y, bottomBar.width - leftBar.width - rightBar.width, leftBar.height);
    }

    public Rectangle getLayoutArea(DockbarManager mgr) {
        RootWindow rw;
        Rectangle rect = new Rectangle();
        RootWindow rootWindow = rw = mgr == null ? null : mgr.getRootWindow();
        if (rw == null) {
            return rect;
        }
        JLayeredPane layeredPane = rw.getLayeredPane();
        JComponent leftPlacement = this.getPlacementGuide(mgr, 2);
        JComponent rightPlacement = this.getPlacementGuide(mgr, 4);
        JComponent bottomPlacement = this.getPlacementGuide(mgr, 3);
        JComponent topPlacement = this.getPlacementGuide(mgr, 1);
        Rectangle leftBounds = SwingUtilities.convertRectangle(leftPlacement.getParent(), leftPlacement.getBounds(), layeredPane);
        Rectangle rightBounds = SwingUtilities.convertRectangle(rightPlacement.getParent(), rightPlacement.getBounds(), layeredPane);
        Rectangle bottomBounds = SwingUtilities.convertRectangle(bottomPlacement.getParent(), bottomPlacement.getBounds(), layeredPane);
        Rectangle topBounds = SwingUtilities.convertRectangle(topPlacement.getParent(), topPlacement.getBounds(), layeredPane);
        int rightX = rightBounds.x + rightBounds.width;
        int bottomY = bottomBounds.y + bottomBounds.height;
        rect.x = leftBounds.x;
        rect.y = topBounds.y;
        rect.width = rightX - rect.x;
        rect.height = bottomY - rect.y;
        return rect;
    }

    public JComponent getPlacementGuide(DockbarManager mgr, int placement) {
        RootWindow rw = mgr == null ? null : mgr.getRootWindow();
        Container comp = rw == null ? null : rw.getContentPane();
        return comp instanceof JComponent ? (JComponent)comp : null;
    }
}

