/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.FloatingDialog;
import de.javasoft.docking.controls.FloatingFrame;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.RootWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

class DockingPortTracker
implements HierarchyListener,
AncestorListener {
    private static final DockingPortTracker INSTANCE = new DockingPortTracker();
    private static WeakHashMap<RootWindow, RootDockingPortList> ROOT_PORTS_BY_WINDOW = new WeakHashMap();
    private static WeakHashMap<IDockingPort, Object> ALL_PORTS = new WeakHashMap();
    private static final Object DUMMY = new Object();

    private DockingPortTracker() {
    }

    static DockingPortTracker getInstance() {
        return INSTANCE;
    }

    private static List<IDockingPort> getDockingPorts() {
        return new ArrayList<IDockingPort>(ALL_PORTS.keySet());
    }

    static void addDockingPort(IDockingPort port) {
        ALL_PORTS.put(port, DUMMY);
        RootDockingPortList list = DockingPortTracker.getRootPortList(port);
        if (list != null) {
            list.remove(port);
            list.add(port);
        }
    }

    public static IDockingPort getRootDockingPort(Window w, boolean includeFloatingFrames) {
        RootWindow rootWindow = RootWindow.getRootWindow(w);
        if (rootWindow != null) {
            return DockingPortTracker.getRootDockingPort(rootWindow.getWindow());
        }
        for (IDockingPort port : DockingPortTracker.getRootDockingPorts()) {
            boolean isFloating;
            Window win = SwingUtilities.getWindowAncestor(port.getComponent());
            boolean bl = isFloating = win instanceof FloatingDialog || win instanceof FloatingFrame;
            if (!includeFloatingFrames && isFloating || port.getComponent().getParent() == null) continue;
            return port;
        }
        return null;
    }

    private static List<IDockingPort> getRootDockingPorts() {
        ArrayList<IDockingPort> rootPorts = new ArrayList<IDockingPort>();
        for (IDockingPort port : DockingPortTracker.getDockingPorts()) {
            if (!port.isRoot()) continue;
            rootPorts.add(port);
        }
        return rootPorts;
    }

    public static IDockingPort getRootDockingPort(Component comp) {
        Component c = comp;
        IDockingPort port = null;
        while (c != null) {
            if (c instanceof IDockingPort && ((IDockingPort)((Object)c)).isRoot()) {
                port = (IDockingPort)((Object)c);
            }
            c = c.getParent();
        }
        if (port == null) {
            RootDockingPortList list = DockingPortTracker.getRootPortList(RootWindow.getRootWindow(comp));
            port = list == null ? null : list.getFirstPort();
        }
        return port;
    }

    static IDockingPort getRootDockingPort(String portID) {
        for (RootDockingPortList list : ROOT_PORTS_BY_WINDOW.values()) {
            IDockingPort port = list.getPortByID(portID);
            if (port == null) continue;
            return port;
        }
        return null;
    }

    private void rootPortAdded(RootWindow rw, IDockingPort port) {
        RootDockingPortList list = DockingPortTracker.getRootPortList(rw);
        if (list != null) {
            list.add(port);
        }
    }

    private void rootPortRemoved(RootWindow rw, IDockingPort port) {
        RootDockingPortList list = DockingPortTracker.getRootPortList(rw);
        if (list != null) {
            list.remove(port);
        }
        DockingManager.removeMaximizedState(port);
    }

    private static RootDockingPortList getRootPortList(RootWindow rootWindow) {
        if (rootWindow == null) {
            return null;
        }
        RootDockingPortList list = ROOT_PORTS_BY_WINDOW.get(rootWindow);
        if (list == null) {
            list = new RootDockingPortList();
            ROOT_PORTS_BY_WINDOW.put(rootWindow, list);
        }
        return list;
    }

    private static RootDockingPortList getRootPortList(IDockingPort port) {
        for (RootDockingPortList list : ROOT_PORTS_BY_WINDOW.values()) {
            if (!list.contains(port)) continue;
            return list;
        }
        return null;
    }

    static List<RootWindow> getDockingPortRootWindows() {
        return new ArrayList<RootWindow>(ROOT_PORTS_BY_WINDOW.keySet());
    }

    static void removeRootPortsForWindow(RootWindow w) {
        ROOT_PORTS_BY_WINDOW.remove(w);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent evt) {
        IDockingPort port = (IDockingPort)evt.getSource();
        if (!port.isRoot()) {
            return;
        }
        if (!this.isParentChange(evt)) {
            return;
        }
        Container changedParent = evt.getChangedParent();
        RootWindow window = RootWindow.getRootWindow(changedParent);
        if (window == null) {
            return;
        }
        if (evt.getChanged().getParent() == null) {
            this.rootPortRemoved(window, port);
        } else {
            this.rootPortAdded(window, port);
        }
    }

    private boolean isParentChange(HierarchyEvent evt) {
        return evt.getID() == 1400 && evt.getChangeFlags() == 1L;
    }

    @Override
    public void ancestorAdded(AncestorEvent evt) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent evt) {
        IDockingPort port = (IDockingPort)((Object)evt.getComponent());
        RootWindow window = RootWindow.getRootWindow(port.getComponent());
        if (!port.isRoot() || window == null || !(evt.getAncestor() instanceof IDockingPort)) {
            return;
        }
        this.rootPortRemoved(window, port);
    }

    @Override
    public void ancestorMoved(AncestorEvent evt) {
    }

    private static class RootDockingPortList {
        private ArrayList<IDockingPort> rootPorts = new ArrayList(2);

        public void add(IDockingPort port) {
            if (!this.rootPorts.contains(port)) {
                this.rootPorts.add(port);
            }
        }

        public void remove(IDockingPort port) {
            this.rootPorts.remove(port);
        }

        public boolean contains(IDockingPort port) {
            return this.rootPorts.contains(port);
        }

        public IDockingPort getFirstPort() {
            return this.rootPorts.isEmpty() ? null : this.rootPorts.get(0);
        }

        public IDockingPort getPortByID(String portID) {
            for (IDockingPort port : this.rootPorts) {
                if (!port.getID().equals(portID)) continue;
                return port;
            }
            return null;
        }
    }
}

