/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.IDockingStrategy;
import java.util.WeakHashMap;

class DockingStrategyClassMapping {
    private Class<? extends IDockingStrategy> defaultStrategyClass;
    private WeakHashMap<Class<?>, Class<? extends IDockingStrategy>> strategyClasses;
    private IDockingStrategy defaultStrategy;
    private WeakHashMap<Class<?>, IDockingStrategy> strategies;

    public DockingStrategyClassMapping(Class<? extends IDockingStrategy> defaultStrategyClass, IDockingStrategy defaultStrategy) {
        this.defaultStrategyClass = defaultStrategyClass;
        this.defaultStrategy = defaultStrategy;
        this.strategyClasses = new WeakHashMap(4);
        this.strategies = new WeakHashMap(4);
    }

    public void addStrategyClassMapping(Class<?> clazz, Class<? extends IDockingStrategy> strategyClass, IDockingStrategy strategy) {
        this.strategyClasses.put(clazz, strategyClass);
        if (strategy != null) {
            this.strategies.put(clazz, strategy);
        }
    }

    public Class<? extends IDockingStrategy> removeStrategyClassMapping(Class<?> clazz) {
        Class<? extends IDockingStrategy> strategyClass = this.strategyClasses.remove(clazz);
        this.strategies.remove(clazz);
        return strategyClass;
    }

    public Class<? extends IDockingStrategy> getStrategyClass(Class<?> clazz) {
        if (clazz == null) {
            return this.defaultStrategyClass;
        }
        Class<? extends IDockingStrategy> value = null;
        Class<?> c = clazz;
        while (c != null && value == null) {
            value = this.strategyClasses.get(c);
            c = c.getSuperclass();
        }
        return value == null ? this.defaultStrategyClass : value;
    }

    public IDockingStrategy getStrategy(Class<?> key) {
        if (key == null) {
            return this.defaultStrategy;
        }
        IDockingStrategy value = null;
        Class<?> c = key;
        while (c != null && value == null) {
            value = this.strategies.get(c);
            c = c.getSuperclass();
        }
        return value == null ? this.defaultStrategy : value;
    }

    public Class<?> getDefaultStrategyClass() {
        return this.defaultStrategyClass;
    }

    public IDockingStrategy getDefaultStrategy() {
        return this.defaultStrategy;
    }
}

