/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DragManager;
import de.javasoft.docking.controls.IDockable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JTabbedPane;

class DragTabListener
extends MouseAdapter
implements MouseMotionListener {
    private DragManager dragListener;

    DragTabListener() {
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (this.dragListener != null) {
            this.dragListener.mouseDragged(evt);
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (this.dragListener != null) {
            this.dragListener.mouseReleased(evt);
        }
        this.dragListener = null;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        JTabbedPane pane = (JTabbedPane)evt.getSource();
        int tabIndex = pane.getSelectedIndex();
        if (tabIndex < 0) {
            this.dragListener = null;
        } else {
            IDockable dockable = DockingManager.getDockable(pane.getComponentAt(tabIndex));
            this.dragListener = DockingManager.getDragListener(dockable);
            if (this.dragListener != null) {
                this.dragListener.mousePressed(evt);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }
}

