/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingState;
import de.javasoft.docking.controls.FloatingDialog;
import de.javasoft.docking.controls.FloatingFrame;
import de.javasoft.docking.controls.FloatingGroup;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.IFloatingDockingPort;
import de.javasoft.docking.controls.IPerspectiveListener;
import de.javasoft.docking.controls.IPerspectiveManager;
import de.javasoft.docking.controls.PerspectiveEvent;
import de.javasoft.docking.controls.PerspectiveManager;
import de.javasoft.docking.controls.PerspectiveModel;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Perspective
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6808527338470585077L;
    private String id;
    private String name;
    private PerspectiveModel model;
    private List<IPerspectiveListener> listeners = new ArrayList<IPerspectiveListener>();
    private boolean loading;
    private boolean unloading;

    public Perspective(String id, String name) {
        if (id == null) {
            throw new IllegalArgumentException("persistentId cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("perspectiveName cannot be null");
        }
        this.id = id;
        this.name = name;
        this.model = new PerspectiveModel();
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.id;
    }

    public boolean addPerspectiveListener(IPerspectiveListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removePerspectiveListener(IPerspectiveListener listener) {
        return this.listeners.remove(listener);
    }

    public List<IPerspectiveListener> getPerspectiveListeners() {
        return this.listeners;
    }

    public PerspectiveModel getModel() {
        return this.model;
    }

    public void setModel(PerspectiveModel model) {
        this.model = model;
    }

    DockingState getDockingState(IDockable dockable, boolean load) {
        return this.getModel().getDockingState(dockable, load);
    }

    DockingState getDockingState(String dockableID, boolean load) {
        return this.getModel().getDockingState(dockableID, load);
    }

    public void add(IDockable dockable) {
        this.getModel().add(dockable);
    }

    public void add(IDockable dockable, IDockable relativeParent, String region, float ratio) {
        this.getModel().add(dockable, relativeParent, region, ratio);
    }

    public void reset(IDockingPort port) {
        PerspectiveModel model = this.getModel();
        if (this.getModel() != null) {
            this.apply(port);
            model.updateDockingStates();
            PerspectiveManager.dispatchEvent(new PerspectiveEvent(this, 3));
        }
    }

    private void apply(IDockingPort port) {
        boolean listen = PerspectiveManager.isDockingStateListening();
        PerspectiveManager.setDockingStateListening(false);
        PerspectiveManager.clear(port);
        List<DockingState> sequence = this.getModel().getDockableSequence();
        int len = sequence.size();
        IDockable[] dockables = new IDockable[len];
        int i = 0;
        while (i < len) {
            IDockable dockable;
            DockingState state = sequence.get(i);
            dockables[i] = dockable = DockingManager.getDockable(state.getDockableID());
            String region = state.getRegion();
            if (i == 0) {
                DockingManager.dock(dockable, port, this, state.getRegion());
            } else {
                IDockable parent = DockingManager.getDockable(state.getRelativeParentID());
                float ratio = state.getSplitRatio();
                DockingManager.dockRelative(dockable, parent, this, region, ratio);
            }
            ++i;
        }
        PerspectiveManager.setDockingStateListening(listen);
        PerspectiveManager.updateDockingStates(dockables);
    }

    void load(IDockingPort port) {
        PerspectiveModel model = this.getModel();
        if (model.isInitialized()) {
            this.loading = true;
            model.apply(port, this);
            PerspectiveManager.dispatchEvent(new PerspectiveEvent(this, 3));
            this.loading = false;
        } else if (port != null) {
            this.reset(port);
        }
    }

    void loadFloatingGroup(IDockingPort port, String floatingGroupID) {
        PerspectiveModel model = this.getModel();
        if (model.isInitialized()) {
            this.loading = true;
            model.applyFloatingGroup(port, this, floatingGroupID);
            PerspectiveManager.dispatchEvent(new PerspectiveEvent(this, 3));
            this.loading = false;
        }
    }

    boolean isLoading() {
        return this.loading;
    }

    boolean isUnloading() {
        return this.unloading;
    }

    void unload() {
        this.unloading = true;
        IDockable[] dockables = this.getModel().getDockables();
        int i = 0;
        while (i < dockables.length) {
            DockingManager.close(dockables[i], this, false);
            ++i;
        }
        this.unloading = false;
    }

    void updateRestorationLayoutNode(IDockingPort port) {
        this.updateRestorationLayoutNode(port, true);
    }

    void updateRestorationLayoutNode(IDockingPort port, boolean includeFloating) {
        if (port == null) {
            return;
        }
        IDockable dockable = DockingManager.getDockable(port.getDockedComponent());
        boolean maximized = dockable == null ? false : DockingManager.isMaximized(dockable);
        IPerspectiveManager pm = DockingManager.getPerspectiveManager();
        if (!maximized) {
            this.getModel().setRestorationLayout(pm.createLayoutModel(port));
        }
        if (includeFloating) {
            String[] stringArray = this.model.getFloatingGroupIDs();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                FloatingGroup group = this.getModel().getFloatingGroup(id);
                IFloatingDockingPort floatingPort = this.getFloatingPortByID(id, group);
                this.updateFloatingRestorationLayoutNode(floatingPort, group);
                ++n2;
            }
        }
    }

    void updateFloatingRestorationLayoutNode(IFloatingDockingPort floatingPort, FloatingGroup group) {
        boolean maximized;
        if (floatingPort == null) {
            return;
        }
        IDockable dockable = DockingManager.getDockable(floatingPort.getDockedComponent());
        boolean bl = maximized = dockable == null ? false : DockingManager.isMaximized(dockable);
        if (!maximized) {
            group.setRestorationLayout(DockingManager.getPerspectiveManager().createLayoutModel(floatingPort));
        }
    }

    IFloatingDockingPort getFloatingPortByID(String floatingPortID, FloatingGroup group) {
        Window w = group.getFloatingWindow();
        IFloatingDockingPort floatingPort = null;
        if (w instanceof FloatingDialog) {
            floatingPort = (IFloatingDockingPort)((FloatingDialog)w).getDockingPort();
        } else if (w instanceof FloatingFrame) {
            floatingPort = (IFloatingDockingPort)((FloatingFrame)w).getDockingPort();
        }
        return floatingPort;
    }

    public Object clone() {
        Perspective clone = new Perspective(this.id, this.name);
        clone.model = (PerspectiveModel)this.model.clone();
        return clone;
    }
}

