/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockbarManager;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingPortTracker;
import de.javasoft.docking.controls.FloatingDialog;
import de.javasoft.docking.controls.FloatingFrame;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.PerspectiveManager;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;

class RootWindow {
    private static Map<Window, RootWindow> rootWindows = new WeakHashMap<Window, RootWindow>();
    private HashMap<Object, Object> clientProperties;
    private Window window;
    private String perspectiveID = DockingManager.getPerspectiveManager().getCurrentPerspective().getID();

    protected RootWindow(Window window) {
        this.setWindow(window);
        this.clientProperties = new HashMap();
    }

    public static RootWindow getRootWindow(Component c) {
        Component root = RootWindow.getRoot(c);
        if (!RootWindow.isValidRootContainer(root)) {
            return null;
        }
        Window window = (Window)root;
        RootWindow rootWindow = rootWindows.get(window);
        if (rootWindow == null) {
            rootWindow = new RootWindow(window);
            rootWindows.put(window, rootWindow);
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent evt) {
                    RootWindow rw = (RootWindow)rootWindows.get(RootWindow.getRoot(evt.getComponent()));
                    if (rw != null) {
                        DockbarManager.removeDockbarManager(rw);
                        DockingPortTracker.removeRootPortsForWindow(rw);
                        rootWindows.remove(evt.getComponent());
                        rw.window.removeWindowListener(this);
                        rw.window = null;
                    }
                }

                @Override
                public void windowActivated(WindowEvent evt) {
                    String id = RootWindow.getRootWindow(evt.getComponent()).getPerspectiveID();
                    boolean valid = PerspectiveManager.getInstance().perspectiveIsValid(id);
                    PerspectiveManager.setCurrentPerspectiveID(valid ? id : "PerspectiveManager.DefaultPerspective");
                }
            });
        }
        if (rootWindow.getWindow() != window) {
            rootWindow.setWindow(window);
        }
        return rootWindow;
    }

    private static Component getRoot(Component c) {
        if (c == null) {
            return null;
        }
        if (RootWindow.isValidRootContainer(c)) {
            return c;
        }
        Container parent = c.getParent();
        while (parent != null && !RootWindow.isValidRootContainer(parent)) {
            parent = parent.getParent();
        }
        return parent;
    }

    public boolean isAlive() {
        return rootWindows.containsValue(this);
    }

    public static boolean isValidRootContainer(Component c) {
        return c != null && (c instanceof JFrame || c instanceof JWindow || c instanceof JDialog);
    }

    public static RootWindow[] getVisibleWindows() {
        Frame[] frames = Frame.getFrames();
        ArrayList<RootWindow> cache = new ArrayList<RootWindow>(frames.length);
        Frame[] frameArray = frames;
        int n = frames.length;
        int n2 = 0;
        while (n2 < n) {
            Frame f = frameArray[n2];
            if (SyntheticaLookAndFeel.findComponent(IDockingPort.class, (Container)f) != null) {
                RootWindow.populateWindowList(new RootWindow(f), cache, true);
            }
            ++n2;
        }
        return cache.toArray(new RootWindow[0]);
    }

    private static void populateWindowList(RootWindow rw, ArrayList<RootWindow> winCache, boolean visOnly) {
        if (rw == null || winCache.contains(rw)) {
            return;
        }
        if (visOnly && !rw.isVisible()) {
            return;
        }
        winCache.add(rw);
        Window[] children = rw.getOwnedWindows();
        int i = 0;
        while (i < children.length) {
            if (SyntheticaLookAndFeel.findComponent(IDockingPort.class, (Container)children[i]) != null) {
                RootWindow.populateWindowList(new RootWindow(children[i]), winCache, visOnly);
            }
            ++i;
        }
    }

    public static Window getMainWindow() {
        Window w = null;
        RootWindow[] rootWindowArray = RootWindow.getVisibleWindows();
        int n = rootWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            RootWindow rw = rootWindowArray[n2];
            Window w_ = rw.getWindow();
            if (!(w_ instanceof FloatingFrame) && !(w_ instanceof FloatingDialog) && w_ instanceof Window) {
                w = w_;
            }
            ++n2;
        }
        return w;
    }

    public static RootWindow getMainRootWindow() {
        return RootWindow.getRootWindow(RootWindow.getMainWindow());
    }

    protected void setWindow(Window window) {
        this.window = window;
    }

    public Window getWindow() {
        return this.window;
    }

    public void setPerspectiveID(String id) {
        this.perspectiveID = id;
    }

    public String getPerspectiveID() {
        return this.perspectiveID;
    }

    public JRootPane getRootPane() {
        JRootPane pane = null;
        if (this.window instanceof RootPaneContainer) {
            pane = ((RootPaneContainer)((Object)this.window)).getRootPane();
        }
        return pane;
    }

    public void setContentPane(Container contentPane) {
        if (this.window instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)this.window)).setContentPane(contentPane);
        }
    }

    public Container getContentPane() {
        Container c = null;
        if (this.window instanceof RootPaneContainer) {
            c = ((RootPaneContainer)((Object)this.window)).getContentPane();
        }
        return c;
    }

    public void revalidateContentPane() {
        Container c = this.getContentPane();
        if (c instanceof JComponent) {
            ((JComponent)c).revalidate();
        }
    }

    public void setGlassPane(Component glassPane) {
        if (this.window instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)this.window)).setGlassPane(glassPane);
        }
    }

    public Component getGlassPane() {
        Component c = null;
        if (this.window instanceof RootPaneContainer) {
            c = ((RootPaneContainer)((Object)this.window)).getGlassPane();
        }
        return c;
    }

    public void setLayeredPane(JLayeredPane layeredPane) {
        if (this.window instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)this.window)).setLayeredPane(layeredPane);
        }
    }

    public JLayeredPane getLayeredPane() {
        JLayeredPane pane = null;
        if (this.window instanceof RootPaneContainer) {
            pane = ((RootPaneContainer)((Object)this.window)).getLayeredPane();
        }
        return pane;
    }

    public Window[] getOwnedWindows() {
        return this.window.getOwnedWindows();
    }

    public void pack() {
        this.window.pack();
    }

    public void toFront() {
        this.window.toFront();
    }

    public boolean isActive() {
        return this.window.isActive();
    }

    public boolean isVisible() {
        return this.window.isVisible();
    }

    public Window getOwner() {
        return this.window.getOwner();
    }

    public void putClientProperty(Object key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.clientProperties.remove(key);
        } else {
            this.clientProperties.put(key, value);
        }
    }

    public Object getClientProperty(Object key) {
        return key == null ? null : this.clientProperties.get(key);
    }
}

