/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.license.SimpleLicenseModel;
import com.treemap.Aggregation;
import com.treemap.Algorithm;
import com.treemap.Depth;
import com.treemap.Labeling;
import com.treemap.Nesting;
import com.treemap.Ordering;
import com.treemap.Rendering;
import com.treemap.Scale;
import com.treemap.TreeMap;
import com.treemap.TreeMapController;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;

@JsType
public abstract class AbstractTreeMap<C, N, Row, Column, Color, Font>
implements TreeMap<C, N, Row, Column, Color, Font> {
    protected TreeMapView<C, N, Row, Column, Color, Font> view;
    protected TreeMapController<C, N, Row, Column, Color, Font> controller;
    private TreeMapModel<N, Row, Column, Color, Font> a;
    protected static LicenseModel licenseModel;

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.TREEMAP_API, username, key);
    }

    @Override
    public TreeMapModel<N, Row, Column, Color, Font> getModel() {
        return this.a;
    }

    @Override
    public void setModel(TreeMapModel<N, Row, Column, Color, Font> model) {
        if (this.a != model) {
            this.a = model;
            if (this.view != null) {
                this.view.setModel(model);
            }
        }
    }

    @Override
    @JsMethod
    public TreeMapView<C, N, Row, Column, Color, Font> getView() {
        return this.view;
    }

    @Override
    public void setView(TreeMapView<C, N, Row, Column, Color, Font> view) {
        if (this.view != view) {
            if (this.view != null) {
                this.view.setModel(null);
            }
            this.view = view;
            if (view != null) {
                view.setModel(this.a);
                this.view.setLicenseModel(licenseModel);
            }
        }
    }

    @Override
    public TreeMapController<C, N, Row, Column, Color, Font> getController() {
        return this.controller;
    }

    @Override
    public void setController(TreeMapController<C, N, Row, Column, Color, Font> controller) {
        if (this.controller != controller) {
            if (this.controller != null) {
                this.controller.setView(null);
            }
            this.controller = controller;
            if (controller != null) {
                controller.setView(this.view);
            }
        }
    }

    @Override
    public void setGroupBy(int ... columns) {
        this.a.getSettings().setGroupBy(columns);
    }

    @Override
    public void setGroupByByNames(String ... columnNames) {
        this.a.getSettings().setGroupByByNames(columnNames);
    }

    @Override
    public void setLabels(int ... columns) {
        this.a.getSettings().setLabels(columns);
    }

    @Override
    public void setLabelsByNames(String ... columnNames) {
        this.a.getSettings().setLabelsByNames(columnNames);
    }

    @Override
    public void setBackground(int column) {
        this.a.getSettings().setBackground(column);
    }

    @Override
    public void setBackgroundByName(String columnName) {
        this.a.getSettings().setBackgroundByName(columnName);
    }

    @Override
    public void setSize(int column) {
        this.a.getSettings().setSize(column);
    }

    @Override
    public void setSizeByName(String columnName) {
        this.a.getSettings().setSizeByName(columnName);
    }

    @Override
    public void setColor(int column) {
        this.a.getSettings().setColor(column);
    }

    @Override
    public void setColorByName(String columnName) {
        this.a.getSettings().setColorByName(columnName);
    }

    @Override
    public void setHeight(int column) {
        this.a.getSettings().setHeight(column);
    }

    @Override
    public void setHeightByName(String columnName) {
        this.a.getSettings().setHeightByName(columnName);
    }

    @Override
    public void setToolTip(int ... columns) {
        this.a.getSettings().setToolTip(columns);
    }

    @Override
    public void setToolTipByNames(String ... columnNames) {
        this.a.getSettings().setToolTipByNames(columnNames);
    }

    @Override
    public void setAlgorithm(Algorithm algorithm) {
        this.a.getSettings().getDefaultFieldSettings().setAlgorithm(algorithm);
    }

    @Override
    public void setAggregation(Aggregation aggregation) {
        this.a.getSettings().getDefaultFieldSettings().setAggregation(aggregation);
    }

    @Override
    public void setScale(Scale scale) {
        this.a.getSettings().getDefaultFieldSettings().setScale(scale);
    }

    @Override
    public void setNesting(Nesting nesting) {
        this.a.getSettings().getDefaultFieldSettings().setNesting(nesting);
    }

    @Override
    public void setOrdering(Ordering ordering) {
        this.a.getSettings().getDefaultFieldSettings().setOrdering(ordering);
    }

    @Override
    public void setDepth(Depth depth) {
        this.a.getSettings().setDepth(depth);
    }

    @Override
    public void setLabeling(Labeling labeling) {
        this.a.getSettings().getDefaultFieldSettings().setLabeling(labeling);
    }

    @Override
    public void setRendering(Rendering rendering) {
        this.a.getSettings().setRendering(rendering);
    }

    @Override
    public void setLightSourceHeight(double value) {
        this.a.getSettings().setLightSourceHeight(value);
    }

    @Override
    public void setLightSourceAmbient(double value) {
        this.a.getSettings().setLightSourceAmbient(value);
    }

    @Override
    public void setLightSourceX(double value) {
        this.a.getSettings().setLightSourceX(value);
    }

    @Override
    public void setLightSourceY(double value) {
        this.a.getSettings().setLightSourceY(value);
    }

    @Override
    public void setLightSourceZ(double value) {
        this.a.getSettings().setLightSourceZ(value);
    }

    @Override
    public void setLabelingFont(CPFont<Font> font) {
        this.a.getSettings().getDefaultFieldSettings().setLabelingFont(font);
    }

    @Override
    public void setLabelingForegroundColor(CPColor<Color> color) {
        this.a.getSettings().getDefaultFieldSettings().setLabelingForeground(color);
    }

    @Override
    public void setLabelingBackgroundColor(CPColor<Color> color) {
        this.a.getSettings().getDefaultFieldSettings().setLabelingEffectColor(color);
    }

    @Override
    public void setHeaderFont(CPFont<Font> font) {
        this.a.getSettings().getDefaultFieldSettings().setHeaderFont(font);
    }

    @Override
    public void setHeaderForegroundColor(CPColor<Color> color) {
        this.a.getSettings().getDefaultFieldSettings().setHeaderForeground(color);
    }

    @Override
    public void setHeaderBackgroundColor(CPColor<Color> color) {
        this.a.getSettings().getDefaultFieldSettings().setHeaderBackground(color);
    }
}

