/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.command.AbstractUICommand;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPPopupMenu;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.treemap.TreeMapController;
import com.treemap.TreeMapView;
import java.util.List;

public abstract class AbstractTreeMapController<C, N, Row, Column, Color, Font>
implements TreeMapController<C, N, Row, Column, Color, Font> {
    private TreeMapView<C, N, Row, Column, Color, Font> a;
    private final CPFactory<C, ?, ?, ?> b;
    private Mode c = Mode.Selection;
    private final boolean d = true;
    private final boolean e = false;
    private boolean f = true;
    private boolean g = false;
    private final DefaultMouseListener h = new DefaultMouseListener();
    private final CPCanvas.KeyListener i = new CPCanvas.KeyListener(){
        Mode a;

        public void keyTyped(CPCanvas.KeyEvent event) {
        }

        public void keyPressed(CPCanvas.KeyEvent event) {
            if (event.getKeyCode() == 83) {
                if (this.a == null) {
                    this.a = AbstractTreeMapController.this.c;
                }
                AbstractTreeMapController.this.c = Mode.Selection;
            }
            if (event.getKeyCode() == 90 || event.getKeyCode() == 16) {
                if (this.a == null) {
                    this.a = AbstractTreeMapController.this.c;
                }
                AbstractTreeMapController.this.c = Mode.Zooming;
            }
            if (event.getKeyCode() == 90 || event.getKeyCode() == 32) {
                if (this.a == null) {
                    this.a = AbstractTreeMapController.this.c;
                }
                AbstractTreeMapController.this.c = Mode.Panning;
            }
            if (event.getKeyCode() == 40) {
                AbstractTreeMapController.this.a.drillDown();
            }
            if (event.getKeyCode() == 38) {
                AbstractTreeMapController.this.a.drillUp();
            }
            if (event.getKeyCode() == 34) {
                AbstractTreeMapController.this.a.zoomIn();
            }
            if (event.getKeyCode() == 33) {
                AbstractTreeMapController.this.a.zoomOut();
            }
        }

        public void keyReleased(CPCanvas.KeyEvent event) {
            if (this.a != null) {
                AbstractTreeMapController.this.c = this.a;
                this.a = null;
            }
        }
    };

    public AbstractTreeMapController(TreeMapView<C, N, Row, Column, Color, Font> view, CPFactory<C, ?, ?, ?> factory) {
        this.b = factory;
        this.setView(view);
    }

    private void a(double d2, Double d3, Double d4) {
        if (this.f) {
            Rectangle2D rectangle2D = this.a.getViewport();
            Rectangle2D rectangle2D2 = this.a.getWorld();
            if (d4 != null) {
                d4 = rectangle2D2.getMaxY() - d4;
            }
            if (this.g) {
                double d5 = this.a((double)d3, rectangle2D2.getMinX(), rectangle2D2.getMaxX());
                double d6 = this.a((double)d4, rectangle2D2.getMinY(), rectangle2D2.getMaxY());
                d3 = this.b(this.zoomingCenterFunction(d5), rectangle2D2.getMinX(), rectangle2D2.getMaxX());
                d4 = this.b(this.zoomingCenterFunction(d6), rectangle2D2.getMinY(), rectangle2D2.getMaxY());
            }
            a a2 = new a(d2, d3, rectangle2D.getMinX(), rectangle2D.getWidth(), rectangle2D2.getMinX(), rectangle2D2.getMaxX(), this.a.getSize().getWidth()).c();
            double d7 = a2.a();
            double d8 = a2.b();
            a a3 = new a(d2, d4, rectangle2D.getMinY(), rectangle2D.getHeight(), rectangle2D2.getMinY(), rectangle2D2.getMaxY(), this.a.getSize().getHeight()).c();
            double d9 = a3.a();
            double d10 = a3.b();
            if (d7 < d8 && d9 < d10) {
                this.a.zoom(false, d7, d8, d9, d10);
            }
        }
    }

    protected double zoomingCenterFunction(double center) {
        return Math.tanh(center * 3.0);
    }

    private double a(double d2, double d3, double d4) {
        return (d2 - d3) / d4 * 2.0 - 1.0;
    }

    private double b(double d2, double d3, double d4) {
        return d3 + d4 * ((d2 + 1.0) / 2.0);
    }

    @Override
    public void setView(TreeMapView<C, N, Row, Column, Color, Font> view) {
        this.a = view;
        if (view != null) {
            view.addKeyListener(this.i);
            view.addMouseListener(this.h);
            view.addMouseMotionListener(this.h);
            view.addMouseWheelListener(this.h);
            view.addContextMenuListener(new CPCanvas.ContextMenuListener(){

                public void contextMenu(CPCanvas.ContextMenuEvent event) {
                    AbstractTreeMapController.this.a(event);
                }
            });
        }
    }

    private void a(CPCanvas.ContextMenuEvent contextMenuEvent) {
        CPPopupMenu cPPopupMenu = this.b.createPopupMenu();
        final int n2 = contextMenuEvent.getX();
        final int n3 = contextMenuEvent.getY();
        AbstractUICommand abstractUICommand = new AbstractUICommand("Drill down"){

            public void execute(Object source) {
                AbstractTreeMapController.this.a.drill(n2, n3);
            }
        };
        AbstractUICommand abstractUICommand2 = new AbstractUICommand("Drill up"){

            public void execute(Object source) {
                AbstractTreeMapController.this.a.drillUp();
            }
        };
        AbstractUICommand abstractUICommand3 = new AbstractUICommand("Zoom in"){

            public void execute(Object source) {
                AbstractTreeMapController.this.a.zoomIn();
            }
        };
        AbstractUICommand abstractUICommand4 = new AbstractUICommand("Zoom out"){

            public void execute(Object source) {
                AbstractTreeMapController.this.a.zoomOut();
            }
        };
        cPPopupMenu.add((UICommand)abstractUICommand);
        cPPopupMenu.add((UICommand)abstractUICommand2);
        cPPopupMenu.add((UICommand)abstractUICommand3);
        cPPopupMenu.add((UICommand)abstractUICommand4);
        cPPopupMenu.show(this.a.getNativeComponent(), n2, n3);
    }

    public Rectangle2D getViewport() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.a.getXRangeModel().getStart(), this.a.getYRangeModel().getStart(), this.a.getXRangeModel().getExtent(), this.a.getYRangeModel().getExtent());
        return double_;
    }

    public Rectangle2D getWorld() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.a.getXRangeModel().getMinimum(), this.a.getYRangeModel().getMinimum(), this.a.getXRangeModel().getMaximum() - this.a.getXRangeModel().getMinimum(), this.a.getYRangeModel().getMaximum() - this.a.getYRangeModel().getMinimum());
        return double_;
    }

    @Override
    public void setZoomingEnabled(boolean zoomingEnabled) {
        this.f = zoomingEnabled;
    }

    @Override
    public boolean isZoomingEnabled() {
        return this.f;
    }

    public class DefaultMouseListener
    implements CPCanvas.MouseListener,
    CPCanvas.MouseMotionListener,
    CPCanvas.MouseWheelListener {
        private CPCanvas.MouseEvent b;
        private N c = null;
        private Point d = null;
        private Point e = null;
        private Point f = null;

        public void mouseClicked(CPCanvas.MouseEvent event) {
        }

        public void mousePressed(CPCanvas.MouseEvent event) {
            if (AbstractTreeMapController.this.a != null) {
                this.f = new Point(event.getX(), event.getY());
                if (event.getClickCount() > 1) {
                    AbstractTreeMapController.this.a.drill(this.f.x, this.f.y);
                } else {
                    Object n2 = AbstractTreeMapController.this.a.getNode(new Point(event.getX(), event.getY()));
                    if (n2 != null) {
                        if (!event.isMultipleSelectionKey()) {
                            if (!AbstractTreeMapController.this.a.getModel().getSelection().isSelected(n2) || AbstractTreeMapController.this.a.getModel().getSelection().getSelectedCount() > 1) {
                                AbstractTreeMapController.this.a.getModel().getSelection().clearSelection();
                                AbstractTreeMapController.this.a.getModel().getSelection().setSelected(n2);
                                AbstractTreeMapController.this.a.setSelectionMode(AbstractTreeMapController.this.a.getModel().getSelection().isSelected(n2));
                            }
                        } else {
                            AbstractTreeMapController.this.a.setSelectionMode(!AbstractTreeMapController.this.a.getModel().getSelection().isSelected(n2));
                            if (AbstractTreeMapController.this.a.isSelectionMode()) {
                                AbstractTreeMapController.this.a.getModel().getSelection().setSelectedState(n2, true);
                            } else {
                                AbstractTreeMapController.this.a.getModel().getSelection().setSelectedState(n2, false);
                            }
                        }
                    } else {
                        AbstractTreeMapController.this.a.getModel().getSelection().clearSelection();
                    }
                }
            }
        }

        public void mouseReleased(CPCanvas.MouseEvent event) {
            if (AbstractTreeMapController.this.a != null) {
                if (!event.isPopupTrigger()) {
                    if (this.c != null && event.isLeftMouseButton()) {
                        AbstractTreeMapController.this.a.getModel().getSelection().clearSelection();
                        this.a(this.c);
                        this.c = null;
                    }
                    if (this.d != null) {
                        if (event.isLeftMouseButton()) {
                            // empty if block
                        }
                        this.d = null;
                    }
                    AbstractTreeMapController.this.a.getRubberBand().stopRubberBand();
                }
                this.b = null;
            }
        }

        public void mouseEntered(CPCanvas.MouseEvent event) {
            if (AbstractTreeMapController.this.a != null && AbstractTreeMapController.this.a.getModel() != null) {
                AbstractTreeMapController.this.a.getModel().getProbing().setSelected(AbstractTreeMapController.this.a.getNode(new Point(event.getX(), event.getY())));
            }
        }

        public void mouseExited(CPCanvas.MouseEvent event) {
            if (AbstractTreeMapController.this.a != null && AbstractTreeMapController.this.a.getModel() != null) {
                AbstractTreeMapController.this.a.getModel().getProbing().clearSelection();
            }
        }

        public void mouseDragged(CPCanvas.MouseEvent event) {
            if (AbstractTreeMapController.this.a != null && AbstractTreeMapController.this.a.getModel() != null) {
                if (this.b != null) {
                    switch (AbstractTreeMapController.this.c) {
                        case Selection: {
                            boolean bl;
                            if (!event.isLeftMouseButton()) break;
                            if (event.isAltKeyDown() || event.isShiftKeyDown()) {
                                AbstractTreeMapController.this.a.getModel().getProbing().clearSelection();
                                if (!AbstractTreeMapController.this.a.getRubberBand().getRubberBand().isActive()) {
                                    AbstractTreeMapController.this.a.getRubberBand().startRubberBand(this.f.x, this.f.y);
                                }
                                AbstractTreeMapController.this.a.getRubberBand().stretchRubberBand(event.getX(), event.getY());
                                Rectangle2D rectangle2D = AbstractTreeMapController.this.a.getRubberBand().getRubberBandScreen();
                                Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                                if (rectangle == null) break;
                                List list = AbstractTreeMapController.this.a.getNodes(rectangle);
                                if (event.isMultipleSelectionKey()) {
                                    this.a(list);
                                } else {
                                    AbstractTreeMapController.this.a.getModel().getSelection().setSelectedIterable(list);
                                }
                                this.c = null;
                                break;
                            }
                            Object n2 = AbstractTreeMapController.this.a.getNode(new Point(event.getX(), event.getY()));
                            AbstractTreeMapController.this.a.getModel().getProbing().setSelected(n2);
                            this.c = null;
                            boolean bl2 = bl = AbstractTreeMapController.this.a.getModel().getSelection() != null && AbstractTreeMapController.this.a.getModel().getSelection().isSelected(n2);
                            if (!bl && !event.isMenuShortcutKeyDown()) {
                                AbstractTreeMapController.this.a.getModel().getSelection().clearSelection();
                            }
                            if (event.isMenuShortcutKeyDown()) {
                                this.a(n2);
                                break;
                            }
                            if (bl) {
                                this.c = n2;
                                break;
                            }
                            this.a(n2);
                            break;
                        }
                        case Panning: {
                            if (!event.isLeftMouseButton()) break;
                            Rectangle2D rectangle2D = AbstractTreeMapController.this.getViewport();
                            Rectangle2D rectangle2D2 = AbstractTreeMapController.this.getWorld();
                            double d2 = AbstractTreeMapController.this.a.getScreenTransform().getX().screenToWorld(this.b.getX());
                            double d3 = AbstractTreeMapController.this.a.getScreenTransform().getX().screenToWorld(event.getX());
                            double d4 = d2 - d3;
                            double d5 = rectangle2D.getMinX() + d4;
                            double d6 = rectangle2D.getMaxX() + d4;
                            double d7 = AbstractTreeMapController.this.a.getScreenTransform().getY().screenToWorld(this.b.getY());
                            double d8 = AbstractTreeMapController.this.a.getScreenTransform().getY().screenToWorld(event.getY());
                            double d9 = d7 - d8;
                            double d10 = rectangle2D.getMinY() + d9;
                            double d11 = rectangle2D.getMaxY() + d9;
                            if (d5 < rectangle2D2.getMinX()) {
                                d6 += rectangle2D2.getMinX() - d5;
                                d5 = rectangle2D2.getMinX();
                            }
                            if (d6 > rectangle2D2.getMaxX()) {
                                d5 -= d6 - rectangle2D2.getMaxX();
                                d6 = rectangle2D2.getMaxX();
                            }
                            d5 = Math.max(rectangle2D2.getMinX(), d5);
                            d6 = Math.min(rectangle2D2.getMaxX(), d6);
                            if (d10 < rectangle2D2.getMinY()) {
                                d11 += rectangle2D2.getMinY() - d10;
                                d10 = rectangle2D2.getMinY();
                            }
                            if (d11 > rectangle2D2.getMaxY()) {
                                d10 -= d11 - rectangle2D2.getMaxY();
                                d11 = rectangle2D2.getMaxY();
                            }
                            d10 = Math.max(rectangle2D2.getMinY(), d10);
                            d11 = Math.min(rectangle2D2.getMaxY(), d11);
                            if (!(d5 < d6) || !(d10 < d11)) break;
                            AbstractTreeMapController.this.a.zoom(false, d5, d6, d10, d11);
                            break;
                        }
                        case Zooming: {
                            if (!event.isMiddleMouseButton()) break;
                            AbstractTreeMapController.this.a((double)event.getY() - (double)this.b.getY() / 100.0, AbstractTreeMapController.this.a.getScreenTransform().getX().screenToWorld(event.getX()), AbstractTreeMapController.this.a.getScreenTransform().getY().screenToWorld(event.getY()));
                            this.d = null;
                        }
                    }
                }
                this.b = event;
            }
        }

        public void mouseMoved(CPCanvas.MouseEvent event) {
            Object n2 = AbstractTreeMapController.this.a.getNode(new Point(event.getX(), event.getY()));
            AbstractTreeMapController.this.a.getModel().getProbing().setSelected(n2);
        }

        public void mouseWheelMoved(CPCanvas.MouseWheelEvent event) {
            if (AbstractTreeMapController.this.a != null) {
                int n2 = event.getWheelRotation();
                AbstractTreeMapController.this.a((double)n2 / 20.0, AbstractTreeMapController.this.a.getScreenTransform().getX().screenToWorld(event.getX()), AbstractTreeMapController.this.a.getScreenTransform().getY().screenToWorld(event.getY()));
            }
        }

        private void a(N n2) {
            AbstractTreeMapController.this.a.getModel().getSelection().setSelectedState(n2, true);
        }

        private void a(List<N> list) {
            AbstractTreeMapController.this.a.getModel().getSelection().setSelectedIterableState(list, true);
        }
    }

    private class a {
        private final double b;
        private final Double c;
        private final double d;
        private final double e;
        private final double f;
        private final double g;
        private double h;
        private double i;
        private final double j;

        public a(double d2, Double d3, double d4, double d5, double d6, double d7, double d8) {
            this.b = d2;
            this.c = d3;
            this.d = d4;
            this.e = d5;
            this.f = d6;
            this.g = d7;
            this.j = d8;
        }

        public double a() {
            return this.h;
        }

        public double b() {
            return this.i;
        }

        public a c() {
            double d2 = this.e;
            double d3 = Math.min(this.j, d2 + d2 * this.b);
            if (this.c != null) {
                this.h = this.c - d3 * ((this.c - this.d) / d2);
                this.i = this.c + d3 * ((this.d + this.e - this.c) / d2);
            } else {
                this.h = this.d;
                this.i = this.d + d3;
            }
            if (this.h < this.f) {
                this.i += this.f - this.h;
                this.h = this.f;
            }
            if (this.i > this.g) {
                this.h -= this.i - this.g;
                this.i = this.g;
            }
            this.h = Math.max(this.f, this.h);
            this.i = Math.min(this.g, this.i);
            return this;
        }
    }

    public static enum Mode {
        Selection,
        Zooming,
        Panning;

    }
}

