/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPImage;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import com.treemap.j;
import java.lang.ref.SoftReference;

public abstract class AbstractTreeMapNode<N extends AbstractTreeMapNode<N, Row, Column, Color, Font>, Row, Column, Color, Font>
implements MutableTreeMapNode<N, Column, Color, Font> {
    private double a = 1.0;
    private Shape b;
    protected final TreeMapModel<N, Row, Column, Color, Font> model;
    private CPColor<Color> c;
    private j d;
    private SoftReference<CPImage> e;
    private N f;
    private int g;

    protected AbstractTreeMapNode(TreeMapModel<N, Row, Column, Color, Font> model) {
        this.model = model;
        this.g = 0;
        this.c = model != null ? model.getColorFactory().getLightGray() : null;
    }

    public abstract int getChildCount();

    @Override
    public int getLevel() {
        return this.g;
    }

    public N getParent() {
        return this.f;
    }

    public boolean isRoot() {
        return this.f == null;
    }

    public abstract Iterable<N> getChildren();

    public abstract Iterable<N> getChildrenOfTypeParent();

    public AbstractTreeMapNode[] getPath() {
        N n2 = this.getParent();
        if (n2 != null) {
            int n3 = ((AbstractTreeMapNode)n2).getLevel();
            AbstractTreeMapNode[] abstractTreeMapNodeArray = new AbstractTreeMapNode[n3 + 2];
            AbstractTreeMapNode<N, Row, Column, Color, Font> abstractTreeMapNode = this;
            int n4 = n3 + 1;
            abstractTreeMapNodeArray[n4] = this;
            --n4;
            while ((abstractTreeMapNode = abstractTreeMapNode.getParent()) != null) {
                abstractTreeMapNodeArray[n4] = abstractTreeMapNode;
                --n4;
            }
            return abstractTreeMapNodeArray;
        }
        return new AbstractTreeMapNode[]{this};
    }

    public abstract void add(N var1);

    public void setParent(N parent) {
        this.f = parent;
        this.g = ((AbstractTreeMapNode)this.getParent()).getLevel() + 1;
    }

    public abstract N findChild(Object var1);

    public abstract Object getNodeName();

    public abstract Row getRow();

    public String getLabelName() {
        TreeMapField<N, Column> treeMapField;
        if (this.model.getSettings().getBackgroundTreeMapField() != null && (treeMapField = this.model.getSettings().getBackgroundTreeMapField()).isValid() && this.hasNoChildren()) {
            if (!this.model.isNumericType(treeMapField)) {
                Object object = this.model.getValueAt(this, treeMapField.getIndex());
                if (object != null) {
                    return object.toString();
                }
                return null;
            }
            Object object = this.model.getValueAt(this, treeMapField.getIndex());
            if (object != null) {
                return object.toString();
            }
            return null;
        }
        if (this.model.getSettings().getLabelTreeMapFields() != null && this.model.getSettings().getLabelTreeMapFields().length > 0) {
            treeMapField = this.model.getSettings().getLabelTreeMapFields()[0];
            if (!treeMapField.isValid() || !this.hasNoChildren()) {
                if (this.getNodeName() != null) {
                    return this.getNodeName().toString();
                }
                return null;
            }
            if (!this.model.isNumericType(treeMapField)) {
                Object object = this.model.getValueAt(this, treeMapField.getIndex());
                if (object != null) {
                    return object.toString();
                }
                return null;
            }
            Object object = this.model.getValueAt(this, treeMapField.getIndex());
            if (object != null) {
                return object.toString();
            }
            return null;
        }
        if (this.getNodeName() != null) {
            return this.getNodeName().toString();
        }
        return null;
    }

    @Override
    public CPColor<Color> getColor() {
        return this.c;
    }

    protected Number worldToNormalized(Number value, TreeMapField columnIndex) {
        Double d2 = this.model.getNumericMin(columnIndex);
        Double d3 = this.model.getNumericMax(columnIndex);
        if (d2 != null && d3 != null && value != null) {
            double d4 = d3 - d2;
            return (value.doubleValue() - d2) / d4;
        }
        return null;
    }

    protected Number normalizedToWorld(Number value, TreeMapField columnIndex) {
        Double d2 = this.model.getNumericMin(columnIndex);
        Double d3 = this.model.getNumericMax(columnIndex);
        if (d2 != null && d3 != null && value != null) {
            double d4 = d3 - d2;
            return value.doubleValue() * d4 + d2;
        }
        return null;
    }

    @Override
    public double getSize() {
        return this.a;
    }

    @Override
    public void setSize(double size) {
        this.a = size;
    }

    @Override
    public Shape getShape() {
        return this.b;
    }

    @Override
    public Shape getNestedShape() {
        return this.b;
    }

    @Override
    public void setColor(CPColor<Color> c2) {
        this.c = c2;
        this.d = null;
        if (this.e != null) {
            CPImage cPImage = this.e.get();
            if (cPImage != null) {
                cPImage.flush();
            }
            this.e = null;
        }
    }

    @Override
    public void setShape(Shape shape) {
        if (this.b == null || !this.b.equals(shape)) {
            this.b = shape;
            this.d = null;
            if (this.e != null) {
                CPImage cPImage = this.e.get();
                if (cPImage != null) {
                    cPImage.flush();
                }
                this.e = null;
            }
        }
    }

    @Override
    public void setNestedShape(Shape shape) {
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.b != null) {
            return this.b.getBounds2D();
        }
        return null;
    }

    public String toString() {
        return this.getLabelName();
    }

    j a() {
        if (this.d != null) {
            return this.d;
        }
        j j2 = null;
        N n2 = this.getParent();
        if (n2 != null && this.b != null) {
            Rectangle rectangle;
            if (this.b instanceof Rectangle) {
                rectangle = (Rectangle)this.b;
            } else {
                Rectangle2D rectangle2D = this.b.getBounds2D();
                rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            }
            int n3 = rectangle.y;
            int n4 = rectangle.y + rectangle.height;
            int n5 = rectangle.x;
            int n6 = rectangle.x + rectangle.width;
            j2 = ((AbstractTreeMapNode)n2).getParent() == null ? new j(this.model, n5, n6, rectangle.width, n3, n4, rectangle.height) : new j(((AbstractTreeMapNode)n2).a(), this.model, n5, n6, rectangle.width, n3, n4, rectangle.height);
        }
        this.d = j2;
        return j2;
    }

    public CPImage getCushionImage() {
        if (this.e == null) {
            CPImage cPImage = this.b();
            if (cPImage != null) {
                this.e = new SoftReference<CPImage>(cPImage);
                return cPImage;
            }
            return null;
        }
        CPImage cPImage = this.e.get();
        if (cPImage == null) {
            cPImage = this.b();
            if (cPImage != null) {
                this.e = new SoftReference<CPImage>(cPImage);
            } else {
                return null;
            }
        }
        return cPImage;
    }

    private CPImage b() {
        Rectangle rectangle;
        if (this.b == null) {
            return null;
        }
        if (this.b instanceof Rectangle) {
            rectangle = (Rectangle)this.getShape();
        } else {
            Rectangle2D rectangle2D = this.getShape().getBounds2D();
            rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        }
        int n2 = Math.max(1, rectangle.width);
        int n3 = Math.max(1, rectangle.height);
        CPImage cPImage = this.model.getImageFactory().createImage(n2, n3);
        this.a().a(this.model, this.c, rectangle.x, rectangle.y, n2, n3, cPImage);
        return cPImage;
    }

    public CPColor<Color> getCushionColor() {
        Rectangle rectangle;
        if (this.b == null) {
            return null;
        }
        if (this.b instanceof Rectangle) {
            rectangle = (Rectangle)this.getShape();
        } else {
            Rectangle2D rectangle2D = this.getShape().getBounds2D();
            rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        }
        int n2 = Math.max(1, rectangle.width);
        int n3 = Math.max(1, rectangle.height);
        return this.a().a(this.model, this.c, rectangle.x, rectangle.y, n2, n3);
    }

    protected N getSelf() {
        return (N)this;
    }
}

