/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.SimpleProperties;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SimpleSelection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.treemap.AbstractTreeMapModel;
import com.treemap.AbstractTreeMapSettings;
import com.treemap.DefaultTreeMapFieldSettings;
import com.treemap.Depth;
import com.treemap.DepthFactory;
import com.treemap.NoTreeMapField;
import com.treemap.OverridingTreeMapFieldSettings;
import com.treemap.Rendering;
import com.treemap.RenderingFactory;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapSettings;
import com.treemap.TreeMapSettingsEvent;
import com.treemap.TreeMapView;
import com.treemap.legacy.SingleSelectionSettingsCoordinator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DefaultTreeMapSettings<N, Column, Color, Font>
extends AbstractTreeMapSettings<N, Column, Color, Font> {
    private final MutableProperties<String> a = new SimpleProperties();
    protected final AbstractTreeMapModel _model;
    protected final MutableSelection<TreeMapField> groupByVariables = new SimpleSelection();
    protected final MutableSingleSelection<TreeMapField> sizeVariable = new SimpleSingleSelection(new NoTreeMapField());
    protected final MutableSingleSelection<TreeMapField> colorVariable = new SimpleSingleSelection(new NoTreeMapField());
    protected final MutableSelection<TreeMapField> labelVariable = new SimpleSelection();
    protected final MutableSelection<TreeMapField> toolTipVariable = new SimpleSelection();
    protected final MutableSingleSelection<TreeMapField> backgroundVariable = new SimpleSingleSelection(new NoTreeMapField());
    protected final MutableSingleSelection<TreeMapField> heightVariable = new SimpleSingleSelection(new NoTreeMapField());
    protected final MutableSingleSelection<TreeMapView.Progressive> progressive = new SimpleSingleSelection((Object)TreeMapView.Progressive.Disabled);
    protected final MutableSingleSelection<Depth> depth = new SimpleSingleSelection((Object)DepthFactory.getInstance().getDefault());
    protected final MutableSingleSelection<Rendering> rendering = new SimpleSingleSelection((Object)RenderingFactory.getInstance().getDefault());
    private MutableProperty<Boolean> b = this.a.createProperty((Object)"dimensionFixed", (Object)Boolean.FALSE);
    private MutableProperty<Dimension> c = this.a.createProperty((Object)"dimension", null);
    private MutableProperty<TreeMapView.Progressive> d = this.a.createProperty((Object)"progressive", null);
    protected MutableProperty<TreeMapField[]> groupByFields = this.a.createProperty((Object)"groupByField", (Object)new TreeMapField[0]);
    protected MutableProperty<TreeMapField[]> labelsFields = this.a.createProperty((Object)"labelsField", (Object)new TreeMapField[0]);
    protected MutableProperty<TreeMapField[]> toolTipFields = this.a.createProperty((Object)"toolTipField", (Object)new TreeMapField[0]);
    protected MutableProperty<TreeMapField> sizeField = this.a.createProperty((Object)"sizeField", new NoTreeMapField());
    protected MutableProperty<TreeMapField> colorField = this.a.createProperty((Object)"colorField", new NoTreeMapField());
    protected MutableProperty<TreeMapField> backgroundField = this.a.createProperty((Object)"backgroundField", new NoTreeMapField());
    protected MutableProperty<TreeMapField> heightField = this.a.createProperty((Object)"heightField", new NoTreeMapField());
    protected MutableProperty<Depth> _depth = this.a.createProperty((Object)"depth", null);
    protected MutableProperty<Rendering> _rendering = this.a.createProperty((Object)"rendering", null);
    protected final MutableBoundedInterval maximumHeightInterval = new SimpleBoundedInterval(0.03, 0.0, 0.5);
    protected final MutableProperty<Double> maximumHeight = this.a.addProperty((Object)"maximumHeight", this.maximumHeightInterval.getStartProperty());
    protected final MutableBoundedInterval lightSourceHeightInterval = new SimpleBoundedInterval(0.25, 0.0, 2.0);
    protected final MutableProperty<Double> ightSourceHeight = this.a.addProperty((Object)"lightSourceHeight", this.lightSourceHeightInterval.getStartProperty());
    protected final MutableBoundedInterval lightSourceAmbientInterval = new SimpleBoundedInterval(0.5, 0.0, 1.0);
    protected final MutableProperty<Double> lightSourceAmbient = this.a.addProperty((Object)"lightSourceAmbient", this.lightSourceAmbientInterval.getStartProperty());
    protected final MutableBoundedInterval lightSourceXInterval = new SimpleBoundedInterval(-1.0, -4.0, 4.0);
    protected final MutableProperty<Double> lightSourceX = this.a.addProperty((Object)"lightSourceX", this.lightSourceXInterval.getStartProperty());
    protected final MutableBoundedInterval lightSourceYInterval = new SimpleBoundedInterval(-1.0, -4.0, 4.0);
    protected final MutableProperty<Double> lightSourceY = this.a.addProperty((Object)"lightSourceY", this.lightSourceYInterval.getStartProperty());
    protected final MutableBoundedInterval lightSourceZInterval = new SimpleBoundedInterval(10.0, 0.0, 100.0);
    protected final MutableProperty<Double> lightSourceZ = this.a.addProperty((Object)"lightSourceZ", this.lightSourceZInterval.getStartProperty());
    protected MutableProperty<CPColor<Color>> _background;
    protected MutableProperty<CPColor<Color>> _tooltipBackground;
    protected MutableProperty<CPColor<Color>> _probingColor;
    protected MutableProperty<CPColor<Color>> _selectionColor;
    protected MutableProperty<Boolean> hideSearchResults = this.a.createProperty((Object)"hideSearchResults", null);
    protected MutableProperty<Boolean> hideFilterResults = this.a.createProperty((Object)"hideFilterResults", null);
    private TreeMapFieldSettings<Color, Font> e;
    private Map<TreeMapField, TreeMapFieldSettings<Color, Font>> f = new HashMap<TreeMapField, TreeMapFieldSettings<Color, Font>>();
    private final CPColorFactory<Color> g;
    private final CPFontFactory<Font> h;
    private final ColorMapFactory<Color> i;
    private final PropertiesListener j = new PropertiesListener(){

        public void propertyChanged(Object name, PropertyEvent event) {
            if ("depth".equals(name) || "rendering".equals(name) || "nestingBackground".equals(name) || "headerBackground".equals(name) || "headerForeground".equals(name) || "headerEffectColor".equals(name) || "labelingFont".equals(name) || "labelingEffectColor".equals(name) || "labelingForeground".equals(name) || "labelingShrinkTextToFitShape".equals(name) || "labelingResizeTextToFitShape".equals(name) || "labelingFloat".equals(name) || "tooltipFont".equals(name) || "background".equals(name) || "tooltipBackground".equals(name) || "tooltipForeground".equals(name) || "borderColor".equals(name) || "showLabel".equals(name)) {
                DefaultTreeMapSettings.this.d();
            } else if ("dimension".equals(name) || "aggregation".equals(name) || "algorithm".equals(name) || "scale".equals(name) || "labeling".equals(name) || "nesting".equals(name) || "nestingAmount".equals(name) || "ordering".equals(name) || "orderingDirection".equals(name) || "orderingHorizontalVanishingPoint".equals(name) || "orderingVerticalVanishingPoint".equals(name) || "sizeField".equals(name) || "heightField".equals(name) || "backgroundField".equals(name) || "headerFont".equals(name) || "labelsField".equals(name) || "hideFilterResults".equals(name) || "hideSearchResults".equals(name) || "format".equals(name) || "borderThickness".equals(name) || "headerFont".equals(name) || "headerRendering".equals(name)) {
                DefaultTreeMapSettings.this.b();
            } else if ("colormap".equals(name) || "colorField".equals(name) || "lightSourceHeight".equals(name) || "lightSourceAmbient".equals(name) || "lightSourceX".equals(name) || "lightSourceY".equals(name) || "lightSourceZ".equals(name)) {
                DefaultTreeMapSettings.this.c();
            } else if ("groupByField".equals(name)) {
                DefaultTreeMapSettings.this.a();
            } else {
                DefaultTreeMapSettings.this.d();
            }
        }
    };

    public DefaultTreeMapSettings(AbstractTreeMapModel model, CPColorFactory<Color> colorFactory, CPFontFactory<Font> fontFactory, ColorMapFactory<Color> colorMapFactory) {
        this._model = model;
        this.g = colorFactory;
        this.h = fontFactory;
        this.i = colorMapFactory;
        this._background = this.a.createProperty((Object)"background", null);
        this._tooltipBackground = this.a.createProperty((Object)"tooltipBackground", (Object)colorFactory.createRGBAColor(232, 232, 232, 200));
        this._probingColor = this.a.createProperty((Object)"probingColor", (Object)colorFactory.createRGBAColor(0, 0, 0, 240));
        this._selectionColor = this.a.createProperty((Object)"selectionColor", (Object)colorFactory.createRGBColor(255, 102, 0));
        this.resetToDefaults();
        this.a.addPropertiesListener(this.j);
        this.e = this.createDefaultTreeMapFieldSettings();
        this.e.getProperties().addPropertiesListener(this.j);
        this.getProperties().addPropertiesListener(new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                if ("groupByField".equals(name)) {
                    DefaultTreeMapSettings.this.getGroupByVariablesSelection().setSelectedElements((Object[])DefaultTreeMapSettings.this.getGroupByTreeMapFields());
                }
            }
        });
        this.getGroupByVariablesSelection().addSelectionListener((SelectionListener)new SelectionListener<TreeMapField>(){

            public void selectionChanged(SelectionEvent<TreeMapField> event) {
                Set set = DefaultTreeMapSettings.this.getGroupByVariablesSelection().getSelectedSet();
                DefaultTreeMapSettings.this.setGroupByTreeMapFields(set.toArray(new TreeMapField[set.size()]));
            }
        });
        this.getGroupByVariablesSelection().setSelectedElements((Object[])this.getGroupByTreeMapFields());
        new SingleSelectionSettingsCoordinator<TreeMapField>((TreeMapSettings)this, "sizeField", this.getSizeVariableSelection()){

            public TreeMapField a() {
                return DefaultTreeMapSettings.this.getSizeTreeMapField();
            }

            public void a(TreeMapField treeMapField) {
                DefaultTreeMapSettings.this.setSizeTreeMapField(treeMapField);
            }

            @Override
            public /* synthetic */ void set(Object object) {
                this.a((TreeMapField)object);
            }

            @Override
            public /* synthetic */ Object get() {
                return this.a();
            }
        };
        new SingleSelectionSettingsCoordinator<TreeMapView.Progressive>((TreeMapSettings)this, "progressive", this.getProgressiveSelection()){

            public TreeMapView.Progressive a() {
                return DefaultTreeMapSettings.this.getProgressive();
            }

            public void a(TreeMapView.Progressive progressive) {
                DefaultTreeMapSettings.this.setProgressive(progressive);
            }

            @Override
            public /* synthetic */ void set(Object object) {
                this.a((TreeMapView.Progressive)((Object)object));
            }

            @Override
            public /* synthetic */ Object get() {
                return this.a();
            }
        };
        new SingleSelectionSettingsCoordinator<TreeMapField>((TreeMapSettings)this, "colorField", this.getColorVariableSelection()){

            public TreeMapField a() {
                return DefaultTreeMapSettings.this.getColorTreeMapField();
            }

            public void a(TreeMapField treeMapField) {
                DefaultTreeMapSettings.this.setColorTreeMapField(treeMapField);
            }

            @Override
            public /* synthetic */ void set(Object object) {
                this.a((TreeMapField)object);
            }

            @Override
            public /* synthetic */ Object get() {
                return this.a();
            }
        };
        new SingleSelectionSettingsCoordinator<TreeMapField>((TreeMapSettings)this, "heightField", this.getHeightVariableSelection()){

            public TreeMapField a() {
                return DefaultTreeMapSettings.this.getHeightTreeMapField();
            }

            public void a(TreeMapField treeMapField) {
                DefaultTreeMapSettings.this.setHeightTreeMapField(treeMapField);
            }

            @Override
            public /* synthetic */ void set(Object object) {
                this.a((TreeMapField)object);
            }

            @Override
            public /* synthetic */ Object get() {
                return this.a();
            }
        };
        this.getProperties().addPropertiesListener(new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                if ("labelsField".equals(name)) {
                    DefaultTreeMapSettings.this.getLabelVariablesSelection().setSelectedElements((Object[])DefaultTreeMapSettings.this.getLabelTreeMapFields());
                }
            }
        });
        this.getLabelVariablesSelection().addSelectionListener((SelectionListener)new SelectionListener<TreeMapField>(){

            public void selectionChanged(SelectionEvent<TreeMapField> event) {
                Set set = DefaultTreeMapSettings.this.getLabelVariablesSelection().getSelectedSet();
                DefaultTreeMapSettings.this.setLabelTreeMapFields(set.toArray(new TreeMapField[set.size()]));
            }
        });
        this.getLabelVariablesSelection().setSelectedElements((Object[])this.getLabelTreeMapFields());
        this.getProperties().addPropertiesListener(new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                if ("toolTipField".equals(name)) {
                    DefaultTreeMapSettings.this.getTooltipVariablesSelection().setSelectedElements((Object[])DefaultTreeMapSettings.this.getToolTipTreeMapFields());
                }
            }
        });
        this.getTooltipVariablesSelection().addSelectionListener((SelectionListener)new SelectionListener<TreeMapField>(){

            public void selectionChanged(SelectionEvent<TreeMapField> event) {
                Set set = DefaultTreeMapSettings.this.getTooltipVariablesSelection().getSelectedSet();
                DefaultTreeMapSettings.this.setToolTipTreeMapFields(set.toArray(new TreeMapField[set.size()]));
            }
        });
        this.getTooltipVariablesSelection().setSelectedElements((Object[])this.getToolTipTreeMapFields());
        new SingleSelectionSettingsCoordinator<TreeMapField>((TreeMapSettings)this, "backgroundField", this.getBackgroundVariableSelection()){

            public TreeMapField a() {
                return DefaultTreeMapSettings.this.getBackgroundTreeMapField();
            }

            public void a(TreeMapField treeMapField) {
                DefaultTreeMapSettings.this.setBackgroundTreeMapField(treeMapField);
            }

            @Override
            public /* synthetic */ void set(Object object) {
                this.a((TreeMapField)object);
            }

            @Override
            public /* synthetic */ Object get() {
                return this.a();
            }
        };
        new SingleSelectionSettingsCoordinator<Depth>((TreeMapSettings)this, "depth", this.getDepthSelection()){

            public Depth a() {
                return DefaultTreeMapSettings.this.getDepth();
            }

            public void a(Depth depth) {
                DefaultTreeMapSettings.this.setDepth(depth);
            }

            @Override
            public /* synthetic */ void set(Object object) {
                this.a((Depth)object);
            }

            @Override
            public /* synthetic */ Object get() {
                return this.a();
            }
        };
        new SingleSelectionSettingsCoordinator<Rendering>((TreeMapSettings)this, "rendering", this.getRenderingSelection()){

            public Rendering a() {
                return DefaultTreeMapSettings.this.getRendering();
            }

            public void a(Rendering rendering) {
                DefaultTreeMapSettings.this.setRendering(rendering);
            }

            @Override
            public /* synthetic */ void set(Object object) {
                this.a((Rendering)object);
            }

            @Override
            public /* synthetic */ Object get() {
                return this.a();
            }
        };
    }

    @Override
    public MutableProperties<String> getProperties() {
        return this.a;
    }

    @Override
    public MutableSelection<TreeMapField> getGroupByVariablesSelection() {
        return this.groupByVariables;
    }

    @Override
    public MutableSingleSelection<TreeMapField> getSizeVariableSelection() {
        return this.sizeVariable;
    }

    @Override
    public MutableSingleSelection<TreeMapField> getColorVariableSelection() {
        return this.colorVariable;
    }

    @Override
    public MutableSelection<TreeMapField> getLabelVariablesSelection() {
        return this.labelVariable;
    }

    @Override
    public MutableSelection<TreeMapField> getTooltipVariablesSelection() {
        return this.toolTipVariable;
    }

    @Override
    public MutableSingleSelection<TreeMapField> getBackgroundVariableSelection() {
        return this.backgroundVariable;
    }

    @Override
    public MutableSingleSelection<TreeMapField> getHeightVariableSelection() {
        return this.heightVariable;
    }

    @Override
    public MutableSingleSelection<Depth> getDepthSelection() {
        return this.depth;
    }

    @Override
    public MutableSingleSelection<Rendering> getRenderingSelection() {
        return this.rendering;
    }

    @Override
    public MutableSingleSelection<TreeMapView.Progressive> getProgressiveSelection() {
        return this.progressive;
    }

    @Override
    public MutableProperty<Boolean> getHideFilterResultsSelection() {
        return this.hideFilterResults;
    }

    @Override
    public MutableProperty<Boolean> getHideSearchResultsSelection() {
        return this.hideSearchResults;
    }

    protected TreeMapFieldSettings<Color, Font> createDefaultTreeMapFieldSettings() {
        return new DefaultTreeMapFieldSettings<Color, Font>(this.g, this.h, this.i);
    }

    protected TreeMapFieldSettings<Color, Font> createOverridingTreeMapFieldSettings(TreeMapFieldSettings<Color, Font> defaultSettings, TreeMapModel model, TreeMapField field) {
        return new OverridingTreeMapFieldSettings<Color, Font>(defaultSettings);
    }

    private void a() {
        this.notifySettingsChanged(new TreeMapSettingsEvent(true, true, true));
    }

    private void b() {
        this.notifySettingsChanged(new TreeMapSettingsEvent(false, true, true));
    }

    private void c() {
        this.notifySettingsChanged(new TreeMapSettingsEvent(false, false, true));
    }

    private void d() {
        this.notifySettingsChanged(new TreeMapSettingsEvent(false, false, false));
    }

    @Override
    public TreeMapFieldSettings<Color, Font> getDefaultFieldSettings() {
        return this.e;
    }

    @Override
    public TreeMapFieldSettings<Color, Font> getFieldSettings(TreeMapField field) {
        if (field != null && field.isValid()) {
            if (!this.f.containsKey(field)) {
                TreeMapFieldSettings<Color, Font> treeMapFieldSettings = this.createOverridingTreeMapFieldSettings(this.getDefaultFieldSettings(), this._model, field);
                treeMapFieldSettings.getProperties().addPropertiesListener(this.j);
                this.f.put(field, treeMapFieldSettings);
            }
            return this.f.get(field);
        }
        return this.getDefaultFieldSettings();
    }

    @Override
    public Boolean getDimensionFixed() {
        return (Boolean)this.b.getValue();
    }

    @Override
    public void setDimensionFixed(Boolean fixed) {
        this.b.setValue((Object)fixed);
    }

    @Override
    public Dimension getDimension() {
        return (Dimension)this.c.getValue();
    }

    @Override
    public void setDimension(Dimension dimension) {
        this.c.setValue((Object)dimension);
    }

    @Override
    public TreeMapView.Progressive getProgressive() {
        return (TreeMapView.Progressive)((Object)this.d.getValue());
    }

    @Override
    public void setProgressive(TreeMapView.Progressive progressive) {
        this.d.setValue((Object)progressive);
    }

    @Override
    public TreeMapField[] getGroupByTreeMapFields() {
        return (TreeMapField[])this.groupByFields.getValue();
    }

    @Override
    public void setGroupByTreeMapFields(TreeMapField[] fields) {
        this.groupByFields.setValue((Object)fields);
    }

    @Override
    public TreeMapField<N, Column> getSizeTreeMapField() {
        return (TreeMapField)this.sizeField.getValue();
    }

    @Override
    public TreeMapField<N, Column> getColorTreeMapField() {
        return (TreeMapField)this.colorField.getValue();
    }

    @Override
    public TreeMapField<N, Column>[] getLabelTreeMapFields() {
        return (TreeMapField[])this.labelsFields.getValue();
    }

    @Override
    public void setLabelTreeMapFields(TreeMapField<N, Column>[] fields) {
        this.labelsFields.setValue(fields);
    }

    @Override
    public TreeMapField<N, Column>[] getToolTipTreeMapFields() {
        return (TreeMapField[])this.toolTipFields.getValue();
    }

    @Override
    public void setToolTipTreeMapFields(TreeMapField<N, Column>[] fields) {
        this.toolTipFields.setValue(fields);
    }

    @Override
    public TreeMapField<N, Column> getBackgroundTreeMapField() {
        return (TreeMapField)this.backgroundField.getValue();
    }

    @Override
    public TreeMapField<N, Column> getHeightTreeMapField() {
        return (TreeMapField)this.heightField.getValue();
    }

    @Override
    public MutableBoundedInterval getMaximumHeightInterval() {
        return this.maximumHeightInterval;
    }

    @Override
    public double getMaximumHeight() {
        return this.maximumHeightInterval.getStart();
    }

    @Override
    public void setMaximumHeight(double height) {
        this.maximumHeightInterval.setStart(height);
    }

    @Override
    public Boolean isHideFilterResults() {
        return (Boolean)this.hideFilterResults.getValue();
    }

    @Override
    public Boolean isHideSearchResults() {
        return (Boolean)this.hideSearchResults.getValue();
    }

    @Override
    public void setGroupBy(int ... columns) {
        TreeMapField[] treeMapFieldArray = this._model.getTreeMapFields(columns);
        this.setGroupByTreeMapFields(treeMapFieldArray);
    }

    @Override
    public void setGroupByByNames(String ... columnNames) {
        TreeMapField[] treeMapFieldArray = this._model.getTreeMapFields(columnNames);
        this.setGroupByTreeMapFields(treeMapFieldArray);
    }

    @Override
    public void setLabels(int ... columns) {
        TreeMapField[] treeMapFieldArray = this._model.getTreeMapFields(columns);
        this.setLabelTreeMapFields(treeMapFieldArray);
    }

    @Override
    public void setLabelsByNames(String ... columnNames) {
        TreeMapField[] treeMapFieldArray = this._model.getTreeMapFields(columnNames);
        this.setLabelTreeMapFields(treeMapFieldArray);
    }

    @Override
    public void setToolTip(int ... columns) {
        TreeMapField[] treeMapFieldArray = this._model.getTreeMapFields(columns);
        this.setToolTipTreeMapFields(treeMapFieldArray);
    }

    @Override
    public void setToolTipByNames(String ... columns) {
        TreeMapField[] treeMapFieldArray = this._model.getTreeMapFields(columns);
        this.setToolTipTreeMapFields(treeMapFieldArray);
    }

    @Override
    public boolean getShowPopup(TreeMapField field) {
        if (this.toolTipFields != null) {
            for (int i2 = 0; i2 < ((TreeMapField[])this.toolTipFields.getValue()).length; ++i2) {
                TreeMapField treeMapField = ((TreeMapField[])this.toolTipFields.getValue())[i2];
                if (treeMapField != field) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void setShowPopup(TreeMapField field, boolean show) {
        if (this.getShowPopup(field) != show) {
            if (show) {
                TreeMapField[] treeMapFieldArray = new TreeMapField[this.toolTipFields != null ? ((TreeMapField[])this.toolTipFields.getValue()).length + 1 : 1];
                if (this.toolTipFields != null) {
                    for (int i2 = 0; i2 < ((TreeMapField[])this.toolTipFields.getValue()).length; ++i2) {
                        TreeMapField treeMapField;
                        treeMapFieldArray[i2] = treeMapField = ((TreeMapField[])this.toolTipFields.getValue())[i2];
                    }
                }
                treeMapFieldArray[treeMapFieldArray.length - 1] = field;
                this.setToolTipTreeMapFields(treeMapFieldArray);
            } else {
                TreeMapField[] treeMapFieldArray = new TreeMapField[this.toolTipFields != null ? ((TreeMapField[])this.toolTipFields.getValue()).length - 1 : 0];
                if (this.toolTipFields != null) {
                    int n2 = 0;
                    for (int i3 = 0; i3 < ((TreeMapField[])this.toolTipFields.getValue()).length; ++i3) {
                        TreeMapField treeMapField = ((TreeMapField[])this.toolTipFields.getValue())[i3];
                        if (treeMapField == field) continue;
                        treeMapFieldArray[n2] = treeMapField;
                        ++n2;
                    }
                    this.setToolTipTreeMapFields(treeMapFieldArray);
                }
            }
        }
    }

    @Override
    public void setBackground(int column) {
        TreeMapField treeMapField = this._model.getTreeMapField(column);
        this.setBackgroundTreeMapField(treeMapField);
    }

    @Override
    public void setBackgroundTreeMapField(TreeMapField field) {
        this.backgroundField.setValue((Object)field);
    }

    @Override
    public void setBackgroundByName(String columnName) {
        TreeMapField treeMapField = this._model.getTreeMapFieldByName(columnName);
        this.setBackgroundTreeMapField(treeMapField);
    }

    @Override
    public void setSize(int column) {
        TreeMapField treeMapField = this._model.getTreeMapField(column);
        this.setSizeTreeMapField(treeMapField);
    }

    @Override
    public void setSizeTreeMapField(TreeMapField field) {
        this.sizeField.setValue((Object)field);
    }

    @Override
    public void setSizeByName(String columnName) {
        TreeMapField treeMapField = this._model.getTreeMapFieldByName(columnName);
        this.setSizeTreeMapField(treeMapField);
    }

    @Override
    public void setColor(int column) {
        TreeMapField treeMapField = this._model.getTreeMapField(column);
        this.setColorTreeMapField(treeMapField);
    }

    @Override
    public void setColorByName(String columnName) {
        TreeMapField treeMapField = this._model.getTreeMapFieldByName(columnName);
        this.setColorTreeMapField(treeMapField);
    }

    @Override
    public void setColorTreeMapField(TreeMapField field) {
        this.colorField.setValue((Object)field);
    }

    @Override
    public void setHeight(int column) {
        TreeMapField treeMapField = this._model.getTreeMapField(column);
        this.setHeightTreeMapField(treeMapField);
    }

    @Override
    public void setHeightByName(String columnName) {
        TreeMapField treeMapField = this._model.getTreeMapFieldByName(columnName);
        this.setHeightTreeMapField(treeMapField);
    }

    @Override
    public void setHeightTreeMapField(TreeMapField field) {
        this.heightField.setValue((Object)field);
    }

    @Override
    public Depth getDepth() {
        return (Depth)this._depth.getValue();
    }

    @Override
    public void setDepth(Depth depth) {
        this._depth.setValue((Object)depth);
    }

    @Override
    public void setRendering(Rendering rendering) {
        this._rendering.setValue((Object)rendering);
    }

    @Override
    public void setHideFilterResults(Boolean hideFilterResults) {
        this.hideFilterResults.setValue((Object)hideFilterResults);
    }

    @Override
    public void setHideSearchResults(Boolean hideSearchResults) {
        this.hideSearchResults.setValue((Object)hideSearchResults);
    }

    @Override
    public Rendering getRendering() {
        return (Rendering)this._rendering.getValue();
    }

    @Override
    public double getLightSourceHeight() {
        return this.lightSourceHeightInterval.getStart();
    }

    @Override
    public void setLightSourceHeight(double value) {
        this.lightSourceHeightInterval.setStart(value);
    }

    @Override
    public double getLightSourceAmbient() {
        return this.lightSourceAmbientInterval.getStart();
    }

    @Override
    public void setLightSourceAmbient(double value) {
        this.lightSourceAmbientInterval.setStart(value);
    }

    @Override
    public double getLightSourceX() {
        return this.lightSourceXInterval.getStart();
    }

    @Override
    public void setLightSourceX(double value) {
        this.lightSourceXInterval.setStart(value);
    }

    @Override
    public double getLightSourceY() {
        return this.lightSourceYInterval.getStart();
    }

    @Override
    public void setLightSourceY(double value) {
        this.lightSourceYInterval.setStart(value);
    }

    @Override
    public double getLightSourceZ() {
        return this.lightSourceZInterval.getStart();
    }

    @Override
    public void setLightSourceZ(double value) {
        this.lightSourceZInterval.setStart(value);
    }

    @Override
    public MutableProperty<CPColor<Color>> getBackgroundProperty() {
        return this._background;
    }

    @Override
    public CPColor<Color> getBackground() {
        return (CPColor)this._background.getValue();
    }

    @Override
    public void setBackground(CPColor<Color> color) {
        this._background.setValue(color);
    }

    @Override
    public MutableProperty<CPColor<Color>> getTooltipBackgroundProperty() {
        return this._tooltipBackground;
    }

    @Override
    public CPColor<Color> getTooltipBackground() {
        return (CPColor)this._tooltipBackground.getValue();
    }

    @Override
    public void setTooltipBackground(CPColor<Color> color) {
        this._tooltipBackground.setValue(color);
    }

    @Override
    public MutableProperty<CPColor<Color>> getProbingColorProperty() {
        return this._probingColor;
    }

    @Override
    public CPColor<Color> getProbingColor() {
        return (CPColor)this._probingColor.getValue();
    }

    @Override
    public void setProbingColor(CPColor<Color> color) {
        this._probingColor.setValue(color);
    }

    @Override
    public MutableProperty<CPColor<Color>> getSelectionColorProperty() {
        return this._selectionColor;
    }

    @Override
    public CPColor<Color> getSelectionColor() {
        return (CPColor)this._selectionColor.getValue();
    }

    @Override
    public void setSelectionColor(CPColor<Color> color) {
        this._selectionColor.setValue(color);
    }

    @Override
    public Object getValue(String key) {
        return this.a.getValue((Object)key);
    }

    @Override
    public MutableBoundedInterval getLightSourceHeightInterval() {
        return this.lightSourceHeightInterval;
    }

    @Override
    public MutableBoundedInterval getLightSourceAmbientInterval() {
        return this.lightSourceAmbientInterval;
    }

    @Override
    public MutableBoundedInterval getLightSourceXInterval() {
        return this.lightSourceXInterval;
    }

    @Override
    public MutableBoundedInterval getLightSourceYInterval() {
        return this.lightSourceYInterval;
    }

    @Override
    public MutableBoundedInterval getLightSourceZInterval() {
        return this.lightSourceZInterval;
    }

    @Override
    public void resetToDefaults() {
        this.setDimensionFixed(false);
        this.setProgressive(TreeMapView.Progressive.Disabled);
        this.setDepth(DepthFactory.getInstance().getDefault());
        this.setRendering(RenderingFactory.getInstance().getDefault());
        this.setMaximumHeight(0.03);
        this.setBackground(null);
        this.setTooltipBackground(this.g.createRGBAColor(232, 232, 232, 200));
        this.setProbingColor(this.g.createRGBAColor(0, 0, 0, 240));
        this.setSelectionColor(this.g.createRGBColor(255, 102, 0));
        this.setHideSearchResults(true);
        this.setHideFilterResults(true);
    }

    @Override
    public void save(DataFrame dataFrame, ElementFactory elementFactory, Element root) {
        Object object2;
        Element element;
        TreeMapField treeMapField2;
        Element element2 = elementFactory.newElement("Configuration");
        Element element3 = elementFactory.newElement("GroupBy");
        for (TreeMapField treeMapField2 : this.groupByVariables) {
            if (!treeMapField2.isValid()) continue;
            element = elementFactory.newElement("Variable");
            element.addAttribute(elementFactory.newAttribute("name", treeMapField2.getName()));
            element.addAttribute(elementFactory.newAttribute("index", Integer.toString(dataFrame.getColumnAddress(treeMapField2.getIndex()))));
            element3.appendChild(element);
        }
        element2.appendChild(element3);
        Iterator iterator = elementFactory.newElement("Size");
        if (this.sizeVariable.getSelected() != null && ((TreeMapField)this.sizeVariable.getSelected()).isValid()) {
            iterator.addAttribute(elementFactory.newAttribute("variableName", ((TreeMapField)this.sizeVariable.getSelected()).getName()));
            iterator.addAttribute(elementFactory.newAttribute("variableIndex", Integer.toString(dataFrame.getColumnAddress(((TreeMapField)this.sizeVariable.getSelected()).getIndex()))));
        }
        element2.appendChild((Element)iterator);
        treeMapField2 = elementFactory.newElement("Color");
        if (this.colorVariable.getSelected() != null && ((TreeMapField)this.colorVariable.getSelected()).isValid()) {
            treeMapField2.addAttribute(elementFactory.newAttribute("variableName", ((TreeMapField)this.colorVariable.getSelected()).getName()));
            treeMapField2.addAttribute(elementFactory.newAttribute("variableIndex", Integer.toString(dataFrame.getColumnAddress(((TreeMapField)this.colorVariable.getSelected()).getIndex()))));
        }
        element2.appendChild((Element)treeMapField2);
        element = elementFactory.newElement("Height");
        if (this.heightVariable.getSelected() != null && ((TreeMapField)this.heightVariable.getSelected()).isValid()) {
            element.addAttribute(elementFactory.newAttribute("variableName", ((TreeMapField)this.heightVariable.getSelected()).getName()));
            element.addAttribute(elementFactory.newAttribute("variableIndex", Integer.toString(dataFrame.getColumnAddress(((TreeMapField)this.heightVariable.getSelected()).getIndex()))));
        }
        element2.appendChild(element);
        Element element4 = elementFactory.newElement("Label");
        for (Object object2 : this.labelVariable) {
            if (!object2.isValid()) continue;
            Object object3 = elementFactory.newElement("Variable");
            object3.addAttribute(elementFactory.newAttribute("name", object2.getName()));
            object3.addAttribute(elementFactory.newAttribute("index", Integer.toString(dataFrame.getColumnAddress(object2.getIndex()))));
            element4.appendChild((Element)object3);
        }
        element2.appendChild(element4);
        Iterator iterator2 = elementFactory.newElement("Tooltip");
        for (Object object3 : this.toolTipVariable) {
            if (!object3.isValid()) continue;
            Element element5 = elementFactory.newElement("Variable");
            element5.addAttribute(elementFactory.newAttribute("name", object3.getName()));
            element5.addAttribute(elementFactory.newAttribute("index", Integer.toString(dataFrame.getColumnAddress(object3.getIndex()))));
            iterator2.appendChild(element5);
        }
        element2.appendChild((Element)iterator2);
        object2 = elementFactory.newElement("Background");
        if (this.backgroundVariable.getSelected() != null && ((TreeMapField)this.backgroundVariable.getSelected()).isValid()) {
            object2.addAttribute(elementFactory.newAttribute("variableName", ((TreeMapField)this.backgroundVariable.getSelected()).getName()));
            object2.addAttribute(elementFactory.newAttribute("variableIndex", Integer.toString(dataFrame.getColumnAddress(((TreeMapField)this.backgroundVariable.getSelected()).getIndex()))));
        }
        element2.appendChild((Element)object2);
        root.appendChild(element2);
    }
}

