/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.AbstractNesting;
import com.treemap.TreeMapModel;

class ProportionalNesting<N, Row, Column, Color, Font>
extends AbstractNesting<N, Row, Column, Color, Font> {
    private static final Type b = Type.EqualBorderWidth;

    ProportionalNesting() {
    }

    @Override
    public Shape subtract(TreeMapModel<N, Row, Column, Color, Font> model, Shape shape, N node, double amount) {
        if (!model.isRoot(node) && shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            double d2 = amount / 100.0;
            switch (b) {
                case Raw: {
                    double d3 = rectangle2D.getX() + rectangle2D.getWidth() * d2;
                    double d4 = rectangle2D.getY() + rectangle2D.getHeight() * d2;
                    double d5 = rectangle2D.getWidth() * (1.0 - 2.0 * d2);
                    double d6 = rectangle2D.getHeight() * (1.0 - 2.0 * d2);
                    return new Rectangle2D.Double(d3, d4, d5, d6);
                }
                case KeepAspectRatio: {
                    double d7 = rectangle2D.getWidth() * rectangle2D.getHeight();
                    double d8 = (1.0 - d2) * d7;
                    double d9 = rectangle2D.getWidth() * Math.sqrt(d8 / d7);
                    double d10 = rectangle2D.getHeight() * Math.sqrt(d8 / d7);
                    double d11 = rectangle2D.getX() + (rectangle2D.getWidth() - d9) / 2.0;
                    double d12 = rectangle2D.getY() + (rectangle2D.getHeight() - d10) / 2.0;
                    Rectangle2D.Double double_ = new Rectangle2D.Double(d11, d12, d9, d10);
                    assert (Math.round(double_.getWidth() * double_.getHeight()) == Math.round(d8)) : double_.getWidth() * double_.getHeight() + "!=" + d8;
                    return double_;
                }
                case EqualBorderWidth: {
                    double d13 = rectangle2D.getWidth() * rectangle2D.getHeight();
                    double d14 = (1.0 - d2) * d13;
                    double d15 = rectangle2D.getWidth();
                    double d16 = rectangle2D.getHeight();
                    double d17 = (-Math.sqrt(4.0 * d14 + d16 * d16 - 2.0 * d16 * d15 + d15 * d15) + d16 + d15) / 4.0;
                    Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() + d17, rectangle2D.getY() + d17, rectangle2D.getWidth() - 2.0 * d17, rectangle2D.getHeight() - 2.0 * d17);
                    assert (Math.round(double_.getWidth() * double_.getHeight()) == Math.round(d14)) : double_.getWidth() * double_.getHeight() + "!=" + d14;
                    return double_;
                }
            }
            return shape;
        }
        return shape;
    }

    public String toString() {
        return "Proportional";
    }

    public static enum Type {
        Raw,
        KeepAspectRatio,
        EqualBorderWidth;

    }
}

