/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.AbstractAlgorithm;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapNode;
import com.treemap.TreeMapWorker;

public class SliceAndDiceAlgorithm
extends AbstractAlgorithm {
    private final OrientationStragegy a;

    public SliceAndDiceAlgorithm() {
        this(new AlternateOrientationStrategy());
    }

    public SliceAndDiceAlgorithm(OrientationStragegy orientationStrategy) {
        this.a = orientationStrategy;
    }

    @Override
    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d2 = 0.0;
        for (MutableTreeMapNode mutableTreeMapNode : children) {
            double d3 = mutableTreeMapNode.getSize() / sumSizes;
            Rectangle2D.Double double_ = this.a.isVertical(rectangle2D, parent) ? new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight() * d2, rectangle2D.getWidth(), rectangle2D.getHeight() * d3) : new Rectangle2D.Double(rectangle2D.getX() + rectangle2D.getWidth() * d2, rectangle2D.getY(), rectangle2D.getWidth() * d3, rectangle2D.getHeight());
            mutableTreeMapNode.setShape((Shape)double_);
            d2 += d3;
        }
        return false;
    }

    @Override
    public boolean isCompatible(Shape shape) {
        return shape instanceof Rectangle2D;
    }

    String a() {
        return "Slice-and-dice";
    }

    public String toString() {
        return this.a();
    }

    public static class AlternateOrientationStrategy
    implements OrientationStragegy {
        @Override
        public boolean isVertical(Rectangle2D bounds, TreeMapNode parent) {
            return (parent.getLevel() + 1) % 2 == 0;
        }
    }

    public static class BestOrientationStrategy
    implements OrientationStragegy {
        @Override
        public boolean isVertical(Rectangle2D bounds, TreeMapNode parent) {
            return bounds.getWidth() <= bounds.getHeight();
        }
    }

    public static class HoritzonalOrientationStrategy
    implements OrientationStragegy {
        @Override
        public boolean isVertical(Rectangle2D bounds, TreeMapNode parent) {
            return false;
        }
    }

    public static class VerticalOrientationStrategy
    implements OrientationStragegy {
        @Override
        public boolean isVertical(Rectangle2D bounds, TreeMapNode parent) {
            return true;
        }
    }

    public static interface OrientationStragegy {
        public boolean isVertical(Rectangle2D var1, TreeMapNode var2);
    }
}

