/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.DefaultTreeMapTooltipRenderer;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.PreferredSize;
import com.treemap.crossplatform.TGraphics;
import java.util.concurrent.Future;

public class ToolTipTreeMapRenderer<C, N, Row, Column, Color, Font> {
    final EnhancedLabel<Color, Font> a = new EnhancedLabel();

    public ToolTipTreeMapRenderer() {
        this.a.setInsets(DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.top, DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.left, DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.bottom, DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.right);
    }

    public void paint(TGraphics<Color, Font> g2, TreeMapView<C, N, Row, Column, Color, Font> view, N node, int width, int leftShift, int topShift, Future progress) {
        Shape shape;
        TreeMapModel<N, Row, Column, Color, Font> treeMapModel = view.getModel();
        if (node != null && (shape = view.getRenderedShape(treeMapModel.getCurrentRoot())) != null) {
            this.drawToolTip(g2, view, treeMapModel, node, width, leftShift, topShift, true);
        }
    }

    public Rectangle drawToolTip(TGraphics<Color, Font> g2, TreeMapView<C, N, Row, Column, Color, Font> view, TreeMapModel<N, Row, Column, Color, Font> model, N node, int width, int leftShift, int topShift, boolean paint) {
        Rectangle rectangle = model.getSettings().getToolTipTreeMapFields();
        if (rectangle != null && ((TreeMapField<N, Column>[])rectangle).length >= 0) {
            CPFont cPFont;
            EnhancedLabel<Color, Font> enhancedLabel;
            int n2 = 0;
            for (TreeMapField<N, Column> treeMapField : rectangle) {
                EnhancedLabel<Color, Font> enhancedLabel2;
                if (!treeMapField.isValid() || (enhancedLabel2 = view.getTooltipRenderer().getTooltipRendererComponent(view, treeMapField, node, new Dimension(width, 1000))) == null) continue;
                CPFont<Font> cPFont2 = view.getModel().getSettings().getFieldSettings(treeMapField).getTooltipFont();
                enhancedLabel = cPFont2.deriveFontWeight(CPFont.Weight.BOLD);
                enhancedLabel2.setFont((CPFont)enhancedLabel);
                enhancedLabel2.setForeground(view.getModel().getSettings().getFieldSettings(treeMapField).getTooltipForeground());
                enhancedLabel2.setBackground(null);
                int n3 = width - 2 - 1;
                if (model.getSettings().getFieldSettings(treeMapField).getShowLabel() && model.getSettings().getFieldSettings(treeMapField).getTooltipRendering() == EnhancedLabel.Rendering.WordWrap) {
                    this.a.setFont(cPFont2);
                    this.a.setForeground(view.getModel().getSettings().getFieldSettings(treeMapField).getTooltipForeground());
                    this.a.setBackground(null);
                    this.a.setText(treeMapField.getName() + ": ");
                    cPFont = view.getHeadless().sizeLabel(this.a, g2, n3, 1000).getPreferredSize();
                } else {
                    cPFont = new Dimension(0, 0);
                }
                PreferredSize preferredSize = view.getHeadless().sizeLabel(enhancedLabel2, g2, n3 - cPFont.width, 1000);
                n2 = (int)((double)n2 + preferredSize.getPreferredHeight());
            }
            Rectangle rectangle2 = new Rectangle(0, 0, width, n2);
            if (n2 <= 0) {
                return null;
            }
            int n4 = rectangle2.y;
            for (CPFont<Font> cPFont2 : rectangle) {
                Rectangle rectangle3;
                Dimension dimension;
                if (!cPFont2.isValid() || (enhancedLabel = view.getTooltipRenderer().getTooltipRendererComponent(view, (TreeMapField<N, Column>)cPFont2, node, new Dimension(width, 1000))) == null) continue;
                CPFont<Font> cPFont3 = view.getModel().getSettings().getFieldSettings((TreeMapField)cPFont2).getTooltipFont();
                cPFont = cPFont3.deriveFontWeight(CPFont.Weight.BOLD);
                enhancedLabel.setFont(cPFont);
                enhancedLabel.setForeground(view.getModel().getSettings().getFieldSettings((TreeMapField)cPFont2).getTooltipForeground());
                enhancedLabel.setBackground(null);
                int n5 = rectangle2.width - 2 - 1;
                if (model.getSettings().getFieldSettings((TreeMapField)cPFont2).getShowLabel()) {
                    this.a.setFont(cPFont3);
                    this.a.setForeground(view.getModel().getSettings().getFieldSettings((TreeMapField)cPFont2).getTooltipForeground());
                    this.a.setBackground(null);
                    this.a.setText(cPFont2.getName() + ": ");
                    dimension = view.getHeadless().sizeLabel(this.a, g2, n5, 1000).getPreferredSize();
                } else {
                    dimension = new Dimension(0, 0);
                }
                PreferredSize preferredSize = view.getHeadless().sizeLabel(enhancedLabel, g2, n5 - dimension.width, 1000);
                Dimension dimension2 = preferredSize.getPreferredSize();
                if (n4 + dimension2.height > rectangle2.y + rectangle2.height) break;
                int n6 = rectangle2.x + 2;
                if (model.getSettings().getFieldSettings((TreeMapField)cPFont2).getShowLabel()) {
                    rectangle3 = new Rectangle(n6, n4, dimension.width, dimension.height);
                    if (paint && g2 != null) {
                        g2.paintLabel(this.a, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    }
                    if (model.isNumericType((TreeMapField<N, Column>)cPFont2)) {
                        n6 += dimension.width;
                        n5 -= dimension.width;
                    } else {
                        n6 += dimension.width;
                        n5 -= dimension.width;
                    }
                }
                rectangle3 = new Rectangle(n6, n4, n5, dimension2.height);
                if (paint && g2 != null) {
                    g2.paintLabel(enhancedLabel, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                }
                n4 += dimension2.height;
            }
            return rectangle2;
        }
        return null;
    }
}

