/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.tagcloud;

import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.igraphics.CPFont;
import com.treemap.MutableTreeMapNode;
import com.treemap.tagcloud.HierarchicalBoundingBoxes;
import com.treemap.tagcloud.Orientation;
import com.treemap.tagcloud.Point2d;
import com.treemap.tagcloud.TextShape;
import com.treemap.tagcloud.TextShapeFactory;
import com.treemap.tagcloud.Word;

public class DefaultWord
implements Word {
    private final String a;
    private final double b;
    private final MutableTreeMapNode c;
    private final Point2d d = new Point2d();
    private final TextShape e;
    private HierarchicalBoundingBoxes f;

    public DefaultWord(TextShapeFactory textShapeFactory, String text, double size, MutableTreeMapNode treeMapNode, Orientation orientation, int nSubdivisions, CPFont font) {
        this.a = text;
        this.b = size;
        this.c = treeMapNode;
        font = font.deriveFontSize(40.0);
        TextShape textShape = textShapeFactory.createTextShape(text, font);
        Rectangle2D rectangle2D = textShape.getBounds2D();
        TextShape textShape2 = (TextShape)textShape.createTransformedShape(AffineTransform.getTranslateInstance((double)(-rectangle2D.getWidth() / 2.0), (double)(rectangle2D.getHeight() / 2.0)));
        TextShape textShape3 = (TextShape)textShape2.createTransformedShape(AffineTransform.getScaleInstance((double)size, (double)size));
        if (orientation == Orientation.Vertical) {
            textShape3 = (TextShape)textShape3.createTransformedShape(AffineTransform.getRotateInstance((double)1.5707963267948966));
        }
        this.e = textShape3;
        this.f = new HierarchicalBoundingBoxes(textShape3, nSubdivisions, 1.25);
    }

    @Override
    public boolean intersects(Word otherWord) {
        return this.f.intersects(((DefaultWord)otherWord).f);
    }

    public double getSize() {
        return this.b;
    }

    public String getText() {
        return this.a;
    }

    @Override
    public MutableTreeMapNode getTreeMapNode() {
        return this.c;
    }

    @Override
    public int compareTo(Word anotherWord) {
        return Double.valueOf(this.b).compareTo(((DefaultWord)anotherWord).getSize());
    }

    public void setLocation(double xPos, double yPos) {
        this.d.set(xPos, yPos);
        this.f.setTranslation(xPos, yPos);
    }

    @Override
    public TextShape getShapeForLayout() {
        return (TextShape)this.e.createTransformedShape(AffineTransform.getTranslateInstance((double)this.d.x, (double)this.d.y));
    }

    @Override
    public void setLocation(Point2d position) {
        this.setLocation(position.x, position.y);
    }

    public String toString() {
        return "Word{text='" + this.a + '\'' + ", size=" + this.b + ", child=" + this.c + ", location=" + this.d + ", normedAndCenteredShape=" + this.e + ", hierarchicalBoundingBoxes=" + this.f + '}';
    }
}

