/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.tagcloud;

import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.IHeadless;
import com.treemap.tagcloud.TextShape;

public class RectangularTextShape
implements TextShape {
    private final String a;
    private CPFont b;
    private final Rectangle2D c;

    public RectangularTextShape(IHeadless headless, CPFont font, String text) {
        Rectangle2D rectangle2D = headless.getStringBounds(null, font, text);
        this.c = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        this.b = font;
        this.a = text;
    }

    public RectangularTextShape(CPFont font, String text, Rectangle2D shape) {
        this.b = font;
        this.a = text;
        this.c = shape;
    }

    @Override
    public String getText() {
        return this.a;
    }

    @Override
    public CPFont getFont() {
        return this.b;
    }

    @Override
    public boolean isTextOutline() {
        return false;
    }

    public Rectangle2D getBounds2D() {
        return this.c.getBounds2D();
    }

    public boolean intersects(Rectangle2D r2) {
        return this.c.intersects(r2);
    }

    public boolean contains(Point2D point) {
        double d2 = point.getX();
        double d3 = point.getY();
        double d4 = this.c.getX();
        double d5 = this.c.getY();
        return d2 >= d4 && d3 >= d5 && d2 < d4 + this.c.getWidth() && d3 < d5 + this.c.getHeight();
    }

    public PathIterator getPathIterator() {
        return this.c.getPathIterator();
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.c.getPathIterator(at);
    }

    public PathIterator getFlattenPathIterator(double flatness) {
        return this.c.getFlattenPathIterator(flatness);
    }

    @Override
    public final synchronized Shape createTransformedShape(AffineTransform at) {
        this.b = this.b.deriveFontSize(at.getScaleY() * this.b.getSize2D());
        return new RectangularTextShape(this.b, this.a, at != null ? RectangularTextShape.transformBounds(this.c, at) : this.c);
    }

    public static Rectangle2D transformBounds(Rectangle2D rect, AffineTransform at) {
        double[] dArray;
        if (!RectangularTextShape.isOrthogonal(at)) {
            Rectangle2D rectangle2D = at.createTransformedShape((Shape)rect).getBounds2D();
            return rectangle2D;
        }
        if (rect instanceof Rectangle2D.Double) {
            Rectangle2D.Double double_ = (Rectangle2D.Double)rect;
            double[] dArray2 = new double[]{double_.getX(), double_.getY(), double_.getX() + double_.getWidth(), double_.getY() + double_.getHeight()};
            at.transform(dArray2, 0, dArray2, 0, 2);
            return new Rectangle2D.Double(dArray2[0], dArray2[1], dArray2[2] - dArray2[0], dArray2[3] - dArray2[1]);
        }
        dArray = new double[]{rect.getX(), rect.getY(), dArray[0] + rect.getWidth(), dArray[1] + rect.getHeight()};
        at.transform(dArray, 0, dArray, 0, 2);
        return new Rectangle2D.Double(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public static boolean isOrthogonal(AffineTransform at) {
        int n2 = at.getType();
        return (n2 & 0x38) == 0;
    }
}

