/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.action;

import com.macrofocus.colormap.swing.SwingColorMapPanel;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.util.swing.FileChooserFactory;
import com.macrofocus.util.swing.action.AbstractMAction;
import com.treemap.TreeMapField;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ImportColorMapAction
extends AbstractMAction {
    private final FileChooserFactory fileChooserFactory;
    private final Container contentPane;
    private SwingColorMapPanel<TreeMapField> colorMapPanel;

    public ImportColorMapAction(Container contentPane, FileChooserFactory fileChooserFactory, ResourcesModel resourcesModel) {
        super("Import Colormap", "action.importcolormap.label", true, resourcesModel);
        this.fileChooserFactory = fileChooserFactory;
        this.contentPane = contentPane;
    }

    public void actionPerformed(ActionEvent event) {
        File file;
        FileFilter fileFilter = null;
        do {
            JFileChooser fileChooser;
            int value;
            if ((value = (fileChooser = this.fileChooserFactory.getFileChooser()).showOpenDialog(this.contentPane)) != 0) {
                return;
            }
            file = fileChooser.getSelectedFile();
            fileFilter = fileChooser.getFileFilter();
        } while (file == null || !file.exists() || fileFilter == null);
        try {
            this.colorMapPanel.loadColorMap((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setColorMapPanel(SwingColorMapPanel<TreeMapField> colorMapPanel) {
        this.colorMapPanel = colorMapPanel;
    }
}

