/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.action;

import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class PrintAction
extends AbstractAction {
    private Action action;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener();

    public PrintAction(ResourcesModel resourcesModel) {
        URL url = resourcesModel.getUrl("Print16.gif");
        if (url != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        }
        final PropertiesModel propertiesModel = resourcesModel.getPropertiesModel();
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    PrintAction.this.updateProperties(propertiesModel);
                }
            });
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("MnemonicKey", 80);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.action != null) {
            this.action.actionPerformed(e);
        }
    }

    public void setAction(Action action) {
        if (this.action != null) {
            this.action.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.action = action;
        if (action != null) {
            action.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.checkEnabled();
    }

    private void checkEnabled() {
        this.setEnabled(this.action != null && this.action.isEnabled());
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        Object name = "Print...";
        if (propertiesModel != null && propertiesModel.isAvailable("action.print.label")) {
            name = propertiesModel.getValue("action.print.label") + "...";
        }
        this.putValue("Name", name);
    }

    private class PropertyChangeListener
    implements java.beans.PropertyChangeListener {
        private PropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PrintAction.this.checkEnabled();
        }
    }
}

