/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration;

import com.jidesoft.utils.TypeUtils;
import com.macrofocus.crossplatform.swing.MJPanel;
import com.macrofocus.layoutmanager.MinimumProportionalConstraint;
import com.macrofocus.layoutmanager.PreferredProportionalConstraint;
import com.macrofocus.layoutmanager.VerticalProportionalLayoutManager;
import com.treemap.AbstractTreeMapNode;
import com.treemap.TreeMapEvent;
import com.treemap.TreeMapField;
import com.treemap.TreeMapListener;
import com.treemap.app.swing.configuration.CategoricalFilterPanel;
import com.treemap.app.swing.configuration.FilterPanel;
import com.treemap.app.swing.configuration.RangeSliderFilterPanel;
import com.treemap.app.swing.v4.model.MTreeMapModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;

class InnerFiltersPanel<N extends AbstractTreeMapNode<N, Row, Column, Color, Font>, Row, Column>
extends MJPanel {
    private final List<FilterPanel> filters = new ArrayList<FilterPanel>();
    private MTreeMapModel<N, Row, Column> treeMapModel;

    public InnerFiltersPanel() {
        this.setLayout((LayoutManager)new VerticalProportionalLayoutManager());
    }

    public void setModel(final MTreeMapModel<N, Row, Column> treeMapModel) {
        this.treeMapModel = treeMapModel;
        this.createFilters(treeMapModel);
        treeMapModel.addListener(new TreeMapListener(){

            public void tableModelChanged() {
                InnerFiltersPanel.this.resetFilters();
                InnerFiltersPanel.this.createFilters(treeMapModel);
                InnerFiltersPanel.this.applyFilters();
            }

            public void treeMapChanged(TreeMapEvent event) {
                if (event.isGroupByChanged()) {
                    InnerFiltersPanel.this.applyFilters();
                }
            }
        });
        this.applyFilters();
    }

    public void resetFilters() {
        for (int i = 0; i < this.filters.size(); ++i) {
            FilterPanel filter = this.filters.get(i);
            if (filter == null) continue;
            filter.reset();
            this.treeMapModel.getFilter().clearFilterBy((Object)filter);
        }
        this.applyFilters();
    }

    private void createFilters(MTreeMapModel<N, Row, Column> treeMapModel) {
        this.removeAll();
        this.filters.clear();
        for (int i = 0; i < treeMapModel.getDataFrame().getColumnCount(); ++i) {
            FilterPanel filterPanel;
            TreeMapField variable = treeMapModel.getTreeMapField(i);
            if (TypeUtils.isNumericType((Class)variable.getType()) && treeMapModel.getNumericMax(variable) != null && treeMapModel.getNumericMin(variable) != null) {
                filterPanel = new RangeSliderFilterPanel(this, treeMapModel, variable, i);
                this.add((Component)((Object)filterPanel), new MinimumProportionalConstraint(0, 0, 6, 0));
                this.filters.add(filterPanel);
                continue;
            }
            if (!variable.getType().isArray() && !TypeUtils.isTemporalType((Class)variable.getType()) && Comparable.class.isAssignableFrom(variable.getType()) && !Geometry.class.isAssignableFrom(variable.getType())) {
                filterPanel = new CategoricalFilterPanel(this, treeMapModel, variable);
                this.add((Component)((Object)filterPanel), new PreferredProportionalConstraint(0, 0, 6, 0));
                this.filters.add(filterPanel);
                continue;
            }
            this.filters.add(null);
        }
    }

    public void applyFilters() {
        if (this.treeMapModel != null && this.treeMapModel.getRoot() != null) {
            for (int i = 0; i < this.filters.size(); ++i) {
                FilterPanel filter = this.filters.get(i);
                if (filter == null) continue;
                for (AbstractTreeMapNode node : this.treeMapModel.breadthFirstIterator((AbstractTreeMapNode)this.treeMapModel.getRoot())) {
                    Object object;
                    Boolean toFilter;
                    if (node.getRow() == null || (toFilter = filter.applyFilters(object = this.treeMapModel.getDataFrame().getValueAt(node.getRow(), this.treeMapModel.getDataFrame().getColumnKey(i)))) == null) continue;
                    this.treeMapModel.getFilter().setFiltered((Object)node, toFilter.booleanValue(), (Object)filter);
                }
            }
        }
    }

    public void setFilterVisible(int column, boolean value) {
        FilterPanel filter = this.filters.get(column);
        if (filter != null) {
            filter.setVisible(value);
        }
    }

    public void setCategoricalFilter(int column, Object[] values) {
        FilterPanel filter = this.filters.get(column);
        if (filter != null && filter instanceof CategoricalFilterPanel) {
            ((CategoricalFilterPanel)filter).setFilter(values);
        }
    }

    public void setNumericalFilter(int column, double min, double max) {
        FilterPanel filter = this.filters.get(column);
        if (filter != null && filter instanceof RangeSliderFilterPanel) {
            ((RangeSliderFilterPanel)filter).setFilter(min, max);
        }
    }
}

