/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.macrofocus.combobox.MColorComboBox;
import com.macrofocus.combobox.MJYComboBox;
import com.macrofocus.crossplatform.swing.ColorComboBoxModel;
import com.macrofocus.crossplatform.swing.MJPanel;
import com.macrofocus.crossplatform.swing.MJSpinner;
import com.macrofocus.interval.adapter.BoundedIntervalSpinnerModel;
import com.macrofocus.properties.swing.PropertyDimensionSpinnerModel;
import com.macrofocus.selection.swing.SingleSelectionButtonModel;
import com.macrofocus.selection.swing.SingleSelectionComboBoxModel;
import com.macrofocus.util.swing.spinner.EnhancedSlider;
import com.treemap.DepthFactory;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapSettings;
import com.treemap.TreeMapView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.border.TitledBorder;

public class RenderingSettingsPanel {
    private JPanel mainPanel;
    private MJYComboBox progressiveComboBox;
    private MJYComboBox depthComboBox;
    private EnhancedSlider ambientLightSlider;
    private EnhancedSlider lightSourceHeightSlider;
    private EnhancedSlider lightSourceXSlider;
    private EnhancedSlider lightSourceYSlider;
    private EnhancedSlider maximumHeightSlider;
    private EnhancedSlider lightSourceZSlider;
    private JLabel maximumHeightLabel;
    private MColorComboBox selectionComboBox;
    private MColorComboBox probingComboBox;
    private MColorComboBox tooltipBackgroundComboBox;
    private JCheckBox hideFilteredCheckBox;
    private JCheckBox hideSearchedCheckBox;
    private JSpinner widthSpinner;
    private JSpinner heightSpinner;
    private JCheckBox fixedDimensionCheckBox;
    private MColorComboBox borderColorComboBox;
    private JSpinner borderThicknessSpinner;

    public RenderingSettingsPanel(TreeMapModel model) {
        this.$$$setupUI$$$();
        this.fixedDimensionCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RenderingSettingsPanel.this.widthSpinner.setEnabled(RenderingSettingsPanel.this.fixedDimensionCheckBox.isSelected());
                RenderingSettingsPanel.this.heightSpinner.setEnabled(RenderingSettingsPanel.this.fixedDimensionCheckBox.isSelected());
            }
        });
        TreeMapSettings settings = model.getSettings();
        this.fixedDimensionCheckBox.setModel((ButtonModel)new SingleSelectionButtonModel(settings.getProperties().getProperty((Object)"dimensionFixed")));
        this.widthSpinner.setModel((SpinnerModel)new PropertyDimensionSpinnerModel(settings.getProperties().getProperty((Object)"dimension"), PropertyDimensionSpinnerModel.Axe.Width));
        this.heightSpinner.setModel((SpinnerModel)new PropertyDimensionSpinnerModel(settings.getProperties().getProperty((Object)"dimension"), PropertyDimensionSpinnerModel.Axe.Height));
        this.progressiveComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getProgressiveSelection(), (Object[])TreeMapView.Progressive.values()));
        this.depthComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getDepthSelection(), (Iterable)DepthFactory.getInstance().getDepths()));
        this.maximumHeightSlider.setModel(settings.getMaximumHeightInterval());
        this.lightSourceHeightSlider.setModel(settings.getLightSourceHeightInterval());
        this.ambientLightSlider.setModel(settings.getLightSourceAmbientInterval());
        this.lightSourceXSlider.setModel(settings.getLightSourceXInterval());
        this.lightSourceYSlider.setModel(settings.getLightSourceYInterval());
        this.lightSourceZSlider.setModel(settings.getLightSourceZInterval());
        this.ambientLightSlider.setModel(settings.getLightSourceAmbientInterval());
        this.selectionComboBox.setModel((ComboBoxModel)new ColorComboBoxModel(settings.getProperties().getProperty((Object)"selectionColor")));
        this.probingComboBox.setModel((ComboBoxModel)new ColorComboBoxModel(settings.getProperties().getProperty((Object)"probingColor")));
        this.tooltipBackgroundComboBox.setModel((ComboBoxModel)new ColorComboBoxModel(settings.getProperties().getProperty((Object)"tooltipBackground")));
        this.hideFilteredCheckBox.setModel((ButtonModel)new SingleSelectionButtonModel(settings.getHideFilterResultsSelection()));
        this.hideSearchedCheckBox.setModel((ButtonModel)new SingleSelectionButtonModel(settings.getHideSearchResultsSelection()));
        this.borderColorComboBox.setModel((ComboBoxModel)new ColorComboBoxModel(settings.getDefaultFieldSettings().getBorderColorProperty()));
        this.borderThicknessSpinner.setModel((SpinnerModel)new BoundedIntervalSpinnerModel(settings.getDefaultFieldSettings().getBorderThicknessInterval(), (Number)0.25));
        this.mainPanel.setBorder(new TitledBorder(""));
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, 2));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel1, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        panel1.setBorder(BorderFactory.createTitledBorder(null, "3D Effect", 0, 0, null, null));
        JLabel label1 = new JLabel();
        label1.setText("Ambient Light:");
        panel1.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        this.ambientLightSlider = new EnhancedSlider();
        panel1.add((Component)this.ambientLightSlider, new GridConstraints(0, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Light Height:");
        panel1.add((Component)label2, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JLabel label3 = new JLabel();
        label3.setText("Light Source X:");
        panel1.add((Component)label3, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JLabel label4 = new JLabel();
        label4.setText("Light Source Y:");
        panel1.add((Component)label4, new GridConstraints(3, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JLabel label5 = new JLabel();
        label5.setText("Light Source Z:");
        panel1.add((Component)label5, new GridConstraints(4, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        this.maximumHeightLabel = new JLabel();
        this.maximumHeightLabel.setText("Maximum Height:");
        this.maximumHeightLabel.setVisible(false);
        panel1.add((Component)this.maximumHeightLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        this.lightSourceHeightSlider = new EnhancedSlider();
        panel1.add((Component)this.lightSourceHeightSlider, new GridConstraints(1, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.lightSourceXSlider = new EnhancedSlider();
        panel1.add((Component)this.lightSourceXSlider, new GridConstraints(2, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.lightSourceYSlider = new EnhancedSlider();
        panel1.add((Component)this.lightSourceYSlider, new GridConstraints(3, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.lightSourceZSlider = new EnhancedSlider();
        panel1.add((Component)this.lightSourceZSlider, new GridConstraints(4, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.maximumHeightSlider = new EnhancedSlider();
        this.maximumHeightSlider.setVisible(false);
        panel1.add((Component)this.maximumHeightSlider, new GridConstraints(5, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel2, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        panel2.setBorder(BorderFactory.createTitledBorder(null, "Appearance", 0, 0, null, null));
        JLabel label6 = new JLabel();
        label6.setText("Selection:");
        panel2.add((Component)label6, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JLabel label7 = new JLabel();
        label7.setText("Probing:");
        panel2.add((Component)label7, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JLabel label8 = new JLabel();
        label8.setText("Tooltip Background:");
        panel2.add((Component)label8, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        this.selectionComboBox = new MColorComboBox();
        panel2.add((Component)this.selectionComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.probingComboBox = new MColorComboBox();
        panel2.add((Component)this.probingComboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.tooltipBackgroundComboBox = new MColorComboBox();
        panel2.add((Component)this.tooltipBackgroundComboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JLabel label9 = new JLabel();
        label9.setText("Hide Filtered:");
        label9.setVisible(false);
        this.mainPanel.add((Component)label9, new GridConstraints(6, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JLabel label10 = new JLabel();
        label10.setText("Hide Searched:");
        label10.setVisible(false);
        this.mainPanel.add((Component)label10, new GridConstraints(7, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        this.hideFilteredCheckBox = new JCheckBox();
        this.hideFilteredCheckBox.setText("");
        this.hideFilteredCheckBox.setVisible(false);
        this.mainPanel.add((Component)this.hideFilteredCheckBox, new GridConstraints(6, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.hideSearchedCheckBox = new JCheckBox();
        this.hideSearchedCheckBox.setText("");
        this.hideSearchedCheckBox.setVisible(false);
        this.mainPanel.add((Component)this.hideSearchedCheckBox, new GridConstraints(7, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.mainPanel.add((Component)spacer1, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.progressiveComboBox = new MJYComboBox();
        this.mainPanel.add((Component)this.progressiveComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JLabel label11 = new JLabel();
        label11.setText("Progressive: ");
        this.mainPanel.add((Component)label11, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        this.depthComboBox = new MJYComboBox();
        this.mainPanel.add((Component)this.depthComboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JLabel label12 = new JLabel();
        label12.setText("Depth:");
        this.mainPanel.add((Component)label12, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel3, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.widthSpinner.setEnabled(false);
        panel3.add((Component)this.widthSpinner, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel3.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.heightSpinner.setEnabled(false);
        panel3.add((Component)this.heightSpinner, new GridConstraints(0, 2, 1, 1, 8, 1, 4, 0, null, null, null, 0, false));
        this.fixedDimensionCheckBox = new JCheckBox();
        this.fixedDimensionCheckBox.setText("Fixed");
        panel3.add((Component)this.fixedDimensionCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JLabel label13 = new JLabel();
        label13.setText("Dimension:");
        this.mainPanel.add((Component)label13, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel4, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        panel4.setBorder(BorderFactory.createTitledBorder(null, "Border", 0, 0, null, null));
        JLabel label14 = new JLabel();
        label14.setText("Color:");
        panel4.add((Component)label14, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label15 = new JLabel();
        label15.setText("Thickness:");
        panel4.add((Component)label15, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        this.borderColorComboBox = new MColorComboBox();
        panel4.add((Component)this.borderColorComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 5, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        panel4.add((Component)this.borderThicknessSpinner, new GridConstraints(1, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        label12.setLabelFor((Component)this.depthComboBox);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private void createUIComponents() {
        this.mainPanel = new MJPanel();
        this.widthSpinner = new MJSpinner();
        this.heightSpinner = new MJSpinner();
        this.borderThicknessSpinner = new MJSpinner();
    }
}

