/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jidesoft.swing.CheckBoxList;
import com.macrofocus.colormap.editor.ColorMapPanel;
import com.macrofocus.colormap.editor.ColorMapPanelModel;
import com.macrofocus.colormap.swing.SwingColorMapPanel;
import com.macrofocus.combobox.MMultiSelectListComboBox;
import com.macrofocus.combobox.MainJYComboBox;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.crossplatform.swing.MJPanel;
import com.macrofocus.crossplatform.swing.MJScrollPane;
import com.macrofocus.docking.DockingPanel;
import com.macrofocus.docking.swing.SwingDockingPanel;
import com.macrofocus.geom.Ellipse2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.hierarchy.Condition;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.selection.swing.SingleSelectionComboBoxModel;
import com.macrofocus.util.swing.FileChooserFactory;
import com.macrofocus.util.swing.print.CopyAction;
import com.macrofocus.util.swing.print.ExportComponentAction;
import com.macrofocus.util.swing.print.PrintComponentAction;
import com.treemap.AlgorithmFactory;
import com.treemap.RenderingFactory;
import com.treemap.TreeMapColorMapPanelModel;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.app.swing.action.ExportColorMapAction;
import com.treemap.app.swing.action.ImportColorMapAction;
import com.treemap.app.swing.configuration.GroupByPanel;
import com.treemap.app.swing.configuration.HeightSettingsPanel;
import com.treemap.app.swing.configuration.LabelSettingsPanel;
import com.treemap.app.swing.configuration.LayoutSettingsPanel;
import com.treemap.app.swing.configuration.RenderingSettingsPanel;
import com.treemap.app.swing.configuration.SizeSettingsPanel;
import com.treemap.app.swing.configuration.ToolTipSettingsPanel;
import com.treemap.app.swing.configuration.VariablesCheckBoxListSelectionModel;
import com.treemap.app.swing.presentation.implementation.AttributeCellRenderer;
import com.treemap.app.swing.presentation.implementation.MainCellRenderer;
import com.treemap.app.swing.v4.model.DummyTreeMapVariable;
import com.treemap.swing.VariablesComboBoxModel;
import com.treemap.swing.legend.TextualLegend;
import de.javasoft.taskpane.JYTaskPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.OverlayLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jdesktop.swingx.JXCollapsiblePane;

public class SwingConfigurationPanel {
    private final AlgorithmFactory algorithmFactory;
    private TreeMapModel treeMapModel;
    private JPanel panel;
    private JPanel searchPanel;
    private JPanel settingsPanel;
    private MMultiSelectListComboBox labelSettingsComboBox;
    private MainJYComboBox sizeSettingsComboBox;
    private MainJYComboBox colorSettingsComboBox;
    private JCheckBox hideKeywordOnOffCheckBox;
    private JCheckBox hideFilterOnOffCheckbox;
    private JPanel logoPanel;
    private JLabel colorSettingsLabel;
    private JLabel sizeSettingsLabel;
    private JLabel nameSettingsLabel;
    private JPanel scrollPanel;
    private JLabel groupBySettingsLabel;
    private JPanel groupBySettinsPanel;
    private JTabbedPane tabbedPane;
    private JLabel backgroundSettingsLabel;
    private MainJYComboBox backgroundSettingsComboBox;
    private JLabel heightSettingsLabel;
    private MainJYComboBox heightSettingsComboBox;
    private JButton colorExpandButton;
    private JXCollapsiblePane colorPane;
    private JPanel legendContainer;
    private JButton heightExpandButton;
    private JButton sizeExpandButton;
    private JXCollapsiblePane heightPane;
    private JXCollapsiblePane sizePane;
    private JPanel sizeGroupPanel;
    private JPanel backgroundPanel;
    private JPanel colorGroupPanel;
    private JPanel groupByGroupPanel;
    private JPanel heightGroupPanel;
    private JPanel labelsGroupPanel;
    private CheckBoxList labelsCheckBoxList;
    private JButton labelsExpandButton;
    private JXCollapsiblePane labelsPane;
    private JButton layoutExpandButton;
    private JXCollapsiblePane layoutPane;
    private MainJYComboBox layoutSettingsComboBox;
    private JPanel layoutGroupPanel;
    private MainJYComboBox renderingSettingsComboBox;
    private JButton renderingExpandButton;
    private JXCollapsiblePane renderingPane;
    private JPanel renderingGroupPanel;
    private JSeparator backgroundSeparator;
    private CheckBoxList toolTipCheckBoxList;
    private JLabel toolTipSettingsLabel;
    private JButton toolTipExpandButton;
    private JXCollapsiblePane toolTipPane;
    private JPanel tooltipGroupPanel;
    private JScrollPane scrollPane;
    private JPanel textualLegend;
    private JPanel legend;
    private JLabel layoutSettingsLabel;
    private JLabel renderingSettingsLabel;
    private final GroupByPanel groupByPanel;
    private SwingColorMapPanel<TreeMapField> colorMapPanel;
    final SwingDockingPanel dockingPanel;
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public SwingConfigurationPanel(FileChooserFactory colorMapChooserFactory, AlgorithmFactory algorithmFactory, final PropertiesModel propertiesModel) {
        this.$$$setupUI$$$();
        this.algorithmFactory = algorithmFactory;
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new com.macrofocus.resources.properties.PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    SwingConfigurationPanel.this.updateProperties(propertiesModel);
                }
            });
        }
        this.updateProperties(propertiesModel);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        ImportColorMapAction importColorMapAction = new ImportColorMapAction(this.panel, colorMapChooserFactory, null);
        ExportColorMapAction exportColorMapAction = new ExportColorMapAction(this.panel, colorMapChooserFactory, null);
        Action[] actions = new Action[]{importColorMapAction, exportColorMapAction};
        this.colorMapPanel = new SwingColorMapPanel((JComponent)this.legendContainer, (JComponent)this.legend, actions, false);
        importColorMapAction.setColorMapPanel(this.colorMapPanel);
        exportColorMapAction.setColorMapPanel(this.colorMapPanel);
        this.layoutSettingsComboBox.setStretchToFit(true);
        this.layoutSettingsComboBox.setEditable(false);
        this.layoutSettingsComboBox.setRenderer((ListCellRenderer)new MainCellRenderer());
        this.renderingSettingsComboBox.setStretchToFit(true);
        this.renderingSettingsComboBox.setEditable(false);
        this.renderingSettingsComboBox.setRenderer((ListCellRenderer)new MainCellRenderer());
        this.renderingSettingsComboBox.setPopupResizable(false);
        this.labelSettingsComboBox.setPrototypeDisplayValue((Object)new DummyTreeMapVariable());
        this.labelSettingsComboBox.setEditable(false);
        this.labelSettingsComboBox.setPopupType(0);
        this.labelSettingsComboBox.setStretchToFit(true);
        this.labelSettingsComboBox.setUpdateOnChange(true);
        this.labelSettingsComboBox.setRenderer((ListCellRenderer)((Object)new AttributeCellRenderer()));
        this.labelsCheckBoxList.setPrototypeCellValue((Object)new DummyTreeMapVariable());
        this.labelsCheckBoxList.setCellRenderer((ListCellRenderer)((Object)new AttributeCellRenderer()));
        this.toolTipCheckBoxList.setPrototypeCellValue((Object)new DummyTreeMapVariable());
        this.toolTipCheckBoxList.setCellRenderer((ListCellRenderer)((Object)new AttributeCellRenderer()));
        this.backgroundSettingsComboBox.setRenderer((ListCellRenderer)((Object)new AttributeCellRenderer()));
        this.backgroundSettingsComboBox.setStretchToFit(true);
        this.backgroundSettingsComboBox.setEditable(false);
        this.sizeSettingsComboBox.setRenderer((ListCellRenderer)((Object)new AttributeCellRenderer()));
        this.sizeSettingsComboBox.setStretchToFit(true);
        this.sizeSettingsComboBox.setEditable(false);
        this.heightSettingsComboBox.setRenderer((ListCellRenderer)((Object)new AttributeCellRenderer()));
        this.heightSettingsComboBox.setStretchToFit(true);
        this.heightSettingsComboBox.setEditable(false);
        this.colorSettingsComboBox.setRenderer((ListCellRenderer)((Object)new AttributeCellRenderer()));
        this.colorSettingsComboBox.setStretchToFit(true);
        this.colorSettingsComboBox.setEditable(false);
        this.labelSettingsComboBox.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] objects = SwingConfigurationPanel.this.labelSettingsComboBox.getSelectedObjects();
                if (objects.length > 0) {
                    ArrayList<TreeMapField> variables = new ArrayList<TreeMapField>();
                    for (Object object : objects) {
                        if (object instanceof Object[]) {
                            for (Object o2 : (Object[])object) {
                                variables.add((TreeMapField)o2);
                            }
                            continue;
                        }
                        variables.add((TreeMapField)object);
                    }
                    SwingConfigurationPanel.this.treeMapModel.getSettings().getLabelVariablesSelection().setSelectedIterable(variables);
                } else {
                    SwingConfigurationPanel.this.treeMapModel.getSettings().getLabelVariablesSelection().clearSelection();
                }
            }
        }, (Object)this.labelSettingsComboBox));
        this.backgroundSettingsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TreeMapField variable = (TreeMapField)SwingConfigurationPanel.this.backgroundSettingsComboBox.getSelectedItem();
                SwingConfigurationPanel.this.treeMapModel.getSettings().getBackgroundVariableSelection().setSelected((Object)variable);
            }
        });
        this.sizeSettingsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TreeMapField variable = (TreeMapField)SwingConfigurationPanel.this.sizeSettingsComboBox.getSelectedItem();
                SwingConfigurationPanel.this.treeMapModel.getSettings().getSizeVariableSelection().setSelected((Object)variable);
            }
        });
        this.heightSettingsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TreeMapField variable = (TreeMapField)SwingConfigurationPanel.this.heightSettingsComboBox.getSelectedItem();
                SwingConfigurationPanel.this.treeMapModel.getSettings().getHeightVariableSelection().setSelected((Object)variable);
            }
        });
        this.colorSettingsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TreeMapField variable = (TreeMapField)SwingConfigurationPanel.this.colorSettingsComboBox.getSelectedItem();
                SwingConfigurationPanel.this.treeMapModel.getSettings().getColorVariableSelection().setSelected((Object)variable);
            }
        });
        this.groupBySettinsPanel.setLayout(new OverlayLayout(this.groupBySettinsPanel));
        this.groupByPanel = new GroupByPanel(algorithmFactory);
        this.groupBySettinsPanel.add((Component)((Object)this.groupByPanel));
        this.configureExpandButton(this.layoutExpandButton, this.layoutPane);
        this.configureExpandButton(this.renderingExpandButton, this.renderingPane);
        this.configureExpandButton(this.labelsExpandButton, this.labelsPane);
        this.configureExpandButton(this.toolTipExpandButton, this.toolTipPane);
        this.configureExpandButton(this.sizeExpandButton, this.sizePane);
        this.configureExpandButton(this.heightExpandButton, this.heightPane);
        this.configureExpandButton(this.colorExpandButton, this.colorPane);
        this.dockingPanel = new SwingDockingPanel();
        this.dockingPanel.setInnerComponent((JComponent)this.panel);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add((Action)new CopyAction("Copy Graphics", (Component)this.legend));
        try {
            popupMenu.add((Action)new ExportComponentAction("Export Graphics...", (JComponent)this.legend, false));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        popupMenu.add((Action)new PrintComponentAction("Print...", (Component)this.legend));
        this.legend.setComponentPopupMenu(popupMenu);
    }

    public void setModel(final TreeMapModel treeMapModel) {
        this.treeMapModel = treeMapModel;
        VariablesComboBoxModel labelModel = new VariablesComboBoxModel(treeMapModel, treeMapModel.getSettings().getLabelVariablesSelection(), true, (Condition)new Condition<TreeMapField>(){

            public boolean accept(TreeMapField node) {
                return !treeMapModel.isVisualType(node);
            }
        });
        VariablesComboBoxModel labelListModel = new VariablesComboBoxModel(treeMapModel, treeMapModel.getSettings().getLabelVariablesSelection(), false, (Condition)new Condition<TreeMapField>(){

            public boolean accept(TreeMapField node) {
                return !treeMapModel.isVisualType(node);
            }
        });
        VariablesCheckBoxListSelectionModel labelCheckBoxListSelectionModel = new VariablesCheckBoxListSelectionModel((ListModel)labelListModel, treeMapModel.getSettings().getLabelVariablesSelection());
        VariablesComboBoxModel toolTipListModel = new VariablesComboBoxModel(treeMapModel, treeMapModel.getSettings().getTooltipVariablesSelection(), false, (Condition)new Condition<TreeMapField>(){

            public boolean accept(TreeMapField node) {
                return !treeMapModel.isVisualType(node);
            }
        });
        VariablesCheckBoxListSelectionModel toolTipCheckBoxListSelectionModel = new VariablesCheckBoxListSelectionModel((ListModel)toolTipListModel, treeMapModel.getSettings().getTooltipVariablesSelection());
        VariablesComboBoxModel backgroundModel = new VariablesComboBoxModel(treeMapModel, treeMapModel.getSettings().getBackgroundVariableSelection(), true, (Condition)new Condition<TreeMapField>(){

            public boolean accept(TreeMapField node) {
                Class type = node.getType();
                return !type.isArray() && (BufferedImage.class.isAssignableFrom(type) || Icon.class.isAssignableFrom(type));
            }
        });
        VariablesComboBoxModel sizeModel = new VariablesComboBoxModel(treeMapModel, treeMapModel.getSettings().getSizeVariableSelection(), true, (Condition)new Condition<TreeMapField>(){

            public boolean accept(TreeMapField node) {
                return treeMapModel.isNumericType(node) || treeMapModel.isTemporalType(node);
            }
        });
        VariablesComboBoxModel heightModel = new VariablesComboBoxModel(treeMapModel, treeMapModel.getSettings().getHeightVariableSelection(), true, (Condition)new Condition<TreeMapField>(){

            public boolean accept(TreeMapField node) {
                return treeMapModel.isNumericType(node) || treeMapModel.isTemporalType(node);
            }
        });
        VariablesComboBoxModel colorModel = new VariablesComboBoxModel(treeMapModel, treeMapModel.getSettings().getColorVariableSelection(), true, (Condition)new Condition<TreeMapField>(){

            public boolean accept(TreeMapField node) {
                return !node.getType().isArray();
            }
        });
        this.layoutSettingsComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(treeMapModel.getSettings().getDefaultFieldSettings().getAlgorithmProperty(), (Iterable)this.algorithmFactory.getAlgorithms()));
        this.renderingSettingsComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(treeMapModel.getSettings().getRenderingSelection(), (Iterable)RenderingFactory.getInstance().getRenderings()));
        this.labelSettingsComboBox.setModel((ComboBoxModel)labelModel);
        this.labelsCheckBoxList.setModel((ListModel)labelListModel);
        this.labelsCheckBoxList.setCheckBoxListSelectionModel(labelCheckBoxListSelectionModel);
        this.toolTipCheckBoxList.setModel((ListModel)toolTipListModel);
        this.toolTipCheckBoxList.setCheckBoxListSelectionModel(toolTipCheckBoxListSelectionModel);
        this.backgroundSettingsComboBox.setModel((ComboBoxModel)backgroundModel);
        this.sizeSettingsComboBox.setModel((ComboBoxModel)sizeModel);
        this.heightSettingsComboBox.setModel((ComboBoxModel)heightModel);
        this.colorSettingsComboBox.setModel((ComboBoxModel)colorModel);
        this.backgroundPanel.setVisible(false);
        this.backgroundSeparator.setVisible(false);
        for (int i = 0; i < treeMapModel.getColumnCount(); ++i) {
            Class columnClass = treeMapModel.getColumnClass(treeMapModel.getDataFrame().getColumnKey(i));
            if (!BufferedImage.class.isAssignableFrom(columnClass) && !Icon.class.isAssignableFrom(columnClass)) continue;
            this.backgroundPanel.setVisible(true);
            this.backgroundSeparator.setVisible(true);
        }
        this.layoutPane.setLayout((LayoutManager)new BorderLayout());
        this.layoutPane.add((Component)new LayoutSettingsPanel(treeMapModel).getMainPanel());
        this.renderingPane.setLayout((LayoutManager)new BorderLayout());
        this.renderingPane.add((Component)new RenderingSettingsPanel(treeMapModel).getMainPanel());
        this.groupByPanel.setModel(treeMapModel);
        if (this.backgroundSettingsComboBox.getModel().getSize() <= 1) {
            this.backgroundSettingsLabel.setVisible(false);
            this.backgroundSettingsComboBox.setVisible(false);
        }
        this.labelsPane.setLayout((LayoutManager)new BorderLayout());
        final LabelSettingsPanel labelSettingsPanel = new LabelSettingsPanel(treeMapModel);
        this.labelsCheckBoxList.setSelectionMode(0);
        this.labelsCheckBoxList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object v = SwingConfigurationPanel.this.labelsCheckBoxList.getSelectedValue();
                labelSettingsPanel.setField((TreeMapField)v);
            }
        });
        this.labelsPane.add((Component)labelSettingsPanel.getMainPanel());
        this.toolTipPane.setLayout((LayoutManager)new BorderLayout());
        final ToolTipSettingsPanel toolTipSettingsPanel = new ToolTipSettingsPanel(treeMapModel);
        this.toolTipCheckBoxList.setSelectionMode(0);
        this.toolTipCheckBoxList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object v = SwingConfigurationPanel.this.toolTipCheckBoxList.getSelectedValue();
                toolTipSettingsPanel.setField((TreeMapField)v);
            }
        });
        this.toolTipPane.add((Component)toolTipSettingsPanel.getMainPanel());
        this.sizePane.setLayout((LayoutManager)new BorderLayout());
        this.sizePane.add((Component)new SizeSettingsPanel(treeMapModel).getMainPanel());
        this.heightPane.setLayout((LayoutManager)new BorderLayout());
        this.heightPane.add((Component)new HeightSettingsPanel(treeMapModel).getMainPanel());
        this.colorMapPanel.setModel((ColorMapPanelModel)new TreeMapColorMapPanelModel(treeMapModel));
        this.colorPane.setLayout((LayoutManager)new BorderLayout());
        this.colorMapPanel.getNativeComponent().setBorder(new TitledBorder(""));
        this.colorPane.add((Component)this.colorMapPanel.getNativeComponent());
        this.colorPane.validate();
        ((TextualLegend)this.textualLegend).setModel(treeMapModel);
        PropertiesListener propertyChangeListener = new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                if ("algorithm".equals(name) || "groupByField".equals(name)) {
                    SwingConfigurationPanel.this.updateHeight((TreeMapFieldSettings<Color, Font>)treeMapModel.getSettings().getDefaultFieldSettings());
                }
            }
        };
        treeMapModel.getSettings().getDefaultFieldSettings().getProperties().addPropertiesListener(propertyChangeListener);
        treeMapModel.getSettings().getProperties().addPropertiesListener(propertyChangeListener);
        this.updateHeight((TreeMapFieldSettings<Color, Font>)treeMapModel.getSettings().getDefaultFieldSettings());
    }

    private void updateHeight(TreeMapFieldSettings<Color, Font> settings) {
        boolean enabled = settings.getAlgorithm() != null && !settings.getAlgorithm().isCompatible((Shape)new Ellipse2D.Double(0.0, 0.0, 0.0, 0.0));
        this.heightSettingsLabel.setEnabled(enabled);
        this.heightSettingsComboBox.setEnabled(enabled);
        this.heightPane.setEnabled(enabled);
    }

    public SwingDockingPanel getMainPanel() {
        return this.dockingPanel;
    }

    private JButton createExpandButton() {
        JYTaskPane taskPane = new JYTaskPane();
        taskPane.setCollapsed(true);
        Container child = (Container)taskPane.getComponent(0);
        JButton button = (JButton)child.getComponent(2);
        return button;
    }

    private void configureExpandButton(JButton button, JXCollapsiblePane pane) {
        button.setAction(pane.getActionMap().get("toggle"));
        button.setText(null);
        pane.setCollapsed(true);
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        if (propertiesModel != null) {
            this.layoutSettingsLabel.setText((String)propertiesModel.getValue("control.layout.label"));
            this.groupBySettingsLabel.setText((String)propertiesModel.getValue("control.groupby.label"));
            this.nameSettingsLabel.setText((String)propertiesModel.getValue("control.label.label"));
            this.toolTipSettingsLabel.setText((String)propertiesModel.getValue("control.tooltip.label"));
            this.backgroundSettingsLabel.setText((String)propertiesModel.getValue("control.background.label"));
            this.sizeSettingsLabel.setText((String)propertiesModel.getValue("control.size.label"));
            this.heightSettingsLabel.setText((String)propertiesModel.getValue("control.height.label"));
            this.colorSettingsLabel.setText((String)propertiesModel.getValue("control.color.label"));
            this.renderingSettingsLabel.setText((String)propertiesModel.getValue("control.rendering.label"));
        }
    }

    private void createUIComponents() {
        this.panel = new MJPanel();
        this.scrollPane = new MJScrollPane();
        this.layoutSettingsComboBox = new MainJYComboBox();
        this.renderingSettingsComboBox = new MainJYComboBox();
        this.labelSettingsComboBox = new MMultiSelectListComboBox();
        this.sizeSettingsComboBox = new MainJYComboBox();
        this.colorSettingsComboBox = new MainJYComboBox();
        this.backgroundSettingsComboBox = new MainJYComboBox();
        this.heightSettingsComboBox = new MainJYComboBox();
        this.tabbedPane = new JTabbedPane();
        this.layoutExpandButton = this.createExpandButton();
        this.renderingExpandButton = this.createExpandButton();
        this.labelsExpandButton = this.createExpandButton();
        this.toolTipExpandButton = this.createExpandButton();
        this.sizeExpandButton = this.createExpandButton();
        this.heightExpandButton = this.createExpandButton();
        this.colorExpandButton = this.createExpandButton();
        this.sizeGroupPanel = new GroupPanel();
        this.backgroundPanel = new GroupPanel();
        this.colorGroupPanel = new GroupPanel();
        this.groupByGroupPanel = new GroupPanel();
        this.heightGroupPanel = new GroupPanel();
        this.labelsGroupPanel = new GroupPanel();
        this.layoutGroupPanel = new GroupPanel();
        this.renderingGroupPanel = new GroupPanel();
        this.tooltipGroupPanel = new GroupPanel();
        this.textualLegend = new TextualLegend(true);
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setOpaque(true);
        this.panel.add((Component)this.scrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 5, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.settingsPanel = new JPanel();
        this.settingsPanel.setLayout((LayoutManager)new GridLayoutManager(19, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.scrollPane.setViewportView(this.settingsPanel);
        Spacer spacer1 = new Spacer();
        this.settingsPanel.add((Component)spacer1, new GridConstraints(18, 2, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.groupByGroupPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.settingsPanel.add((Component)this.groupByGroupPanel, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, true));
        this.groupBySettingsLabel = new JLabel();
        Font groupBySettingsLabelFont = this.$$$getFont$$$(null, 1, -1, this.groupBySettingsLabel.getFont());
        if (groupBySettingsLabelFont != null) {
            this.groupBySettingsLabel.setFont(groupBySettingsLabelFont);
        }
        this.groupBySettingsLabel.setHorizontalAlignment(2);
        this.groupBySettingsLabel.setHorizontalTextPosition(2);
        this.groupBySettingsLabel.setText("Gruppieren nach:");
        this.groupByGroupPanel.add((Component)this.groupBySettingsLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null, 0, false));
        this.groupBySettinsPanel = new JPanel();
        this.groupBySettinsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.groupByGroupPanel.add((Component)this.groupBySettinsPanel, new GridConstraints(0, 1, 1, 2, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.labelsGroupPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.settingsPanel.add((Component)this.labelsGroupPanel, new GridConstraints(10, 0, 1, 3, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, true));
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setHorizontalScrollBarPolicy(30);
        this.labelsGroupPanel.add((Component)scrollPane1, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.labelsCheckBoxList = new CheckBoxList();
        this.labelsCheckBoxList.setVisibleRowCount(4);
        scrollPane1.setViewportView((Component)this.labelsCheckBoxList);
        this.labelsPane = new JXCollapsiblePane();
        this.labelsPane.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.labelsGroupPanel.add((Component)this.labelsPane, new GridConstraints(1, 1, 1, 2, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, true));
        this.labelsExpandButton.setMargin(new Insets(0, 2, 0, 5));
        this.labelsExpandButton.setText("+");
        this.labelsGroupPanel.add((Component)this.labelsExpandButton, new GridConstraints(0, 1, 1, 1, 9, 0, 0, 0, null, null, null, 0, false));
        this.nameSettingsLabel = new JLabel();
        Font nameSettingsLabelFont = this.$$$getFont$$$(null, 1, -1, this.nameSettingsLabel.getFont());
        if (nameSettingsLabelFont != null) {
            this.nameSettingsLabel.setFont(nameSettingsLabelFont);
        }
        this.nameSettingsLabel.setHorizontalAlignment(2);
        this.nameSettingsLabel.setHorizontalTextPosition(2);
        this.nameSettingsLabel.setText("Die Beschriftung zeigt:");
        this.labelsGroupPanel.add((Component)this.nameSettingsLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null, 0, false));
        this.backgroundPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.settingsPanel.add((Component)this.backgroundPanel, new GridConstraints(16, 0, 1, 3, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, true));
        this.backgroundPanel.add((Component)this.backgroundSettingsComboBox, new GridConstraints(0, 2, 1, 1, 0, 1, 5, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.backgroundSettingsLabel = new JLabel();
        Font backgroundSettingsLabelFont = this.$$$getFont$$$(null, 1, -1, this.backgroundSettingsLabel.getFont());
        if (backgroundSettingsLabelFont != null) {
            this.backgroundSettingsLabel.setFont(backgroundSettingsLabelFont);
        }
        this.backgroundSettingsLabel.setHorizontalAlignment(2);
        this.backgroundSettingsLabel.setHorizontalTextPosition(2);
        this.backgroundSettingsLabel.setText("Der Hintergrund zeigt:");
        this.backgroundSettingsLabel.setVisible(true);
        this.backgroundPanel.add((Component)this.backgroundSettingsLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JSeparator separator1 = new JSeparator();
        this.settingsPanel.add((Component)separator1, new GridConstraints(11, 0, 1, 3, 0, 3, 2, 0, null, null, null, 1, false));
        JSeparator separator2 = new JSeparator();
        this.settingsPanel.add((Component)separator2, new GridConstraints(3, 0, 1, 3, 0, 3, 2, 0, null, null, null, 1, false));
        this.backgroundSeparator = new JSeparator();
        this.backgroundSeparator.setVisible(false);
        this.settingsPanel.add((Component)this.backgroundSeparator, new GridConstraints(17, 0, 1, 3, 0, 3, 4, 0, null, null, null, 1, false));
        this.layoutGroupPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.settingsPanel.add((Component)this.layoutGroupPanel, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, true));
        this.layoutGroupPanel.add((Component)this.layoutSettingsComboBox, new GridConstraints(0, 2, 1, 1, 0, 1, 5, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.layoutPane = new JXCollapsiblePane();
        this.layoutPane.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.layoutGroupPanel.add((Component)this.layoutPane, new GridConstraints(1, 1, 1, 2, 0, 1, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.layoutSettingsLabel = new JLabel();
        Font layoutSettingsLabelFont = this.$$$getFont$$$(null, 1, -1, this.layoutSettingsLabel.getFont());
        if (layoutSettingsLabelFont != null) {
            this.layoutSettingsLabel.setFont(layoutSettingsLabelFont);
        }
        this.layoutSettingsLabel.setHorizontalAlignment(2);
        this.layoutSettingsLabel.setHorizontalTextPosition(2);
        this.layoutSettingsLabel.setText("Layout:");
        this.layoutGroupPanel.add((Component)this.layoutSettingsLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.layoutExpandButton.setMargin(new Insets(0, 2, 0, 5));
        this.layoutExpandButton.setText("+");
        this.layoutGroupPanel.add((Component)this.layoutExpandButton, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JSeparator separator3 = new JSeparator();
        this.settingsPanel.add((Component)separator3, new GridConstraints(1, 0, 1, 3, 0, 3, 4, 0, null, null, null, 1, false));
        JSeparator separator4 = new JSeparator();
        this.settingsPanel.add((Component)separator4, new GridConstraints(9, 0, 1, 3, 0, 3, 4, 0, null, null, null, 1, false));
        this.tooltipGroupPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.settingsPanel.add((Component)this.tooltipGroupPanel, new GridConstraints(12, 0, 1, 3, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, true));
        JScrollPane scrollPane2 = new JScrollPane();
        scrollPane2.setHorizontalScrollBarPolicy(30);
        this.tooltipGroupPanel.add((Component)scrollPane2, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.toolTipCheckBoxList = new CheckBoxList();
        this.toolTipCheckBoxList.setVisibleRowCount(4);
        scrollPane2.setViewportView((Component)this.toolTipCheckBoxList);
        this.toolTipPane = new JXCollapsiblePane();
        this.toolTipPane.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.tooltipGroupPanel.add((Component)this.toolTipPane, new GridConstraints(1, 1, 1, 2, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, true));
        this.toolTipExpandButton.setMargin(new Insets(0, 2, 0, 5));
        this.toolTipExpandButton.setText("+");
        this.tooltipGroupPanel.add((Component)this.toolTipExpandButton, new GridConstraints(0, 1, 1, 1, 9, 0, 0, 0, null, null, null, 0, false));
        this.toolTipSettingsLabel = new JLabel();
        Font toolTipSettingsLabelFont = this.$$$getFont$$$(null, 1, -1, this.toolTipSettingsLabel.getFont());
        if (toolTipSettingsLabelFont != null) {
            this.toolTipSettingsLabel.setFont(toolTipSettingsLabelFont);
        }
        this.toolTipSettingsLabel.setHorizontalAlignment(2);
        this.toolTipSettingsLabel.setHorizontalTextPosition(2);
        this.toolTipSettingsLabel.setText("Die Tooltip zeigt:");
        this.tooltipGroupPanel.add((Component)this.toolTipSettingsLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null, 0, false));
        JSeparator separator5 = new JSeparator();
        this.settingsPanel.add((Component)separator5, new GridConstraints(15, 0, 1, 3, 0, 3, 2, 0, null, null, null, 1, false));
        this.sizeGroupPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.settingsPanel.add((Component)this.sizeGroupPanel, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, true));
        this.sizeGroupPanel.add((Component)this.sizeSettingsComboBox, new GridConstraints(0, 2, 1, 1, 0, 1, 5, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.sizePane = new JXCollapsiblePane();
        this.sizePane.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.sizeGroupPanel.add((Component)this.sizePane, new GridConstraints(1, 1, 1, 2, 0, 1, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.sizeExpandButton.setMargin(new Insets(0, 2, 0, 5));
        this.sizeExpandButton.setText("+");
        this.sizeGroupPanel.add((Component)this.sizeExpandButton, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.sizeSettingsLabel = new JLabel();
        Font sizeSettingsLabelFont = this.$$$getFont$$$(null, 1, -1, this.sizeSettingsLabel.getFont());
        if (sizeSettingsLabelFont != null) {
            this.sizeSettingsLabel.setFont(sizeSettingsLabelFont);
        }
        this.sizeSettingsLabel.setHorizontalAlignment(2);
        this.sizeSettingsLabel.setHorizontalTextPosition(2);
        this.sizeSettingsLabel.setText("Die Gr\u00f6sse stellt dar:");
        this.sizeGroupPanel.add((Component)this.sizeSettingsLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.colorGroupPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.settingsPanel.add((Component)this.colorGroupPanel, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, true));
        this.colorGroupPanel.add((Component)this.colorSettingsComboBox, new GridConstraints(0, 2, 1, 1, 0, 1, 5, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.colorPane = new JXCollapsiblePane();
        this.colorPane.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.colorGroupPanel.add((Component)this.colorPane, new GridConstraints(1, 1, 1, 2, 0, 1, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.colorExpandButton.setMargin(new Insets(0, 2, 0, 5));
        this.colorExpandButton.setText("+");
        this.colorGroupPanel.add((Component)this.colorExpandButton, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.colorSettingsLabel = new JLabel();
        Font colorSettingsLabelFont = this.$$$getFont$$$(null, 1, -1, this.colorSettingsLabel.getFont());
        if (colorSettingsLabelFont != null) {
            this.colorSettingsLabel.setFont(colorSettingsLabelFont);
        }
        this.colorSettingsLabel.setHorizontalAlignment(2);
        this.colorSettingsLabel.setHorizontalTextPosition(2);
        this.colorSettingsLabel.setText("Die Farbe stellt dar:");
        this.colorGroupPanel.add((Component)this.colorSettingsLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.heightGroupPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.settingsPanel.add((Component)this.heightGroupPanel, new GridConstraints(8, 0, 1, 3, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, true));
        this.heightGroupPanel.add((Component)this.heightSettingsComboBox, new GridConstraints(0, 2, 1, 1, 0, 1, 5, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.heightPane = new JXCollapsiblePane();
        this.heightPane.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.heightGroupPanel.add((Component)this.heightPane, new GridConstraints(1, 1, 1, 2, 0, 1, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.heightExpandButton.setMargin(new Insets(0, 2, 0, 5));
        this.heightExpandButton.setText("+");
        this.heightGroupPanel.add((Component)this.heightExpandButton, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.heightSettingsLabel = new JLabel();
        Font heightSettingsLabelFont = this.$$$getFont$$$(null, 1, -1, this.heightSettingsLabel.getFont());
        if (heightSettingsLabelFont != null) {
            this.heightSettingsLabel.setFont(heightSettingsLabelFont);
        }
        this.heightSettingsLabel.setHorizontalAlignment(2);
        this.heightSettingsLabel.setHorizontalTextPosition(2);
        this.heightSettingsLabel.setText("Die H\u00f6he stellt dar:");
        this.heightGroupPanel.add((Component)this.heightSettingsLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.renderingGroupPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.settingsPanel.add((Component)this.renderingGroupPanel, new GridConstraints(14, 0, 1, 3, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, true));
        this.renderingGroupPanel.add((Component)this.renderingSettingsComboBox, new GridConstraints(0, 2, 1, 1, 0, 1, 5, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.renderingPane = new JXCollapsiblePane();
        this.renderingPane.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.renderingGroupPanel.add((Component)this.renderingPane, new GridConstraints(1, 1, 1, 2, 0, 1, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.renderingExpandButton.setMargin(new Insets(0, 2, 0, 5));
        this.renderingExpandButton.setText("+");
        this.renderingGroupPanel.add((Component)this.renderingExpandButton, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.renderingSettingsLabel = new JLabel();
        Font renderingSettingsLabelFont = this.$$$getFont$$$(null, 1, -1, this.renderingSettingsLabel.getFont());
        if (renderingSettingsLabelFont != null) {
            this.renderingSettingsLabel.setFont(renderingSettingsLabelFont);
        }
        this.renderingSettingsLabel.setHorizontalAlignment(2);
        this.renderingSettingsLabel.setHorizontalTextPosition(2);
        this.renderingSettingsLabel.setText("Rendering:");
        this.renderingGroupPanel.add((Component)this.renderingSettingsLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JSeparator separator6 = new JSeparator();
        this.settingsPanel.add((Component)separator6, new GridConstraints(13, 0, 1, 3, 0, 3, 4, 0, null, null, null, 1, false));
        JSeparator separator7 = new JSeparator();
        this.settingsPanel.add((Component)separator7, new GridConstraints(7, 0, 1, 3, 0, 3, 4, 0, null, null, null, 1, false));
        JSeparator separator8 = new JSeparator();
        this.settingsPanel.add((Component)separator8, new GridConstraints(5, 0, 1, 3, 0, 3, 4, 0, null, null, null, 1, false));
        this.legend = new JPanel();
        this.legend.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.panel.add((Component)this.legend, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        this.legend.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4), null, 0, 0, null, null));
        this.legend.add((Component)this.textualLegend, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, new Dimension(0, -1), null, null, 0, false));
        this.legendContainer = new JPanel();
        this.legendContainer.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.legend.add((Component)this.legendContainer, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.backgroundSettingsLabel.setLabelFor((Component)this.backgroundSettingsComboBox);
        this.layoutSettingsLabel.setLabelFor((Component)this.layoutSettingsComboBox);
        this.sizeSettingsLabel.setLabelFor((Component)this.sizeSettingsComboBox);
        this.colorSettingsLabel.setLabelFor((Component)this.colorSettingsComboBox);
        this.heightSettingsLabel.setLabelFor((Component)this.heightSettingsComboBox);
        this.renderingSettingsLabel.setLabelFor((Component)this.renderingSettingsComboBox);
    }

    private Font $$$getFont$$$(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    public DockingPanel getDockingPanel() {
        return this.dockingPanel;
    }

    public JPanel getSizeGroupPanel() {
        return this.sizeGroupPanel;
    }

    public JPanel getBackgroundPanel() {
        return this.backgroundPanel;
    }

    public JPanel getColorGroupPanel() {
        return this.colorGroupPanel;
    }

    public JPanel getGroupByGroupPanel() {
        return this.groupByGroupPanel;
    }

    public JPanel getHeightGroupPanel() {
        return this.heightGroupPanel;
    }

    public JPanel getLabelsGroupPanel() {
        return this.labelsGroupPanel;
    }

    public JPanel getTooltipGroupPanel() {
        return this.tooltipGroupPanel;
    }

    public JPanel getLayoutGroupPanel() {
        return this.layoutGroupPanel;
    }

    public JPanel getRenderingGroupPanel() {
        return this.renderingGroupPanel;
    }

    public JButton getHeightExpandButton() {
        return this.heightExpandButton;
    }

    public JButton getColorExpandButton() {
        return this.colorExpandButton;
    }

    public JButton getToolTipExpandButton() {
        return this.toolTipExpandButton;
    }

    public JButton getRenderingExpandButton() {
        return this.renderingExpandButton;
    }

    public JButton getLayoutExpandButton() {
        return this.layoutExpandButton;
    }

    public JButton getLabelsExpandButton() {
        return this.labelsExpandButton;
    }

    public JButton getSizeExpandButton() {
        return this.sizeExpandButton;
    }

    public void setAnimated(boolean animated) {
        this.layoutPane.setAnimated(animated);
        this.sizePane.setAnimated(animated);
        this.colorPane.setAnimated(animated);
        this.heightPane.setAnimated(animated);
        this.labelsPane.setAnimated(animated);
        this.toolTipPane.setAnimated(animated);
        this.renderingPane.setAnimated(animated);
    }

    public GroupByPanel getGroupByPanel() {
        return this.groupByPanel;
    }

    public ColorMapPanel<TreeMapField, JComponent, Color> getColorMapPanel() {
        return this.colorMapPanel;
    }

    public JPanel getLegend() {
        return this.legend;
    }

    private class GroupPanel
    extends MJPanel {
        private GroupPanel() {
            this.setBorder(new EmptyBorder(5, 0, 5, 0));
        }
    }
}

