/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jidesoft.filter.Filter;
import com.jidesoft.grid.QuickFilterField;
import com.macrofocus.crossplatform.swing.MJPanel;
import com.macrofocus.crossplatform.swing.MJScrollPane;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.Predicate;
import com.treemap.app.swing.configuration.InnerFiltersPanel;
import com.treemap.app.swing.v4.model.MTreeMapModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SwingFiltersPanel {
    private MTreeMapModel model;
    private InnerFiltersPanel innerFiltersPanel;
    private JPanel mainPanel;
    private JPanel searchPanel;
    private JPanel filtersPanel;
    private JPanel optionsPanel;
    private JCheckBox hideKeywordOnOffCheckBox;
    private JCheckBox hideFilterOnOffCheckBox;
    private QuickFilterField quickFilterField;
    private JScrollPane filtersScrollPane;
    private JButton resetButton;

    public SwingFiltersPanel(ResourcesModel resourcesModel) {
        this.$$$setupUI$$$();
        final PropertiesModel propertiesModel = resourcesModel.getPropertiesModel();
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    SwingFiltersPanel.this.updateProperties(propertiesModel);
                }
            });
        }
        this.updateProperties(propertiesModel);
        this.innerFiltersPanel = new InnerFiltersPanel();
        this.filtersScrollPane.setViewportView((Component)((Object)this.innerFiltersPanel));
        this.filtersScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.hideKeywordOnOffCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SwingFiltersPanel.this.model.getSettings().getHideSearchResultsSelection().setValue((Object)SwingFiltersPanel.this.hideKeywordOnOffCheckBox.isSelected());
            }
        });
        this.hideFilterOnOffCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SwingFiltersPanel.this.model.getSettings().getHideFilterResultsSelection().setValue((Object)SwingFiltersPanel.this.hideFilterOnOffCheckBox.isSelected());
            }
        });
        this.resetButton.setAction(new ResetAction());
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public <N, Row, Column> void setModel(MTreeMapModel<N, Row, Column> model) {
        this.model = model;
        this.hideKeywordOnOffCheckBox.setSelected((Boolean)model.getSettings().getHideSearchResultsSelection().getValue());
        this.hideFilterOnOffCheckBox.setSelected((Boolean)model.getSettings().getHideFilterResultsSelection().getValue());
        this.innerFiltersPanel.setModel(model);
    }

    public void applyFilters() {
        this.innerFiltersPanel.applyFilters();
    }

    public void setFilterVisible(int column, boolean value) {
        this.innerFiltersPanel.setFilterVisible(column, value);
    }

    public void setCategoricalFilter(int column, String[] values) {
        this.innerFiltersPanel.setCategoricalFilter(column, values);
    }

    public void setNumericalFilter(int column, double min, double max) {
        this.innerFiltersPanel.setNumericalFilter(column, min, max);
    }

    public void setHideFiltered(boolean hideFiltered) {
        this.hideFilterOnOffCheckBox.setSelected(hideFiltered);
    }

    public void setHideSearched(boolean hideSearched) {
        this.hideKeywordOnOffCheckBox.setSelected(hideSearched);
    }

    public void setSearch(String value) {
        this.quickFilterField.setSearchingText(value);
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        if (propertiesModel != null) {
            this.searchPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), (String)propertiesModel.getValue("control.search.title")));
            this.filtersPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), (String)propertiesModel.getValue("control.filter.title")));
            this.hideKeywordOnOffCheckBox.setText((String)propertiesModel.getValue("control.search.hide.label"));
            this.hideFilterOnOffCheckBox.setText((String)propertiesModel.getValue("control.filter.hide.label"));
            this.hideKeywordOnOffCheckBox.setToolTipText((String)propertiesModel.getValue("control.search.hide.label"));
            this.hideFilterOnOffCheckBox.setToolTipText((String)propertiesModel.getValue("control.filter.hide.label"));
        }
    }

    private void createUIComponents() {
        this.mainPanel = new MJPanel();
        this.filtersScrollPane = new MJScrollPane();
        this.quickFilterField = new QuickFilterField(){

            public void applyFilter(String s) {
                SwingFiltersPanel.this.model.setSearch(new Predicate(){

                    public boolean test(Object value) {
                        Filter filter = SwingFiltersPanel.this.quickFilterField.getFilter();
                        if (filter != null) {
                            return !filter.isValueFiltered(value);
                        }
                        return true;
                    }
                });
            }
        };
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.setMinimumSize(new Dimension(50, 0));
        this.optionsPanel = new JPanel();
        this.optionsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)this.optionsPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.optionsPanel.add((Component)spacer1, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel1, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        this.hideFilterOnOffCheckBox = new JCheckBox();
        this.hideFilterOnOffCheckBox.setFocusable(false);
        this.hideFilterOnOffCheckBox.setText("Durch Suche gefilterte Werte ausblenden");
        this.hideFilterOnOffCheckBox.setVisible(true);
        panel2.add((Component)this.hideFilterOnOffCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, new Dimension(0, -1), null, null, 1, false));
        this.hideKeywordOnOffCheckBox = new JCheckBox();
        this.hideKeywordOnOffCheckBox.setFocusable(false);
        this.hideKeywordOnOffCheckBox.setText("Durch Slider gefilterte Werte ausblenden");
        this.hideKeywordOnOffCheckBox.setVisible(true);
        panel2.add((Component)this.hideKeywordOnOffCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, new Dimension(0, -1), null, null, 1, false));
        this.resetButton = new JButton();
        this.resetButton.setText("Reset");
        panel1.add((Component)this.resetButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.searchPanel = new JPanel();
        this.searchPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)this.searchPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        this.searchPanel.setBorder(BorderFactory.createTitledBorder(null, "Durch Suche gefilterte Werte ausblenden", 0, 0, null, null));
        this.searchPanel.add((Component)this.quickFilterField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.filtersPanel = new JPanel();
        this.filtersPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)this.filtersPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.filtersPanel.setBorder(BorderFactory.createTitledBorder(null, "Mit den Slidern Werte herausfiltern", 0, 0, null, null));
        this.filtersPanel.add((Component)this.filtersScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private class ResetAction
    extends AbstractAction {
        private ResetAction() {
            super("Reset");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingFiltersPanel.this.quickFilterField.setSearchingText(null);
            SwingFiltersPanel.this.innerFiltersPanel.resetFilters();
        }
    }
}

