/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableColumnChooser;
import com.jidesoft.swing.CornerScroller;
import com.jidesoft.swing.JideScrollPane;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.crossplatform.swing.MJPanel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.WrappedDataFrame;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesModel;
import com.treemap.TreeMapModel;
import com.treemap.app.swing.configuration.RowStripeSortableTable;
import com.treemap.app.swing.configuration.VariablesTableModel;
import com.treemap.app.swing.configuration.action.AddVariableAction;
import com.treemap.app.swing.configuration.action.EditVariableAction;
import com.treemap.app.swing.configuration.action.RemoveVariableAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class SwingVariablesPanel {
    private final ResourcesModel resourcesModel;
    private JPanel mainPanel;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private SortableTable sortableTable;
    private JScrollPane scrollPane;

    public SwingVariablesPanel(ResourcesModel resourcesModel) {
        this.resourcesModel = resourcesModel;
        this.$$$setupUI$$$();
        this.sortableTable.setShowHorizontalLines(false);
        this.sortableTable.setColumnResizable(true);
        this.sortableTable.setColumnAutoResizable(true);
        this.sortableTable.setAutoscrolls(true);
        this.sortableTable.setShowGrid(false);
        this.sortableTable.setIntercellSpacing(new Dimension(0, 0));
        AbstractButton tableColumnChooserButton = TableColumnChooser.getTableColumnChooserButton((JTable)this.sortableTable);
        tableColumnChooserButton.setContentAreaFilled(false);
        this.scrollPane.setCorner("UPPER_RIGHT_CORNER", tableColumnChooserButton);
        CornerScroller variablesScroller = new CornerScroller(this.scrollPane);
        this.scrollPane.setCorner("LOWER_RIGHT_CORNER", (Component)variablesScroller);
        this.sortableTable.setOpaque(false);
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public void setModel(TreeMapModel model) {
        this.sortableTable.setModel((TableModel)new VariablesTableModel(model));
        TableColumnChooser.hideColumn((JTable)this.sortableTable, (int)3);
        TableColumnChooser.hideColumn((JTable)this.sortableTable, (int)4);
        model.getProperties().addPropertiesListener(new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                SwingVariablesPanel.this.sortableTable.repaint();
            }
        });
        PropertiesModel propertiesModel = this.resourcesModel.getPropertiesModel();
        DataFrame dataFrame = model.getDataFrame();
        if (dataFrame instanceof WrappedDataFrame) {
            WrappedDataFrame calculatedDataFrame = (WrappedDataFrame)dataFrame;
            this.addButton.setAction(new AddVariableAction(calculatedDataFrame, this.sortableTable.getSelectionModel(), this.mainPanel, propertiesModel));
            this.editButton.setAction(new EditVariableAction(calculatedDataFrame, this.sortableTable.getSelectionModel(), this.mainPanel, propertiesModel));
            this.removeButton.setAction(new RemoveVariableAction(calculatedDataFrame, this.sortableTable.getSelectionModel(), propertiesModel));
        } else {
            this.addButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }

    private void createUIComponents() {
        this.mainPanel = new MJPanel();
        this.sortableTable = new RowStripeSortableTable();
        this.scrollPane = new JideScrollPane();
        this.scrollPane.setVerticalScrollBarPolicy(22);
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)this.scrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        this.scrollPane.setViewportView((Component)this.sortableTable);
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel1, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(0, 0, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.addButton = new JButton();
        this.addButton.setText("Add..");
        panel1.add((Component)this.addButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.editButton = new JButton();
        this.editButton.setText("Edit...");
        panel1.add((Component)this.editButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.removeButton = new JButton();
        this.removeButton.setText("Remove");
        panel1.add((Component)this.removeButton, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

