/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.utils.TypeUtils;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.dataframe.DataFrameListener;
import com.treemap.Aggregation;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import javax.swing.table.AbstractTableModel;

class VariablesTableModel
extends AbstractTableModel
implements ContextSensitiveTableModel {
    private final TreeMapModel model;

    public VariablesTableModel(TreeMapModel model) {
        this.model = model;
        model.getDataFrame().addDataFrameListener(new DataFrameListener(){

            public void dataFrameChanged(DataFrameEvent event) {
                VariablesTableModel.this.fireTableDataChanged();
            }
        });
    }

    @Override
    public int getRowCount() {
        return this.model.getDataFrame().getColumnCount();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.model.getDataFrame().getColumnName(this.model.getDataFrame().getColumnKey(rowIndex));
            }
            case 1: {
                return this.model.getDataFrame().getColumnClass(this.model.getDataFrame().getColumnKey(rowIndex)).getSimpleName();
            }
            case 2: {
                TreeMapField treeMapField = this.model.getTreeMapField(rowIndex);
                if (this.model.isNumericType(treeMapField) || this.model.isTemporalType(treeMapField)) {
                    return this.model.getSettings().getFieldSettings(this.model.getTreeMapField(rowIndex)).getAggregation();
                }
                return null;
            }
            case 3: {
                return this.model.getSettings().getShowPopup(this.model.getTreeMapField(rowIndex));
            }
            case 4: {
                return this.model.getSettings().getFieldSettings(this.model.getTreeMapField(rowIndex)).getShowLabel();
            }
            case 5: {
                return this.model.getFormatPattern(rowIndex);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 2: {
                this.model.getSettings().getFieldSettings(this.model.getTreeMapField(rowIndex)).setAggregation((Aggregation)aValue);
                break;
            }
            case 3: {
                this.model.getSettings().setShowPopup(this.model.getTreeMapField(rowIndex), ((Boolean)aValue).booleanValue());
                break;
            }
            case 4: {
                this.model.getSettings().getFieldSettings(this.model.getTreeMapField(rowIndex)).setShowLabel(((Boolean)aValue).booleanValue());
                break;
            }
            case 5: {
                this.model.setFormatPattern(rowIndex, (String)aValue);
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Aggregation.class;
            }
            case 3: {
                return Boolean.class;
            }
            case 4: {
                return Boolean.class;
            }
            case 5: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Variable";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Aggregation";
            }
            case 3: {
                return "Popup";
            }
            case 4: {
                return "Label";
            }
            case 5: {
                return "Format";
            }
        }
        return null;
    }

    public ConverterContext getConverterContextAt(int rowIndex, int columnIndex) {
        return null;
    }

    public EditorContext getEditorContextAt(int rowIndex, int columnIndex) {
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 2: {
                Class cls = this.model.getDataFrame().getColumnClass(this.model.getDataFrame().getColumnKey(rowIndex));
                return TypeUtils.isNumericType((Class)cls) || TypeUtils.isTemporalType((Class)cls);
            }
            case 3: {
                return true;
            }
            case 4: {
                return (Boolean)this.getValueAt(rowIndex, 3);
            }
            case 5: {
                Class cls = this.model.getDataFrame().getColumnClass(this.model.getDataFrame().getColumnKey(rowIndex));
                return TypeUtils.isNumericType((Class)cls) || TypeUtils.isTemporalType((Class)cls);
            }
        }
        return false;
    }

    public Class<?> getCellClassAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Aggregation.class;
            }
            case 3: {
                return Boolean.class;
            }
            case 4: {
                return Boolean.class;
            }
            case 5: {
                return String.class;
            }
        }
        return null;
    }
}

