/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration.action;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.macrofocus.common.logging.Logging;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.molap.dataframe.WrappedDataFrame;
import com.macrofocus.molap.expression.ExpressionCalculatedColumn;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddVariableDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField nameTextField;
    private JTextField expressionTextField;
    private final WrappedDataFrame model;
    private final ExpressionCalculatedColumn calculatedColumn;
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public AddVariableDialog(WrappedDataFrame model) {
        this(model, null);
    }

    public AddVariableDialog(WrappedDataFrame model, ExpressionCalculatedColumn calculatedColumn) {
        this.$$$setupUI$$$();
        this.model = model;
        this.calculatedColumn = calculatedColumn;
        if (calculatedColumn != null) {
            this.nameTextField.setText(calculatedColumn.getColumnName());
            this.expressionTextField.setText(calculatedColumn.getExpressionString());
        }
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        DocumentListener listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddVariableDialog.this.checkInput();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddVariableDialog.this.checkInput();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddVariableDialog.this.checkInput();
            }
        };
        this.nameTextField.getDocument().addDocumentListener(listener);
        this.expressionTextField.getDocument().addDocumentListener(listener);
        this.buttonOK.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddVariableDialog.this.onOK();
            }
        }, (Object)this.buttonOK));
        this.buttonCancel.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddVariableDialog.this.onCancel();
            }
        }, (Object)this.buttonCancel));
        this.checkInput();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AddVariableDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddVariableDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void onOK() {
        try {
            if (this.calculatedColumn != null) {
                Object oldColunn = this.calculatedColumn.getKey();
                this.calculatedColumn.setColumnName((Object)this.nameTextField.getText());
                this.calculatedColumn.setExpressionString(this.expressionTextField.getText());
                this.model.modifyColumn(oldColunn, (WrappedDataFrame.Column)this.calculatedColumn);
            } else {
                ExpressionCalculatedColumn calculatedColumn = new ExpressionCalculatedColumn((Object)this.nameTextField.getText(), this.expressionTextField.getText());
                this.model.addDerivedColumn(new WrappedDataFrame.Column[]{calculatedColumn});
            }
            this.dispose();
        }
        catch (RuntimeException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    private void onCancel() {
        this.dispose();
    }

    private void checkInput() {
        if (this.nameTextField.getText() != null && !this.nameTextField.getText().trim().equals("") && this.expressionTextField.getText() != null && !this.expressionTextField.getText().trim().equals("")) {
            try {
                ExpressionCalculatedColumn calculatedColumn = new ExpressionCalculatedColumn((Object)this.nameTextField.getText(), this.expressionTextField.getText());
                calculatedColumn.getValue(this.model, this.model.getRowKey(0));
                this.buttonOK.setEnabled(true);
            }
            catch (RuntimeException e) {
                this.buttonOK.setEnabled(false);
            }
            catch (Error e) {
                this.buttonOK.setEnabled(false);
            }
            catch (Exception e) {
                this.buttonOK.setEnabled(false);
            }
        } else {
            this.buttonOK.setEnabled(false);
        }
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel1, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(0, 0, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        panel1.add((Component)panel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.buttonOK = new JButton();
        this.buttonOK.setText("OK");
        panel2.add((Component)this.buttonOK, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.buttonCancel = new JButton();
        this.buttonCancel.setText("Cancel");
        panel2.add((Component)this.buttonCancel, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("Variable Name:");
        panel3.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel3.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.nameTextField = new JTextField();
        panel3.add((Component)this.nameTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Expression (Using [VariableName] to refer to an exisiting variable):");
        panel3.add((Component)label2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.expressionTextField = new JTextField();
        panel3.add((Component)this.expressionTextField, new GridConstraints(3, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

