/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration.action;

import com.macrofocus.molap.dataframe.WrappedDataFrame;
import com.macrofocus.molap.expression.ExpressionCalculatedColumn;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RemoveVariableAction
extends AbstractAction {
    private final WrappedDataFrame model;
    private final ListSelectionModel selectionModel;

    public RemoveVariableAction(WrappedDataFrame model, ListSelectionModel selectionModel, final PropertiesModel propertiesModel) {
        this.model = model;
        this.selectionModel = selectionModel;
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RemoveVariableAction.this.updateState();
            }
        });
        this.updateState();
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    RemoveVariableAction.this.updateProperties(propertiesModel);
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<WrappedDataFrame.Column> toRemove = new ArrayList<WrappedDataFrame.Column>();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            WrappedDataFrame.Column calculatedColumn;
            if (!this.selectionModel.isSelectedIndex(i) || !((calculatedColumn = this.model.getCalculatedColumnAt(i)) instanceof ExpressionCalculatedColumn)) continue;
            toRemove.add(calculatedColumn);
        }
        for (WrappedDataFrame.Column variable : toRemove) {
            this.model.removeDerivedColumn(new WrappedDataFrame.Column[]{variable});
        }
    }

    private void updateState() {
        if (!this.selectionModel.isSelectionEmpty()) {
            ArrayList<WrappedDataFrame.Column> toRemove = new ArrayList<WrappedDataFrame.Column>();
            for (int i = 0; i < this.model.getColumnCount(); ++i) {
                WrappedDataFrame.Column calculatedColumn;
                if (!this.selectionModel.isSelectedIndex(i) || !((calculatedColumn = this.model.getCalculatedColumnAt(i)) instanceof ExpressionCalculatedColumn)) continue;
                toRemove.add(calculatedColumn);
            }
            this.setEnabled(!toRemove.isEmpty());
        } else {
            this.setEnabled(false);
        }
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        String name = "Remove";
        this.putValue("Name", "Remove");
    }
}

