/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.document;

import com.macrofocus.application.file.CPFileManager;
import com.macrofocus.common.command.AbstractUICommand;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.format.swing.SwingFormatFactory;
import com.macrofocus.palette.swing.SwingPaletteFactory;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.xml.XmlElementSerializer;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.util.file.FileHelper;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.swing.FileChooserFactory;
import com.treemap.app.document.TreeMapDocument;
import com.treemap.app.java.document.JavaTreeMapApplication;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ExportSettingsUICommand
extends AbstractUICommand {
    private final FileChooserFactory fileChooserFactory;
    private final JFrame window;
    private CPFileManager<JFrame, File> fileManager;
    private TreeMapDocument document;

    public ExportSettingsUICommand(FileChooserFactory fileChooserFactory, JFrame window, CPFileManager<JFrame, File> fileManager, ResourcesModel resourcesModel) {
        super(resourcesModel.getPropertiesModel().getProperty("action.exportsettings.label"));
        this.fileChooserFactory = fileChooserFactory;
        this.window = window;
        this.fileManager = fileManager;
    }

    public void execute(Object source) {
        int input;
        File file;
        FileFilter fileFilter = null;
        do {
            int value;
            JFileChooser fileChooser;
            if ((fileChooser = this.fileChooserFactory.getFileChooser()).getSelectedFile() == null) {
                fileChooser.setSelectedFile(FileHelper.replaceSuffix((File)((File)this.fileManager.getFile((Object)this.window)), (String)((AbstractFileFilter)fileChooser.getFileFilter()).getDefaultExtension()));
            }
            if ((value = fileChooser.showSaveDialog(this.window)) != 0) {
                return;
            }
            file = fileChooser.getSelectedFile();
            fileFilter = fileChooser.getFileFilter();
        } while ((file = FileHelper.replaceSuffix((File)file, (String)((AbstractFileFilter)fileFilter).getDefaultExtension())) == null || fileFilter == null);
        if (file.exists() && (input = JOptionPane.showConfirmDialog(this.window, "File " + file.getName() + " already exist! Overwrite?", "File already exist", 0, 2)) == 1) {
            return;
        }
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            Element root = JavaTreeMapApplication.save(this.document, file, SwingFactory.getInstance(), SwingFactory.getInstance(), SwingPaletteFactory.getInstance(), (FormatFactory)SwingFormatFactory.getInstance());
            new XmlElementSerializer().write((OutputStream)bos, root);
            bos.close();
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    public void setDocument(TreeMapDocument document) {
        this.document = document;
        this.enabledProperty().setValue((Object)(document != null ? 1 : 0));
    }
}

