/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.document;

import com.macrofocus.application.properties.DocumentBasedApplicationProperties;
import com.macrofocus.colormap.editor.ColorMapEditorFactory;
import com.macrofocus.colormap.swing.SwingColorMapEditorFactory;
import com.macrofocus.format.CPFormat;
import com.macrofocus.format.Formatting;
import com.macrofocus.high_d.filters.Filters;
import com.macrofocus.high_d.filters.swing.SwingFilters;
import com.macrofocus.plot.AxisPlotPanel;
import com.macrofocus.plot.SwingAxisPlotPanel;
import com.treemap.TreeMap;
import com.treemap.TreeMapModel;
import com.treemap.app.java.document.JavaTreeMapDocument;
import com.treemap.app.swing.configuration.SwingDetails;
import com.treemap.app.swing.document.SwingTreeMapApplication;
import com.treemap.app.swing.document.SwingTreeMapView;
import com.treemap.app.swing.treetable.JideTreeTable;
import com.treemap.details.Details;
import com.treemap.swing.SwingTreeMap;
import com.treemap.swing.treeplot.SwingTreePlot;
import com.treemap.treeplot.TreePlot;
import com.treemap.treetable.TreeTable;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class JideTreeMapView<Row, Column, Value>
extends SwingTreeMapView<Row, Column, Value> {
    public JideTreeMapView(SwingTreeMapApplication application, JFrame window, boolean expertMode, DocumentBasedApplicationProperties properties) {
        super(application, window, expertMode, properties);
    }

    @Override
    public TreeMap<JComponent, ?, ?, ?, Color, Font> createTreeMap() {
        TreeMapModel treeMapModel = ((JavaTreeMapDocument)this.getDocument()).getTreeMapModel();
        SwingTreeMap treeMap = new SwingTreeMap(treeMapModel);
        treeMap.getView().setShowTiming(this.expertMode);
        return treeMap;
    }

    @Override
    public TreePlot<JComponent, ?, ?, ?, Color, Font> createTreePlot() {
        SwingTreePlot treePlot = new SwingTreePlot(((JavaTreeMapDocument)this.getDocument()).getTreePlotModel());
        return treePlot;
    }

    @Override
    public AxisPlotPanel<JComponent> createAxisPlotPanel(TreePlot<JComponent, ?, ?, ?, Color, Font> treePlot) {
        SwingAxisPlotPanel axisPlotPanel = new SwingAxisPlotPanel(treePlot.getView().getXGuide(), treePlot.getView().getYGuide());
        axisPlotPanel.addComponent((JComponent)treePlot.getNativeComponent());
        return axisPlotPanel;
    }

    @Override
    public TreeTable<JComponent, ?, ?, ?, Color, Font> createTreeTable() {
        return new JideTreeTable(((JavaTreeMapDocument)this.getDocument()).getTreeMapModel());
    }

    @Override
    public Filters<JComponent, Color, ?, ?, ?> createFilters() {
        SwingFilters filters = new SwingFilters();
        filters.getOrientation().setValue((Object)Filters.Orientation.Vertical);
        filters.setModel(((JavaTreeMapDocument)this.getDocument()).getSubsetDataFrame(), ((JavaTreeMapDocument)this.getDocument()).getVisual(), this.axisGroupModel, null, new Formatting<Column>(){

            public CPFormat getFormat(Column o) {
                return ((JavaTreeMapDocument)JideTreeMapView.this.getDocument()).getTreeMapModel().getSettings().getFieldSettings(((JavaTreeMapDocument)JideTreeMapView.this.getDocument()).getTreeMapModel().getTreeMapField(o)).getFormat();
            }
        });
        return filters;
    }

    @Override
    public Details<JComponent, ?, ?, ?, ?, ?> createDetails() {
        SwingDetails details = new SwingDetails();
        details.setModel(((JavaTreeMapDocument)this.getDocument()).getTreeMapModel());
        return details;
    }

    @Override
    protected ColorMapEditorFactory createColorMapEditorFactory() {
        return SwingColorMapEditorFactory.getInstance();
    }

    @Override
    public void setStyleClass(String ... styleClasses) {
    }
}

