/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.document;

import com.jidesoft.grid.BooleanCheckBoxCellRenderer;
import com.jidesoft.grid.CellEditorFactory;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.ContextSensitiveCellRenderer;
import com.jidesoft.grid.HyperlinkTableCellEditorRenderer;
import com.jidesoft.swing.JideButton;
import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.application.document.DocumentBasedApplication;
import com.macrofocus.application.document.DocumentBasedApplicationState;
import com.macrofocus.application.document.OpenDocumentException;
import com.macrofocus.application.document.View;
import com.macrofocus.application.document.swing.ReloadUICommand;
import com.macrofocus.application.document.swing.SwingDragDropHere;
import com.macrofocus.application.document.swing.SwingSDIDocumentBasedApplication;
import com.macrofocus.application.file.CPDirectoryChooser;
import com.macrofocus.application.file.SwingDirectoryChooser;
import com.macrofocus.application.logging.DetailsDialogLoggingOutput;
import com.macrofocus.application.status.CPStatusBar;
import com.macrofocus.application.treemap.TreeMapPreferencesRoot;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.common.file.CartoPlotFileType;
import com.macrofocus.common.file.CommaDelimitedFileType;
import com.macrofocus.common.file.FileType;
import com.macrofocus.common.file.GeoJSONFileType;
import com.macrofocus.common.file.HCILFileType;
import com.macrofocus.common.file.HTMLTagCloudFileType;
import com.macrofocus.common.file.HighDFileType;
import com.macrofocus.common.file.InfoScopeFileType;
import com.macrofocus.common.file.JarFileType;
import com.macrofocus.common.file.JsonFileType;
import com.macrofocus.common.file.MicrosoftAccessFileType;
import com.macrofocus.common.file.MicrosoftExcelFileType;
import com.macrofocus.common.file.MicrosoftProjectDataInterchangeFileType;
import com.macrofocus.common.file.MicrosoftProjectExchangeFileType;
import com.macrofocus.common.file.MicrosoftProjectFileType;
import com.macrofocus.common.file.ODFSpreadsheetFileType;
import com.macrofocus.common.file.ParquetFileType;
import com.macrofocus.common.file.RTFTagCloudFileType;
import com.macrofocus.common.file.SASFileType;
import com.macrofocus.common.file.SPSSFileType;
import com.macrofocus.common.file.ShapefileFileType;
import com.macrofocus.common.file.TabDelimitedFileType;
import com.macrofocus.common.file.TextTagCloudFileType;
import com.macrofocus.common.file.TreeMLFileType;
import com.macrofocus.common.file.TreeMapFileType;
import com.macrofocus.common.file.ZipFileType;
import com.macrofocus.common.logging.Logging;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.data.dataframe.DataFrameTableModel;
import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.data.source.DataSourceFactory;
import com.macrofocus.data.table.JSONTableModel;
import com.macrofocus.data.table.TableHelper;
import com.macrofocus.data.type.HtmlString;
import com.macrofocus.data.type.series.Series;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.format.swing.SwingFormatFactory;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.igraphics.CPImageFactory;
import com.macrofocus.igraphics.swing.SwingImageFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.JsonDataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.persistence.DefaultDataSourcePersistence;
import com.macrofocus.palette.PaletteFactory;
import com.macrofocus.palette.swing.SwingPaletteFactory;
import com.macrofocus.persistence.DefaultElementFactory;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.persistence.JsonMLElement;
import com.macrofocus.persistence.xml.XmlElementSerializer;
import com.macrofocus.persistence.xom.XomElementFactory;
import com.macrofocus.resources.ResourceBundleResourcesModel;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.WeakResourcesModel;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.swing.MComboBox;
import com.macrofocus.util.logging.MacrofocusLogFactory;
import com.macrofocus.util.logging.SwingLogging;
import com.macrofocus.util.logging.SwingLoggingOutput;
import com.macrofocus.util.swing.action.AboutAction;
import com.macrofocus.util.swing.plaf.action.NamedLookAndFeelAction;
import com.macrofocus.util.swing.table.BufferedImageTableCellRenderer;
import com.macrofocus.util.swing.table.SeriesTableCellRenderer;
import com.macrofocus.util.swing.table.SimpleTableCellRenderer;
import com.macrofocus.util.update.CheckForUpdateAction;
import com.macrofocus.util.update.NewUpdateAction;
import com.macrofocus.util.update.NoUpdateAction;
import com.macrofocus.util.update.UpdateAction;
import com.treemap.AggregationFactory;
import com.treemap.AlgorithmFactory;
import com.treemap.app.document.TreeMapDocument;
import com.treemap.app.document.TreeMapView;
import com.treemap.app.document.persistence.TreeMapPersistence;
import com.treemap.app.java.TreeMapResource;
import com.treemap.app.java.document.JavaTreeMapApplication;
import com.treemap.app.java.document.JavaTreeMapDocument;
import com.treemap.app.java.document.PopulateOpenDatasetCommand;
import com.treemap.app.java.document.persistence.DefaultColorMapState;
import com.treemap.app.swing.TreeMap;
import com.treemap.app.swing.document.JideTreeMapView;
import com.treemap.app.swing.document.SwingTreeMapStatusBar;
import com.treemap.app.swing.document.SwingTreeMapView;
import com.treemap.swing.SwingTreeMap;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.AccessControlException;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import nu.xom.Document;
import nu.xom.Element;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class SwingTreeMapApplication
extends SwingSDIDocumentBasedApplication<JavaTreeMapDocument, TreeMapView<JComponent, JavaTreeMapDocument>>
implements JavaTreeMapApplication<JFrame, JComponent, File, JavaTreeMapDocument> {
    private final String lf;
    private final DocumentBasedApplication.Mode mode;
    private Image applicationIcon;
    private ResourcesModel resourcesModel;
    private CPDirectoryChooser<JFrame, File> directoryChooser;

    public SwingTreeMapApplication(String lf, boolean expert) {
        this.lf = lf;
        this.mode = expert ? DocumentBasedApplication.Mode.Expert : DocumentBasedApplication.Mode.Normal;
        this.allowNewDocument = true;
        this.startWithNewDocument = true;
        this.exitOnClose = false;
    }

    public DocumentBasedApplication.Mode getMode() {
        return this.mode;
    }

    public String[] getRecent() {
        return (String[])this.getResourcesModel().getPropertiesModel().getValue("treemap.recent");
    }

    public void init() {
        SwingTreeMap.setLicenseKey((String)"Macrofocus GmbH", (String)"5SP5S-AJ5RV-MCRKQ-F32W4-V4QWR-AGP8E");
        new NamedLookAndFeelAction(this.lf).perform();
        this.initJide();
        this.initSynthetica();
        this.initLogging();
        super.init();
        this.getApplicationState().addListener(new DocumentBasedApplicationState.Listener(){

            public void closing() {
                SwingTreeMapApplication.this.getResourcesModel().savePreferences();
            }

            public void recentChanged() {
                String[] urls = SwingTreeMapApplication.this.getApplicationState().getRecentURLs();
                SwingTreeMapApplication.this.getResourcesModel().getPropertiesModel().setValue("treemap.recent", (Object)urls);
                SwingTreeMapApplication.this.getResourcesModel().savePreferences();
            }
        });
        this.autoCheckForUpdate();
    }

    public void autoCheckForUpdate() {
        try {
            Component mainFrame = null;
            final CheckForUpdateAction autoCheckForUpdateAction = this.createCheckForUpdateAction(mainFrame, true);
            autoCheckForUpdateAction.setUpdateAction((Action)new NewUpdateAction(mainFrame, this.getApplicationModel(), this.createUpdateAction()));
            autoCheckForUpdateAction.setNoUpdateAction(null);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (autoCheckForUpdateAction != null) {
                            autoCheckForUpdateAction.actionPerformed(new ActionEvent(this, 0, null));
                        }
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }).start();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public CheckForUpdateAction createCheckForUpdateAction(Component mainFrame, boolean checkSchedule) {
        PropertiesModel propertiesModel = this.getResourcesModel().getPropertiesModel();
        CheckForUpdateAction checkForUpdateAction = new CheckForUpdateAction("http://www.treemap.com/installers/updates.xml", checkSchedule, propertiesModel);
        checkForUpdateAction.setUpdateAction((Action)this.createUpdateAction());
        checkForUpdateAction.setNoUpdateAction((Action)new NoUpdateAction(mainFrame));
        return checkForUpdateAction;
    }

    public UpdateAction createUpdateAction() {
        return new UpdateAction("699");
    }

    void initJide() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    CellRendererManager.initDefaultRenderer();
                    CellRendererManager.registerRenderer(Boolean.class, (TableCellRenderer)new BooleanCheckBoxCellRenderer());
                    CellRendererManager.registerRenderer(HtmlString.class, (TableCellRenderer)((Object)new HtmlStringCellRenderer()));
                    CellRendererManager.registerRenderer(Series.class, (TableCellRenderer)new SeriesTableCellRenderer());
                    CellRendererManager.registerRenderer(BufferedImage.class, (TableCellRenderer)new BufferedImageTableCellRenderer());
                    CellRendererManager.registerRenderer(Color.class, (TableCellRenderer)((Object)new ColorTableCellRenderer()));
                    CellEditorManager.initDefaultEditor();
                    CellEditorManager.registerEditor(Boolean.class, (CellEditorFactory)new BooleanCellEditorFactory());
                    LinkTableCellEditorRenderer renderer = new LinkTableCellEditorRenderer();
                    CellRendererManager.registerRenderer(URL.class, (TableCellRenderer)((Object)renderer));
                    CellEditorManager.registerEditor(URL.class, (CellEditorFactory)new LinkCellEditorFactory(renderer));
                }
                catch (NoClassDefFoundError e) {
                    e.printStackTrace();
                }
                catch (AccessControlException e) {
                    e.printStackTrace();
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void initSynthetica() {
        UIManager.put("SidePane.alwaysShowTabText", Boolean.TRUE);
    }

    private void initLogging() {
        SwingLogging.setCommonsLogFactory(MacrofocusLogFactory.class);
        SwingLogging.getInstance().setOutput(new SwingLoggingOutput[]{new DetailsDialogLoggingOutput(null)});
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.ERROR);
    }

    @Override
    public CPDirectoryChooser<JFrame, File> getDirectoryChooser() {
        if (this.directoryChooser == null) {
            this.directoryChooser = new SwingDirectoryChooser();
        }
        return this.directoryChooser;
    }

    protected Image getApplicationIcon() {
        if (this.applicationIcon == null) {
            this.applicationIcon = new ImageIcon(TreeMap.class.getResource("icon32x32.gif")).getImage();
        }
        return this.applicationIcon;
    }

    @Override
    public ResourcesModel getResourcesModel() {
        if (this.resourcesModel == null) {
            this.resourcesModel = new ResourceBundleResourcesModel(TreeMapPreferencesRoot.class, TreeMapResource.class, Locale.getDefault(), TreeMapResource.getPreferences());
        }
        return this.resourcesModel;
    }

    public ResourcesModel createResourcesModel() {
        return new WeakResourcesModel(this.getResourcesModel());
    }

    protected CPStatusBar<JComponent> createStatusBar(CPWindow<JFrame, JComponent> window, TreeMapView<JComponent, JavaTreeMapDocument> view) {
        try {
            SwingTreeMapStatusBar statusBar = new SwingTreeMapStatusBar(new ShowAboutAction(this, window), this.createResourcesModel(), null);
            if (view.getDocument() != null) {
                statusBar.setModel(((JavaTreeMapDocument)view.getDocument()).getTreeMapModel());
            }
            return statusBar;
        }
        catch (UnsupportedClassVersionError e) {
            return super.createStatusBar(window, view);
        }
    }

    public TreeMapView<JComponent, JavaTreeMapDocument> createView(JFrame window, JavaTreeMapDocument document) {
        JideTreeMapView view = new JideTreeMapView(this, window, this.getMode() == DocumentBasedApplication.Mode.Expert, this.createLocalProperties());
        view.init();
        view.setDocument(document);
        return view;
    }

    protected void customizeEmptyView(SwingDragDropHere dragDropHere, CPWindow<JFrame, JComponent> window) {
        super.customizeEmptyView(dragDropHere, window);
        JLabel label = new JLabel();
        label.setText("<html>or load document from <b>server</b></html>");
        label.setVerticalTextPosition(3);
        label.setHorizontalTextPosition(0);
        label.setForeground(Color.GRAY);
        label.setFont(new Font("Monospace", 0, 24));
        dragDropHere.addComponent((JComponent)label);
        final MComboBox onlineMenu = new MComboBox();
        onlineMenu.addItem(null);
        dragDropHere.addComponent((JComponent)onlineMenu);
        String servers = "https://public.treemap.com/";
        if (servers != null) {
            for (String server : servers.split(",")) {
                this.runAsyncBackground(new PopulateOpenDatasetCommand<JFrame, JComponent>(this, window, server), (DocumentBasedApplication.Callback)new DocumentBasedApplication.Callback<PopulateOpenDatasetCommand<JFrame, JComponent>, Object>(){

                    public Object execute(final PopulateOpenDatasetCommand<JFrame, JComponent> arg) {
                        SwingTreeMapApplication.this.runAsyncUIThread(new Command(){
                            private final WeakActionListeners actionListeners = new WeakActionListeners();

                            public void execute() {
                                List<UICommand> commands = arg.getCommands();
                                for (UICommand command : commands) {
                                    onlineMenu.addItem((Object)command);
                                }
                                onlineMenu.addActionListener(this.actionListeners.create(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        UICommand selectedItem = (UICommand)onlineMenu.getSelectedItem();
                                        if (selectedItem != null) {
                                            selectedItem.execute((Object)this);
                                        }
                                    }
                                }, (Object)onlineMenu));
                            }
                        });
                        return null;
                    }
                });
            }
        }
    }

    public JavaTreeMapDocument openLocalDocument(File file, String content, JFrame window) throws OpenDocumentException {
        if (file.getName().endsWith(".json")) {
            try {
                JsonObject treeMap;
                String json = JSONTableModel.convertStreamToString((InputStream)new FileInputStream(file));
                JsonObject root = (JsonObject)Json.instance().parse(json);
                JsonArray data = (JsonArray)root.get("data");
                JsonDataFrame dataFrame = new JsonDataFrame(data);
                dataFrame = new DefaultDataFrame((DataFrame)dataFrame, true);
                JavaTreeMapDocument document = new JavaTreeMapDocument(file.getName(), file.toURI().toURL().toExternalForm(), (DataFrame<Integer, String, ?>)dataFrame, null, SwingFactory.getInstance(), SwingColorMapFactory.getInstance(), (CPImageFactory)SwingImageFactory.getInstance(), null);
                if (root instanceof JsonObject && (treeMap = (JsonObject)root.get("TreeMap")) != null) {
                    DefaultElementFactory elementFactory = new DefaultElementFactory();
                    TreeMapPersistence persistance = new TreeMapPersistence(document, (CPColorFactory)SwingFactory.getInstance(), (CPFontFactory)SwingFactory.getInstance(), AggregationFactory.getInstance(), (PaletteFactory)SwingPaletteFactory.getInstance(), (FormatFactory)SwingFormatFactory.getInstance(), AlgorithmFactory.getInstance(), (ElementFactory)elementFactory, new DefaultColorMapState(SwingFactory.getInstance(), SwingPaletteFactory.getInstance(), (ElementFactory)elementFactory));
                    persistance.load((com.macrofocus.persistence.Element)new JsonMLElement(treeMap));
                }
                return document;
            }
            catch (FileNotFoundException e) {
                throw new OpenDocumentException("File not found " + file.getName(), (Throwable)e);
            }
            catch (IOException e) {
                throw new OpenDocumentException("Could not read file " + file.getName(), (Throwable)e);
            }
            catch (NullPointerException e) {
                throw new OpenDocumentException("Could not decode file " + file.getName(), (Throwable)e);
            }
            catch (Throwable e) {
                throw new OpenDocumentException("Unknown error reading " + file.getName(), e);
            }
        }
        try {
            DataSource dataSource = DataSourceFactory.getDataSource((File)file);
            long start = System.currentTimeMillis();
            MutableDataFrame dataFrame = dataSource.loadDataFrame((Component)window);
            TreeMapDocument document = this.createDocument(file.getName(), file.toURI().toURL().toExternalForm(), dataSource, dataFrame);
            return document;
        }
        catch (FileNotFoundException e) {
            throw new OpenDocumentException("File not found " + file.getName(), (Throwable)e);
        }
        catch (IOException e) {
            throw new OpenDocumentException("Could not read file " + file.getName(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new OpenDocumentException("Could not execute query contained in file " + file.getName(), (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new OpenDocumentException("Could not decode file " + file.getName(), (Throwable)e);
        }
        catch (Throwable e) {
            throw new OpenDocumentException("Unknown error reading " + file.getName(), e);
        }
    }

    public JavaTreeMapDocument openRemoteDocument(String name, String url, String content) throws OpenDocumentException {
        try {
            URL u = new URL(url);
            DataSource dataSource = DataSourceFactory.getDataSource((URL)u);
            MutableDataFrame dataFrame = dataSource.loadDataFrame(null);
            TreeMapDocument document = this.createDocument(name, url, dataSource, dataFrame);
            return document;
        }
        catch (MalformedURLException e) {
            throw new OpenDocumentException("Invalid location " + url, (Throwable)e);
        }
        catch (IOException e) {
            throw new OpenDocumentException("Could not read file " + url, (Throwable)e);
        }
        catch (SQLException e) {
            throw new OpenDocumentException("Could not execute query contained in file " + url, (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new OpenDocumentException("Could not decode file " + url, (Throwable)e);
        }
        catch (Throwable e) {
            throw new OpenDocumentException("Unknown error reading " + url, e);
        }
    }

    @Override
    public JavaTreeMapDocument createDocument(String name, String url, DataSource dataSource, MutableDataFrame<Integer, String, Object> dataFrame) {
        XomElementFactory elementFactory = new XomElementFactory();
        JavaTreeMapDocument document = new JavaTreeMapDocument(name, url, (DataFrame<Integer, String, ?>)dataFrame, new DefaultDataSourcePersistence(dataSource), SwingFactory.getInstance(), SwingColorMapFactory.getInstance(), (CPImageFactory)SwingImageFactory.getInstance(), dataSource);
        Document xml = dataSource.getDocument(ApplicationModelFactory.TREEMAP);
        try {
            Element defaultSettings = TreeMap.getDefaultSettings();
            if (defaultSettings != null) {
                JavaTreeMapApplication.loadSettings((CPFactory)SwingFactory.getInstance(), (PaletteFactory)SwingPaletteFactory.getInstance(), (FormatFactory)SwingFormatFactory.getInstance(), document, defaultSettings);
            }
        }
        catch (RuntimeException e) {
            SwingLogging.getInstance().process((Throwable)e);
        }
        if (xml != null) {
            JavaTreeMapApplication.loadSettings((CPFactory)SwingFactory.getInstance(), (PaletteFactory)SwingPaletteFactory.getInstance(), (FormatFactory)SwingFormatFactory.getInstance(), document, xml.getRootElement());
        }
        return document;
    }

    public UICommand getReloadCommand(TreeMapView<JComponent, JavaTreeMapDocument> view) {
        return new ReloadUICommand(this, (View)view, null, (TreeMapView)view){
            final /* synthetic */ TreeMapView val$view;
            {
                this.val$view = treeMapView;
                super(arg0, arg1, arg2);
            }

            public void execute(Object source) {
                JavaTreeMapDocument document = (JavaTreeMapDocument)this.val$view.getDocument();
                DataSource dataSource = document.getDataSource();
                try {
                    DefaultDataFrame dataFrame = new DefaultDataFrame((DataFrame)dataSource.getOriginalDataSource().loadDataFrame(null));
                    document.setDataFrame((DataFrame)dataFrame);
                }
                catch (IOException e) {
                    Logging.getInstance().process((Throwable)e);
                }
                catch (SQLException e) {
                    Logging.getInstance().process((Throwable)e);
                }
            }
        };
    }

    public void saveView(TreeMapView<JComponent, JavaTreeMapDocument> view) {
    }

    public void saveView(TreeMapView<JComponent, JavaTreeMapDocument> view, File file, FileType fileType) {
        SwingTreeMapApplication.saveDocument((TreeMapDocument)view.getDocument(), file, fileType);
    }

    public static void saveDocument(TreeMapDocument document, File file, FileType fileType) {
        if (fileType == JsonFileType.getInstance()) {
            try {
                String jsonOutput = JavaTreeMapApplication.saveToJSON(document, (CPColorFactory<Color>)SwingFactory.getInstance(), (CPFontFactory<Font>)SwingFactory.getInstance(), (PaletteFactory<Color>)SwingPaletteFactory.getInstance(), (FormatFactory)SwingFormatFactory.getInstance());
                Files.write(file.toPath(), jsonOutput.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                com.macrofocus.persistence.Element root = JavaTreeMapApplication.save(document, file, SwingFactory.getInstance(), SwingFactory.getInstance(), SwingPaletteFactory.getInstance(), (FormatFactory)SwingFormatFactory.getInstance());
                ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                zos.putNextEntry(new ZipEntry("datasource.ser"));
                TableModel tableModel = TableHelper.getExternalizableTableModel((TableModel)new DataFrameTableModel((DataFrame)document.getDataFrame()));
                ObjectOutputStream oout = new ObjectOutputStream(zos);
                oout.writeObject(tableModel);
                zos.closeEntry();
                zos.putNextEntry(new ZipEntry("treemap.xml"));
                new XmlElementSerializer().write((OutputStream)zos, root);
                zos.closeEntry();
                zos.close();
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }
    }

    public void showAbout(CPWindow<JFrame, JComponent> window) {
        TreeMapView view = (TreeMapView)this.getApplicationState().getView(window);
        if (view != null) {
            view.showAbout();
        } else {
            AboutAction aboutAction = new AboutAction(this.getResourcesModel(), "about.jpg", this.getApplicationModel(), null);
            aboutAction.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public FileType[] getOpenFileTypes() {
        return new FileType[]{TreeMapFileType.getInstance(), MicrosoftExcelFileType.getInstance(), CommaDelimitedFileType.getInstance(), TabDelimitedFileType.getInstance(), JsonFileType.getInstance(), ODFSpreadsheetFileType.getInstance(), ParquetFileType.getInstance(), ZipFileType.getInstance(), JarFileType.getInstance(), TreeMLFileType.getInstance(), HCILFileType.getInstance(), GeoJSONFileType.getInstance(), ShapefileFileType.getInstance(), SPSSFileType.getInstance(), SASFileType.getInstance(), MicrosoftAccessFileType.getInstance(), MicrosoftProjectDataInterchangeFileType.getInstance(), MicrosoftProjectExchangeFileType.getInstance(), MicrosoftProjectFileType.getInstance(), TextTagCloudFileType.getInstance(), RTFTagCloudFileType.getInstance(), HTMLTagCloudFileType.getInstance(), InfoScopeFileType.getInstance(), HighDFileType.getInstance(), CartoPlotFileType.getInstance()};
    }

    public FileType[] getSaveFileTypes() {
        switch (this.getMode()) {
            case Normal: {
                return new FileType[]{TreeMapFileType.getInstance()};
            }
            case Expert: {
                return new FileType[]{TreeMapFileType.getInstance(), JsonFileType.getInstance()};
            }
        }
        throw new UnsupportedOperationException("Unsuported mode " + this.getMode());
    }

    public SwingTreeMapView getFocusedView() {
        CPWindow activeWindow = this.getWindowManager().getActiveWindow();
        System.err.println("Active window: " + activeWindow);
        TreeMapView treeMapView = (TreeMapView)this.getApplicationState().getView(activeWindow);
        System.err.println("View: " + treeMapView);
        return (SwingTreeMapView)treeMapView;
    }

    public Component getRootWindow() {
        return (Component)this.getWindowManager().getActiveWindow().getNativeWindow();
    }

    public void waitUntilReady() {
    }

    public void getFocusedModeltDirty(boolean b) {
    }

    private static class LinkCellEditorFactory
    implements CellEditorFactory {
        private final HyperlinkTableCellEditorRenderer renderer;

        public LinkCellEditorFactory(HyperlinkTableCellEditorRenderer renderer) {
            this.renderer = renderer;
        }

        public CellEditor create() {
            return this.renderer;
        }
    }

    private static class LinkTableCellEditorRenderer
    extends HyperlinkTableCellEditorRenderer {
        private final SimpleTableCellRenderer nullComponent = new SimpleTableCellRenderer();

        public LinkTableCellEditorRenderer() {
            this.setActionListener(e -> {
                Object source = e.getSource();
                try {
                    JideButton button = (JideButton)source;
                    String text = button.getText();
                    if (text != null && text.length() > 0) {
                        URL value = new URL(text);
                        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                            try {
                                Desktop.getDesktop().browse(value.toURI());
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            catch (URISyntaxException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            });
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                value = "";
            }
            if (value != null) {
                return super.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
            return null;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = "";
            }
            if (value != null) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return this.nullComponent;
        }
    }

    private static class BooleanCellEditorFactory
    implements CellEditorFactory {
        private BooleanCellEditorFactory() {
        }

        public CellEditor create() {
            return new DefaultCellEditor((JCheckBox)new BooleanCheckBoxCellRenderer());
        }
    }

    private static class ColorTableCellRenderer
    extends com.macrofocus.util.swing.table.ColorTableCellRenderer {
        private ColorTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, selected, hasFocus, row, column);
            ContextSensitiveCellRenderer.installColorFontAndBorder((JTable)table, (Component)component, (boolean)selected, (boolean)hasFocus, (int)row, (int)column);
            return component;
        }
    }

    private static class HtmlStringCellRenderer
    extends ContextSensitiveCellRenderer {
        private HtmlStringCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, (Object)this.addTag((HtmlString)value), isSelected, hasFocus, row, column);
        }

        public String addTag(HtmlString value) {
            if (value != null) {
                if (!value.toString().startsWith("<html>")) {
                    return "<html>" + value + "</html>";
                }
                return value.toString();
            }
            return null;
        }
    }

    private static class ShowAboutAction
    extends AbstractAction {
        private final SwingTreeMapApplication application;
        private final CPWindow<JFrame, JComponent> window;

        public ShowAboutAction(SwingTreeMapApplication application, CPWindow<JFrame, JComponent> window) {
            this.application = application;
            this.window = window;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.application.showAbout(this.window);
        }
    }
}

