/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.document;

import com.macrofocus.application.ActionUICommand;
import com.macrofocus.application.ApplicationModel;
import com.macrofocus.application.ToggleActionToggleUICommand;
import com.macrofocus.application.ToggleUICommand;
import com.macrofocus.application.document.View;
import com.macrofocus.application.document.swing.FullScreenCommand;
import com.macrofocus.application.file.CPFileManager;
import com.macrofocus.application.menu.CPMenu;
import com.macrofocus.application.menu.ToggleGroup;
import com.macrofocus.application.properties.DocumentBasedApplicationProperties;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.colormap.editor.ColorMapEditorFactory;
import com.macrofocus.colormap.swing.SwingColorMapEditorFactory;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.docking.Dockable;
import com.macrofocus.docking.DockingPanel;
import com.macrofocus.docking.swing.SwingDockingFactory;
import com.macrofocus.docking.swing.SwingNakedDockable;
import com.macrofocus.format.CPFormat;
import com.macrofocus.format.Formatting;
import com.macrofocus.high_d.filters.Filters;
import com.macrofocus.high_d.filters.swing.SwingFilters;
import com.macrofocus.plot.AxisPlotPanel;
import com.macrofocus.plot.SwingAxisPlotPanel;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.registration.LicenseHelper;
import com.macrofocus.util.registration.RegisterAction;
import com.macrofocus.util.swing.action.ToggleAction;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.macrofocus.util.swing.export.format.FileProvider;
import com.macrofocus.util.swing.plaf.action.LookAndFeelAction;
import com.macrofocus.util.swing.print.CopyAction;
import com.macrofocus.util.swing.print.PageSetupAction;
import com.macrofocus.util.swing.print.PrintComponentAction;
import com.treemap.AlgorithmFactory;
import com.treemap.ThreeDTreeMapView;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapPanel;
import com.treemap.TreeMapView;
import com.treemap.app.document.ConfigurationPanel;
import com.treemap.app.document.TreeMapDocument;
import com.treemap.app.java.document.JavaTreeMapApplication;
import com.treemap.app.java.document.JavaTreeMapDocument;
import com.treemap.app.java.document.JavaTreeMapView;
import com.treemap.app.swing.TreeMap;
import com.treemap.app.swing.action.SwingTreeMapActionsModel;
import com.treemap.app.swing.action.TreeMapActionsModel;
import com.treemap.app.swing.configuration.SwingVariablesPanel;
import com.treemap.app.swing.document.ColorMapFileChooserFactory;
import com.treemap.app.swing.document.ExportSettingsUICommand;
import com.treemap.app.swing.document.ImportSettingsUICommand;
import com.treemap.app.swing.document.SettingsFileChooserFactory;
import com.treemap.app.swing.document.SwingConfigurationPanel;
import com.treemap.app.swing.document.SwingTreeMapApplication;
import com.treemap.app.swing.document.export.Export3DModelAction;
import com.treemap.app.swing.document.export.ExportDataAction;
import com.treemap.app.swing.document.export.ExportGraphicsAction;
import com.treemap.app.swing.document.export.TreeMapComponentCustomizer;
import com.treemap.app.swing.presentation.implementation.SwingTreeMapPanel;
import com.treemap.app.swing.presentation.implementation.treedee.OpenGLPanel2;
import com.treemap.app.swing.presentation.implementation.treeplot.SwingTreePlotPanel;
import com.treemap.app.swing.presentation.implementation.treetable.TreeTablePanel;
import com.treemap.app.swing.treetable.SwingTreeTable;
import com.treemap.app.swing.v4.settings.algorithm.MAlgorithmFactory;
import com.treemap.details.Details;
import com.treemap.swing.SwingTreeMap;
import com.treemap.swing.details.SwingDetails;
import com.treemap.swing.treeplot.SwingTreePlot;
import com.treemap.treeplot.TreePlot;
import com.treemap.treeplot.TreePlotPanel;
import com.treemap.treetable.TreeTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class SwingTreeMapView<Row, Column, Value>
extends JavaTreeMapView<JFrame, JComponent, Row, Column, Value, Color, Font> {
    private final SwingTreeMapApplication application;
    private final JFrame window;
    protected final boolean expertMode;
    private ResourcesModel resourcesModel;
    private TreeMapActionsModel actionsModel;
    private SwingTreeMapPanel treeMapPanel;
    private SwingConfigurationPanel configurationPanel;
    private TreeMapView treeMapView;

    public SwingTreeMapView(SwingTreeMapApplication application, JFrame window, boolean expertMode, DocumentBasedApplicationProperties properties) {
        super(SwingDockingFactory.getInstance(), SwingFactory.getInstance(), SwingColorMapFactory.getInstance(), (AlgorithmFactory)MAlgorithmFactory.getInstance(expertMode, false), expertMode, properties);
        this.application = application;
        this.window = window;
        this.expertMode = expertMode;
    }

    public void init() {
        this.resourcesModel = this.application.createResourcesModel();
        this.actionsModel = new SwingTreeMapActionsModel(this.window, this.window.getRootPane(), TreeMap.applicationModel, this.resourcesModel, this.expertMode);
    }

    @Override
    public JavaTreeMapApplication<JFrame, JComponent, File, JavaTreeMapDocument> getApplication() {
        return this.application;
    }

    public void setDocument(JavaTreeMapDocument document) {
        super.setDocument((TreeMapDocument)document);
        this.application.runAsyncUIThread(new Command(){

            public void execute() {
                RegisterAction registerAction = new RegisterAction(TreeMap.applicationModel);
                registerAction.loadLicenseData(SwingTreeMapView.this.resourcesModel.getPropertiesModel());
                registerAction.setResourcesModel(SwingTreeMapView.this.resourcesModel);
                LicenseHelper.checkLicenseData((ApplicationModel)TreeMap.applicationModel, (RegisterAction)registerAction, (JFrame)SwingTreeMapView.this.window);
            }
        });
    }

    public ThreeDTreeMapView<?, Row, Column, Color, Font, JComponent> create3DTreeMap() {
        TreeMapModel treeMapModel = ((JavaTreeMapDocument)this.getDocument()).getTreeMapModel();
        OpenGLPanel2 treeMap = new OpenGLPanel2();
        treeMap.setModel(treeMapModel);
        return treeMap;
    }

    public com.treemap.TreeMap<JComponent, ?, ?, ?, Color, Font> createTreeMap() {
        TreeMapModel treeMapModel = ((JavaTreeMapDocument)this.getDocument()).getTreeMapModel();
        SwingTreeMap treeMap = new SwingTreeMap(treeMapModel);
        this.treeMapView = treeMap.getView();
        this.treeMapView.setShowTiming(this.expertMode);
        return treeMap;
    }

    public TreeMapPanel<JComponent> createTreeMapPanel(com.treemap.TreeMap<JComponent, ?, ?, ?, Color, Font> treeMap) {
        this.treeMapPanel = new SwingTreeMapPanel(treeMap.getView());
        return this.treeMapPanel;
    }

    public TreePlot<JComponent, ?, ?, ?, Color, Font> createTreePlot() {
        SwingTreePlot treePlot = new SwingTreePlot(((JavaTreeMapDocument)this.getDocument()).getTreeMapModel());
        return treePlot;
    }

    public TreePlotPanel<JComponent> createTreePlotPanel(TreePlot<JComponent, ?, ?, ?, Color, Font> treePlot) {
        try {
            return new SwingTreePlotPanel(treePlot);
        }
        catch (UnsupportedClassVersionError e) {
            return null;
        }
    }

    public AxisPlotPanel<JComponent> createAxisPlotPanel(TreePlot<JComponent, ?, ?, ?, Color, Font> treePlot) {
        SwingAxisPlotPanel axisPlotPanel = new SwingAxisPlotPanel(treePlot.getView().getXGuide(), treePlot.getView().getYGuide());
        axisPlotPanel.addComponent((JComponent)treePlot.getNativeComponent());
        return axisPlotPanel;
    }

    public TreeTable<JComponent, ?, ?, ?, Color, Font> createTreeTable() {
        return new SwingTreeTable(((JavaTreeMapDocument)this.getDocument()).getTreeMapModel());
    }

    public Filters<JComponent, Color, ?, ?, ?> createFilters() {
        SwingFilters filters = new SwingFilters();
        filters.getOrientation().setValue((Object)Filters.Orientation.Vertical);
        filters.setModel(((JavaTreeMapDocument)this.getDocument()).getSubsetDataFrame(), ((JavaTreeMapDocument)this.getDocument()).getVisual(), this.axisGroupModel, null, new Formatting<Column>(){

            public CPFormat getFormat(Column o) {
                return ((JavaTreeMapDocument)SwingTreeMapView.this.getDocument()).getTreeMapModel().getSettings().getFieldSettings(((JavaTreeMapDocument)SwingTreeMapView.this.getDocument()).getTreeMapModel().getTreeMapField(o)).getFormat();
            }
        });
        return filters;
    }

    public ConfigurationPanel<JComponent, Color, Font> createConfiguration() {
        try {
            PropertiesModel propertiesModel = this.resourcesModel.getPropertiesModel();
            this.configurationPanel = new SwingConfigurationPanel(this.getDocument(), new ColorMapFileChooserFactory(), this.algorithmFactory, propertiesModel);
            SwingVariablesPanel variablesPanel = new SwingVariablesPanel(this.resourcesModel);
            variablesPanel.setModel(((JavaTreeMapDocument)this.getDocument()).getTreeMapModel());
            SwingNakedDockable variablesDockable = new SwingNakedDockable((JComponent)variablesPanel.getMainPanel(), (String)propertiesModel.getValue("tab.variables.label"), "com/treemap/app/swing/configurableMisc16.png");
            DockingPanel mainPanel = this.configurationPanel.getDockingPanel();
            mainPanel.setVerticalLastDividerSize(250.0);
            if (variablesDockable != null) {
                mainPanel.getSouthDockingBar().attach((Dockable)variablesDockable);
                mainPanel.getSouthDockingBar().setActive((Dockable)variablesDockable, false);
            }
            return this.configurationPanel;
        }
        catch (UnsupportedClassVersionError e) {
            return super.createConfiguration();
        }
    }

    public Details<JComponent, ?, ?, ?, ?, ?> createDetails() {
        return new SwingDetails(((JavaTreeMapDocument)this.getDocument()).getTreeMapModel());
    }

    protected ColorMapEditorFactory createColorMapEditorFactory() {
        return SwingColorMapEditorFactory.getInstance();
    }

    public void customizeFileSave(CPMenu<JComponent> fileMenu) {
        CPWindow window = this.getApplication().getApplicationState().getWindow((View)this);
        fileMenu.addSeparator();
        FileProvider fileProvider = () -> {
            File file = (File)this.application.getFileManager().getFile((Object)((JFrame)window.getNativeWindow()));
            if (file != null) {
                return file;
            }
            return this.getDocument() != null ? new File(((JavaTreeMapDocument)this.getDocument()).getDocumentState().getName()) : new File("Untitled");
        };
        ExportGraphicsAction exportGraphicsAction = new ExportGraphicsAction(((JFrame)window.getNativeWindow()).getRootPane(), null, new TreeMapComponentCustomizer(), this.expertMode);
        if (this.getDocument() != null) {
            ContentProvider contentProvider = () -> this.getActive();
            exportGraphicsAction.setContent((ContentProvider<JComponent>)contentProvider, (FileProvider<File>)fileProvider);
        }
        ActionUICommand exportGraphicsCommand = new ActionUICommand((Action)exportGraphicsAction);
        fileMenu.addAction((UICommand)exportGraphicsCommand);
        ExportDataAction exportDataAction = new ExportDataAction(((JFrame)window.getNativeWindow()).getRootPane(), null, false);
        if (this.getDocument() != null) {
            ContentProvider contentProvider = () -> this.getDocument();
            exportDataAction.setContent((ContentProvider<TreeMapDocument>)contentProvider, (FileProvider<File>)fileProvider);
        }
        ActionUICommand exportDataCommand = new ActionUICommand((Action)exportDataAction);
        fileMenu.addAction((UICommand)exportDataCommand);
        Export3DModelAction export3DModelAction = new Export3DModelAction(((JFrame)window.getNativeWindow()).getRootPane(), null, false);
        if (this.getDocument() != null) {
            ContentProvider contentProvider = () -> this.getDocument();
            export3DModelAction.setContent((ContentProvider<TreeMapDocument>)contentProvider, (FileProvider<File>)fileProvider);
        }
        ActionUICommand export3DModelCommand = new ActionUICommand((Action)export3DModelAction);
        fileMenu.addAction((UICommand)export3DModelCommand);
        fileMenu.addSeparator();
        SettingsFileChooserFactory fileChooserFactory = new SettingsFileChooserFactory(this.getDocument(), (FileProvider<File>)fileProvider, this.expertMode);
        ImportSettingsUICommand importSettingsUICommand = new ImportSettingsUICommand(fileChooserFactory, (JFrame)window.getNativeWindow(), (CPFileManager<JFrame, File>)this.application.getFileManager(), this.resourcesModel);
        ExportSettingsUICommand exportSettingsUICommand = new ExportSettingsUICommand(fileChooserFactory, (JFrame)window.getNativeWindow(), (CPFileManager<JFrame, File>)this.application.getFileManager(), this.resourcesModel);
        importSettingsUICommand.setDocument(this.getDocument());
        exportSettingsUICommand.setDocument(this.getDocument());
        fileMenu.addEllipsisAction((UICommand)importSettingsUICommand);
        fileMenu.addEllipsisAction((UICommand)exportSettingsUICommand);
        fileMenu.addSeparator();
        SimpleProperty pageFormat = new SimpleProperty(null);
        fileMenu.addAction((UICommand)new ActionUICommand((Action)new PageSetupAction((MutableProperty)pageFormat)));
        PrintComponentAction printAction = new PrintComponentAction((MutableProperty)pageFormat);
        if (this.getDocument() != null) {
            ContentProvider contentProvider = () -> this.getActive();
            printAction.setComponent(contentProvider);
        }
        fileMenu.addAction((UICommand)new ActionUICommand((Action)printAction));
    }

    protected void customizeEditMenu(CPMenu<JComponent> edit) {
        super.customizeEditMenu(edit);
        edit.addSeparator();
        CopyAction copyAction = new CopyAction(this.resourcesModel.getPropertiesModel(), "action.copygraphics.label", (CopyAction.CopyCustomizer)new TreeMapComponentCustomizer());
        if (this.getDocument() != null) {
            copyAction.setComponent((Component)this.getNativeComponent());
        }
        edit.addAction((UICommand)new ActionUICommand((Action)copyAction));
    }

    protected void customizeOptionsMenu(CPMenu<JComponent> menu) {
        super.customizeOptionsMenu(menu);
        menu.addSeparator();
        CPMenu lookFeelMenu = menu.addMenu("Look & Feel");
        ToggleGroup group = new ToggleGroup();
        Supplier<Iterable> windowSupplier = () -> Arrays.asList(Window.getWindows());
        for (LookAndFeelAction lookAndFeelAction : LookAndFeelAction.TREEMAP_LOOK_AND_FEEL_ACTIONS) {
            if (!lookAndFeelAction.exist()) continue;
            lookAndFeelAction.setRootComponents(windowSupplier);
            ToggleActionToggleUICommand command = new ToggleActionToggleUICommand((ToggleAction)lookAndFeelAction);
            lookFeelMenu.addRadio((ToggleUICommand)command, group);
        }
    }

    protected void customizeWindowMenu(CPMenu<JComponent> window) {
        super.customizeWindowMenu(window);
        window.addCheckBox((ToggleUICommand)new FullScreenCommand(this.window));
    }

    protected void customizeHelpMenu(CPMenu helpMenu) {
        helpMenu.addAction((UICommand)new ActionUICommand(this.actionsModel.getHelpAction()));
        helpMenu.addSeparator();
        try {
            helpMenu.addAction((UICommand)new ActionUICommand((Action)this.application.createCheckForUpdateAction(this.window, false)));
            helpMenu.addSeparator();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        helpMenu.addAction((UICommand)new ActionUICommand((Action)this.actionsModel.getRegisterAction()));
        helpMenu.addSeparator();
        helpMenu.addAction((UICommand)new ActionUICommand((Action)this.actionsModel.getAboutAction()));
    }

    public void showAbout() {
        this.actionsModel.getAboutAction().actionPerformed(new ActionEvent((Object)this, 0, null));
    }

    public JComponent getActive() {
        for (Dockable mainDockable : this.getInnerDocking().getSouthDockingBar().getDockables()) {
            JComponent component = (JComponent)mainDockable.getComponent();
            if (!component.isShowing()) continue;
            if (component instanceof SwingTreeMapPanel) {
                return (JComponent)((SwingTreeMapPanel)component).getTreeMapView().getNativeComponent();
            }
            if (component instanceof SwingTreePlotPanel) {
                return ((SwingTreePlotPanel)component).getSnapshotPanel();
            }
            if (component instanceof TreeTablePanel) {
                TreeTablePanel treeTablePanel = (TreeTablePanel)component;
                return treeTablePanel.getTreeTable();
            }
            return component;
        }
        return (JComponent)((Dockable)this.getInnerDocking().getSouthDockingBar().getDockables().iterator().next()).getComponent();
    }

    public void setStyleClass(String ... styleClasses) {
    }

    public TreeMapModel<?, Row, Column, Color, Font> getTreeMapModel() {
        return this.treeMap.getModel();
    }

    public com.treemap.app.swing.configuration.SwingConfigurationPanel getConfiguration() {
        return this.configurationPanel.getSwingConfigurationPanel();
    }

    public TreeMapView<JComponent, ?, ?, ?, ?, ?> getTreeMapView() {
        return this.treeMapPanel.getTreeMapView();
    }

    public DockingPanel<JComponent> getDockingManager() {
        return this.dockingPanel;
    }

    public TreeMapPanel<JComponent> getTreeMapPanel() {
        return this.treeMapPanel;
    }

    public Component getMainPanel() {
        return null;
    }

    public void waitUntilReady() {
        while (((JavaTreeMapDocument)this.getDocument()).getTreeMapModel() == null || ((JavaTreeMapDocument)this.getDocument()).getTreeMapModel().getRoot() == null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        ((JavaTreeMapDocument)this.getDocument()).getTreeMapModel().waitUntilReady();
    }
}

