/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.document.export;

import com.macrofocus.geom.Rectangle;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.file.filter.MicrosoftPowerpointFileFilter;
import com.macrofocus.util.swing.export.format.AbstractGraphicsExportFormat;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.poi.hslf.usermodel.HSLFAutoShape;
import org.apache.poi.hslf.usermodel.HSLFGroupShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTextBox;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextRun;
import org.apache.poi.sl.usermodel.AutoShape;
import org.apache.poi.sl.usermodel.Shape;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.sl.usermodel.ShapeType;
import org.apache.poi.sl.usermodel.Slide;

public class PowerpointExportFormat
extends AbstractGraphicsExportFormat {
    public boolean isValid() {
        return true;
    }

    public AbstractFileFilter getFileFilter() {
        return new MicrosoftPowerpointFileFilter();
    }

    public Component getSettingsPanel() {
        return null;
    }

    public void save(ContentProvider<Component> contentProvider, File file) throws IOException {
        if (contentProvider.getContent() instanceof TreeMapView) {
            TreeMapView view = (TreeMapView)contentProvider.getContent();
            TreeMapModel model = view.getModel();
            HSLFSlideShow ppt = new HSLFSlideShow();
            Slide slide = ppt.createSlide();
            Dimension pgsize = ppt.getPageSize();
            HSLFGroupShape group = new HSLFGroupShape();
            int margin = 5;
            double scalex = (double)(pgsize.width - 10) / (double)model.getSettings().getDimension().width;
            double scaley = (double)(pgsize.height - 10) / (double)model.getSettings().getDimension().height;
            double scale = Math.min(scalex, scaley);
            int scaledWidth = (int)((double)model.getSettings().getDimension().width * scale);
            int scaledHeight = (int)((double)model.getSettings().getDimension().height * scale);
            java.awt.Rectangle bounds = new java.awt.Rectangle((pgsize.width - scaledWidth) / 2, (pgsize.height - scaledHeight) / 2, scaledWidth, scaledHeight);
            group.setAnchor((Rectangle2D)bounds);
            group.setAnchor((Rectangle2D)new java.awt.Rectangle(0, 0, model.getSettings().getDimension().width, model.getSettings().getDimension().height));
            slide.addShape((Shape)group);
            for (Object node : model.breadthFirstIterator(model.getCurrentRoot())) {
                if (model.hasNoChildren(node)) continue;
                CPColor cPColor2 = model.getColor(node);
                cPColor2 = model.getSettings().getFieldSettings(model.getGroupByField(node)).getHeaderBackground();
                Rectangle b = model.getShape(node).getBounds();
                java.awt.Rectangle rect = new java.awt.Rectangle(b.x, b.y, b.width, b.height);
                HSLFTextBox txt = new HSLFTextBox((ShapeContainer)group);
                txt.setAnchor((Rectangle2D)rect);
                txt.setText(node.toString());
                txt.setWordWrap(false);
                txt.setWordWrapEx(2);
                txt.setHorizontalCentered(Boolean.TRUE);
                HSLFTextRun rt = (HSLFTextRun)((HSLFTextParagraph)txt.getTextParagraphs().get(0)).getTextRuns().get(0);
                rt.setFontSize(Double.valueOf(Math.min(rect.height, (int)(model.getSettings().getFieldSettings(model.getGroupByField(node)).getHeaderFont().getSize2D() * scale))));
                rt.setEmbossed(true);
                rt.setFontColor((Color)model.getSettings().getFieldSettings(model.getGroupByField(node)).getHeaderForeground().getNativeColor());
                txt.setTopInset(0.0);
                txt.setLeftInset(0.0);
                txt.setRightInset(0.0);
                txt.setBottomInset(0.0);
                txt.setFillColor((Color)cPColor2.getNativeColor());
                group.addShape((HSLFShape)txt);
            }
            TreeSet<Shape> orderedSet = new TreeSet<Shape>(new XShapeComparator());
            for (Object e : model.breadthFirstIterator(model.getCurrentRoot())) {
                if (!model.hasNoChildren(e)) continue;
                Color color = (Color)model.getColor(e).getNativeColor();
                Rectangle b = model.getShape(e).getBounds();
                java.awt.Rectangle rect = new java.awt.Rectangle(b.x, b.y, b.width, b.height);
                HSLFAutoShape shape = new HSLFAutoShape(ShapeType.RECT, (ShapeContainer)group);
                shape.setAnchor((Rectangle2D)rect);
                shape.setLineColor(color);
                shape.setFillColor(color);
                shape.setTopInset(0.0);
                shape.setLeftInset(0.0);
                shape.setRightInset(0.0);
                shape.setBottomInset(0.0);
                orderedSet.add((Shape)shape);
                HSLFTextBox txt = new HSLFTextBox((ShapeContainer)group);
                txt.setAnchor((Rectangle2D)rect);
                txt.setFillColor(null);
                txt.setText(e.toString());
                txt.setWordWrap(false);
                txt.setWordWrapEx(2);
                HSLFTextRun rt = (HSLFTextRun)((HSLFTextParagraph)txt.getTextParagraphs().get(0)).getTextRuns().get(0);
                rt.setFontSize(Double.valueOf(Math.min(rect.height, (int)(model.getSettings().getFieldSettings(model.getGroupByField(e)).getLabelingFont().getSize2D() * scale))));
                txt.setTopInset(0.0);
                txt.setLeftInset(0.0);
                txt.setRightInset(0.0);
                txt.setBottomInset(0.0);
                orderedSet.add((Shape)txt);
            }
            for (HSLFShape hSLFShape : orderedSet) {
                group.addShape(hSLFShape);
            }
            FileOutputStream out = new FileOutputStream(file);
            ppt.write((OutputStream)out);
            out.close();
        }
    }

    private static class YShapeComparator
    implements Comparator<Shape> {
        private YShapeComparator() {
        }

        @Override
        public int compare(Shape o1, Shape o2) {
            if (o1.getAnchor().getY() < o2.getAnchor().getY()) {
                return -1;
            }
            if (o1.getAnchor().getY() > o2.getAnchor().getY()) {
                return 1;
            }
            if (o1.getAnchor().getX() < o2.getAnchor().getX()) {
                return -1;
            }
            if (o1.getAnchor().getX() > o2.getAnchor().getX()) {
                return 1;
            }
            return 0;
        }
    }

    private static class XShapeComparator
    implements Comparator<Shape> {
        private XShapeComparator() {
        }

        @Override
        public int compare(Shape o1, Shape o2) {
            if (o1.getAnchor().getX() < o2.getAnchor().getX()) {
                return -1;
            }
            if (o1.getAnchor().getX() > o2.getAnchor().getX()) {
                return 1;
            }
            if (o1.getAnchor().getY() < o2.getAnchor().getY()) {
                return -1;
            }
            if (o1.getAnchor().getY() > o2.getAnchor().getY()) {
                return 1;
            }
            if (o1 instanceof AutoShape) {
                if (o2 instanceof AutoShape) {
                    return 0;
                }
                return -1;
            }
            if (o2 instanceof AutoShape) {
                return 1;
            }
            return 0;
        }
    }
}

