/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.document.export;

import com.macrofocus.common.file.FileType;
import com.macrofocus.common.file.X3DFileType;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.file.filter.FileTypeFileFilter;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.macrofocus.util.swing.export.format.ExportFormat;
import com.treemap.NoTreeMapField;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import com.treemap.app.document.TreeMapDocument;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.web3d.x3d.jsail.Core.Scene;
import org.web3d.x3d.jsail.Core.X3D;
import org.web3d.x3d.jsail.Core.head;
import org.web3d.x3d.jsail.Core.meta;
import org.web3d.x3d.jsail.Geometry3D.Box;
import org.web3d.x3d.jsail.Grouping.Group;
import org.web3d.x3d.jsail.Grouping.Transform;
import org.web3d.x3d.jsail.Navigation.Viewpoint;
import org.web3d.x3d.jsail.Shape.Appearance;
import org.web3d.x3d.jsail.Shape.Material;
import org.web3d.x3d.jsail.Shape.Shape;
import org.web3d.x3d.sai.Core.X3DChildNode;
import org.web3d.x3d.sai.Rendering.X3DGeometryNode;
import org.web3d.x3d.sai.Shape.X3DAppearanceNode;
import org.web3d.x3d.sai.Shape.X3DMaterialNode;

public class X3DExportFormat
implements ExportFormat<TreeMapDocument> {
    private final float FLOOR_SIZE = 1.0f;
    private final float DEFAULT_HEIGHT = 1.0f;

    public boolean isValid() {
        return true;
    }

    public AbstractFileFilter getFileFilter() {
        return new FileTypeFileFilter((FileType)X3DFileType.getInstance());
    }

    public Component getSettingsPanel() {
        return null;
    }

    public void copy(ContentProvider<TreeMapDocument> contentProvider) throws IOException {
    }

    public void save(ContentProvider<TreeMapDocument> contentProvider, File file) throws IOException {
        float verticalScalingFactor;
        TreeMapModel treeMapModel = ((TreeMapDocument)contentProvider.getContent()).getTreeMapModel();
        X3D x3dModel = new X3D();
        Scene scene = new Scene();
        Group group = new Group();
        scene.addChild((X3DChildNode)group);
        Object rootNode = treeMapModel.getRoot();
        Rectangle2D rootBounds = treeMapModel.getBounds(rootNode);
        float xMax = (float)rootBounds.getWidth();
        float yMax = (float)rootBounds.getHeight();
        float min = Math.min(xMax, yMax);
        Viewpoint viewpoint = new Viewpoint();
        viewpoint.setPosition(xMax / 2.0f, yMax / 2.0f, 1000.0f);
        viewpoint.setCenterOfRotation(xMax / 2.0f, yMax / 2.0f, 0.0f);
        scene.addChild((X3DChildNode)viewpoint);
        TreeMapField field = (TreeMapField)treeMapModel.getSettings().getHeightVariableSelection().getSelected();
        if (field instanceof NoTreeMapField) {
            verticalScalingFactor = 0.0f;
        } else {
            float maxHeight = treeMapModel.getNumericMax(field).floatValue();
            verticalScalingFactor = 1.0f / maxHeight * 1.0f * ((float)treeMapModel.getSettings().getMaximumHeight() * 2.0f);
        }
        Object node = treeMapModel.getCurrentRoot();
        Rectangle2D bounds = treeMapModel.getBounds(node);
        float width = (float)bounds.getWidth();
        float height = (float)bounds.getHeight();
        if (!Float.isNaN(width) && !Float.isNaN(height)) {
            Object value;
            float x = (float)bounds.getX();
            float y = (float)bounds.getY();
            float p1x = x - (float)rootBounds.getX();
            float p1y = yMax - y + (float)rootBounds.getY();
            float p2x = x + width - (float)rootBounds.getX();
            float p2y = yMax - y + (float)rootBounds.getY();
            float p3x = x + width - (float)rootBounds.getX();
            float p3y = yMax - (y + height) + (float)rootBounds.getY();
            float p4x = x - (float)rootBounds.getX();
            float p4y = yMax - (y + height) + (float)rootBounds.getY();
            Appearance appearance = new Appearance();
            SwingColor color = new SwingColor(Color.black);
            appearance.setMaterial((X3DMaterialNode)new Material().setDiffuseColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f));
            float size = 1.0f;
            if (!(field instanceof NoTreeMapField) && (value = field.getValue(node)) != null) {
                size = ((Number)value).floatValue();
                float maxHeight = treeMapModel.getNumericMax(field).floatValue();
                size = size / maxHeight * ((float)treeMapModel.getSettings().getMaximumHeight() * min);
            }
            Box geometry = new Box();
            float halfWidth = (p2x - p1x) / 2.0f;
            float halfHeight = (p1y - p4y) / 2.0f;
            float halfSize = size / 2.0f;
            geometry.setSize(p2x - p1x, p1y - p4y, 1.0f);
            group.addChild((X3DChildNode)new Transform().setTranslation(p1x + halfWidth, p4y + halfHeight, 0.0f + halfSize).addChild((X3DChildNode)new Shape().setAppearance((X3DAppearanceNode)appearance).setGeometry((X3DGeometryNode)geometry)));
        }
        for (Object node2 : treeMapModel.preorderEnumeration(treeMapModel.getCurrentRoot())) {
            Object value;
            if (!treeMapModel.hasNoChildren(node2)) continue;
            Rectangle2D bounds2 = treeMapModel.getBounds(node2);
            float width2 = (float)bounds2.getWidth();
            float height2 = (float)bounds2.getHeight();
            if (Float.isNaN(width2) || Float.isNaN(height2)) continue;
            float x = (float)bounds2.getX();
            float y = (float)bounds2.getY();
            float p1x = x - (float)rootBounds.getX();
            float p1y = yMax - y + (float)rootBounds.getY();
            float p2x = x + width2 - (float)rootBounds.getX();
            float p2y = yMax - y + (float)rootBounds.getY();
            float p3x = x + width2 - (float)rootBounds.getX();
            float p3y = yMax - (y + height2) + (float)rootBounds.getY();
            float p4x = x - (float)rootBounds.getX();
            float p4y = yMax - (y + height2) + (float)rootBounds.getY();
            Appearance appearance = new Appearance();
            CPColor color = treeMapModel.getColor(node2);
            appearance.setMaterial((X3DMaterialNode)new Material().setDiffuseColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f));
            float size = 1.0f;
            if (!(field instanceof NoTreeMapField) && (value = field.getValue(node2)) != null) {
                size = ((Number)value).floatValue();
                float maxHeight = treeMapModel.getNumericMax(field).floatValue();
                size = size / maxHeight * ((float)treeMapModel.getSettings().getMaximumHeight() * min);
            }
            Box geometry = new Box();
            float halfWidth = (p2x - p1x) / 2.0f;
            float halfHeight = (p1y - p4y) / 2.0f;
            float halfSize = (size += 1.0f) / 2.0f;
            geometry.setSize(p2x - p1x, p1y - p4y, size);
            group.addChild((X3DChildNode)new Transform().setTranslation(p1x + halfWidth, p4y + halfHeight, 1.0f + halfSize).addChild((X3DChildNode)new Shape().setAppearance((X3DAppearanceNode)appearance).setGeometry((X3DGeometryNode)geometry)));
        }
        x3dModel.setHead(new head().addMeta(new meta().setName("title").setContent(((TreeMapDocument)contentProvider.getContent()).getDocumentState().getName())).addMeta(new meta().setName("creator").setContent("Macrofocus TreeMap"))).setScene(scene);
        x3dModel.setProfile("Interchange");
        this.save(x3dModel, file);
    }

    protected void save(X3D x3dModel, File file) {
        x3dModel.toFileX3D(file.getAbsolutePath());
    }
}

