/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.importer;

import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.common.file.FileType;
import com.macrofocus.common.file.JsonFileType;
import com.macrofocus.common.file.TreeMapFileType;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.data.source.TabDelimitedDataSource;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.CPImageFactory;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.igraphics.swing.SwingFont;
import com.macrofocus.igraphics.swing.SwingImageFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.dataframe.SingleSortKey;
import com.macrofocus.molap.dataframe.SortKey;
import com.macrofocus.molap.dataframe.SortOrder;
import com.macrofocus.molap.dataframe.WrappedDataFrame;
import com.macrofocus.molap.dataframe.swing.SwingDataFrameFactory;
import com.macrofocus.molap.exporter.java.SwingDataFrameExporter;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.app.document.TreeMapDocument;
import com.treemap.app.swing.document.SwingTreeMapApplication;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class Billionaires {
    private static final boolean DOWNLOAD = true;
    Map<String, String> countryContinent = new HashMap<String, String>();
    final String localStore = "/Users/luc/macrofocus/dataset/treemap/Forbes World's Billionaires 2018";

    public Billionaires() {
        MutableDataFrame dataFrame;
        String AFRICA = "Africa";
        String EUROPE = "Europe";
        String ASIA = "Asia";
        String NORTH_AMERICA = "North America";
        String SOUTH_AMERICA = "South America";
        String OCEANIA = "Oceania";
        this.countryContinent.put("Argentina", "South America");
        this.countryContinent.put("Australia", "Oceania");
        this.countryContinent.put("Austria", "Europe");
        this.countryContinent.put("Bahrain", "Asia");
        this.countryContinent.put("Belgium", "Europe");
        this.countryContinent.put("Bermuda", "North America");
        this.countryContinent.put("Brazil", "South America");
        this.countryContinent.put("Canada", "North America");
        this.countryContinent.put("Cayman Islands", "North America");
        this.countryContinent.put("Chile", "South America");
        this.countryContinent.put("China", "Asia");
        this.countryContinent.put("Colombia", "South America");
        this.countryContinent.put("Cyprus", "Europe");
        this.countryContinent.put("Czech Republic", "Europe");
        this.countryContinent.put("Denmark", "Europe");
        this.countryContinent.put("Egypt", "Africa");
        this.countryContinent.put("Finland", "Europe");
        this.countryContinent.put("France", "Europe");
        this.countryContinent.put("Germany", "Europe");
        this.countryContinent.put("Greece", "Europe");
        this.countryContinent.put("Hong Kong", "Asia");
        this.countryContinent.put("Hungary", "Europe");
        this.countryContinent.put("India", "Asia");
        this.countryContinent.put("Indonesia", "Asia");
        this.countryContinent.put("Ireland", "Europe");
        this.countryContinent.put("Israel", "Asia");
        this.countryContinent.put("Italy", "Europe");
        this.countryContinent.put("Japan", "Asia");
        this.countryContinent.put("Jordan", "Asia");
        this.countryContinent.put("Kazakhstan", "Asia");
        this.countryContinent.put("Kuwait", "Asia");
        this.countryContinent.put("Lebanon", "Asia");
        this.countryContinent.put("Luxembourg", "Europe");
        this.countryContinent.put("Malaysia", "Asia");
        this.countryContinent.put("Mauritius", "Africa");
        this.countryContinent.put("Mexico", "North America");
        this.countryContinent.put("Morocco", "Africa");
        this.countryContinent.put("Netherlands", "Europe");
        this.countryContinent.put("New Zealand", "Oceania");
        this.countryContinent.put("Nigeria", "Africa");
        this.countryContinent.put("Norway", "Europe");
        this.countryContinent.put("Oman", "Asia");
        this.countryContinent.put("Pakistan", "Asia");
        this.countryContinent.put("Peru", "South America");
        this.countryContinent.put("Philippines", "Asia");
        this.countryContinent.put("Poland", "Europe");
        this.countryContinent.put("Portugal", "Europe");
        this.countryContinent.put("Puerto Rico", "North America");
        this.countryContinent.put("Qatar", "Asia");
        this.countryContinent.put("Russia", "Asia");
        this.countryContinent.put("Saudi Arabia", "Asia");
        this.countryContinent.put("Singapore", "Asia");
        this.countryContinent.put("South Africa", "Africa");
        this.countryContinent.put("South Korea", "Asia");
        this.countryContinent.put("Spain", "Europe");
        this.countryContinent.put("Sweden", "Europe");
        this.countryContinent.put("Switzerland", "Europe");
        this.countryContinent.put("Taiwan", "Asia");
        this.countryContinent.put("Thailand", "Asia");
        this.countryContinent.put("Togo", "Africa");
        this.countryContinent.put("Turkey", "Europe");
        this.countryContinent.put("United Arab Emirates", "Asia");
        this.countryContinent.put("United Kingdom", "Europe");
        this.countryContinent.put("United States", "North America");
        this.countryContinent.put("Venezuela", "South America");
        this.countryContinent.put("Vietnam", "Asia");
        String ENERGY = "Energy";
        String MATERIALS = "Materials";
        String INDUSTRIALS = "Industrials";
        String CONSUMER_DISCRETIONARY = "Consumer Discretionary";
        String CONSUMER_STAPLES = "Consumer Staples";
        String HEALTH_CARE = "Health Care";
        String FINANCIALS = "Financials";
        String INFORMATION_TECHNOLOGY = "Information Technology";
        String TELECOMUNICATION_SERVICES = "Telecommunication Services";
        String UTILITIES = "Utilities";
        File tabDelimitedFile = new File("/Users/luc/macrofocus/dataset/treemap/Forbes World's Billionaires 2018.txt");
        File csvFile = new File("/Users/luc/macrofocus/dataset/treemap/Forbes World's Billionaires 2018.csv");
        try {
            System.setProperty("http.agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:40.0) Gecko/20100101 Firefox/40.1");
            URL url = new URL("https://www.forbes.com/ajax/list/data?year=2018&uri=billionaires&type=person");
            dataFrame = new DefaultDataFrame((DataFrame)SwingDataFrameFactory.getInstance().fromJSON(url), true);
            System.out.println("Original columns");
            for (String column : dataFrame.columns()) {
                System.out.println(column + ": " + dataFrame.getColumnClass((Object)column));
            }
            System.out.println("Successfully scrapped " + dataFrame.getRowCount() + " people");
            WrappedDataFrame derivedDataFrame = new WrappedDataFrame((DataFrame)dataFrame);
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"name", (Object)"Name")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"lastName", (Object)"Last Name")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"age", (Object)"Age")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"source", (Object)"Source")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"industry", (Object)"Industry")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"gender", (Object)"Gender")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DerivedColumn<Integer, String, Object>("Continent", String.class){

                public Object getValue(WrappedDataFrame<Integer, String, Object> dataFrame, Integer row) {
                    return Billionaires.this.countryContinent.get(dataFrame.getValueAt((Object)row, (Object)"Country"));
                }
            }});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"country", (Object)"Country")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"headquarters", (Object)"Headquarters")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"state", (Object)"State")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"rank", (Object)"Rank")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn<Integer, String, Object>((DataFrame)dataFrame, "worth", "Net Worth"){

                public Object getValue(WrappedDataFrame<Integer, String, Object> dataFrame, Integer row) {
                    Number value = (Number)super.getValue(dataFrame, (Object)row);
                    return value != null ? Double.valueOf(value.doubleValue() / 1000.0) : null;
                }
            }});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"title", (Object)"Title")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn<Integer, String, Object>((DataFrame)dataFrame, "uri", "Forbes Webpage"){

                public Object getValue(WrappedDataFrame<Integer, String, Object> dataFrame, Integer row) {
                    return "http://www.forbes.com/profile/" + super.getValue(dataFrame, (Object)row) + "/";
                }
            }});
            dataFrame = derivedDataFrame.orderRows(new SortKey[]{new SingleSortKey((Object)"Net Worth", SortOrder.DESCENDING)});
            SwingDataFrameExporter.exportCSV((DataFrame)dataFrame, (File)csvFile);
            SwingDataFrameExporter.exportTSV((DataFrame)dataFrame, (File)tabDelimitedFile);
            SwingDataFrameExporter.exportTSV((DataFrame)dataFrame, (File)tabDelimitedFile);
            SwingDataFrameExporter.exportExcel((DataFrame)dataFrame, (File)new File("/Users/luc/macrofocus/dataset/treemap/Forbes World's Billionaires 2018.xls"));
            SwingDataFrameExporter.exportJSON((DataFrame)dataFrame, (File)new File("/Users/luc/macrofocus/dataset/treemap/Forbes World's Billionaires 2018.json"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TabDelimitedDataSource dataSource = new TabDelimitedDataSource(tabDelimitedFile);
        try {
            dataFrame = dataSource.loadDataFrame(null);
            for (String s : dataFrame.columns()) {
                System.out.println(s + ": " + dataFrame.getColumnClass((Object)s));
            }
            File file = new File("/Users/luc/macrofocus/dataset/treemap/Forbes World's Billionaires 2018.mtm");
            TreeMapDocument document = new TreeMapDocument("Forbes World's Billionaires 2018", file.toURI().toURL().toExternalForm(), (DataFrame)dataFrame, null, (CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), (CPImageFactory)SwingImageFactory.getInstance());
            TreeMapModel treeMapModel = document.getTreeMapModel();
            TreeMapFieldSettings sector = treeMapModel.getSettings().getFieldSettings(treeMapModel.getTreeMapField((Object)"Sector"));
            TreeMapFieldSettings industry = treeMapModel.getSettings().getFieldSettings(treeMapModel.getTreeMapField((Object)"Industry"));
            industry.setHeaderFont((CPFont)new SwingFont("Tahoma", 1, 13));
            industry.setHeaderForeground((CPColor)new SwingColor(127, 127, 127));
            TreeMapFieldSettings continent = treeMapModel.getSettings().getFieldSettings(treeMapModel.getTreeMapField((Object)"Continent"));
            continent.setHeaderFont((CPFont)new SwingFont("Tahoma", 1, 13));
            continent.setHeaderForeground((CPColor)new SwingColor(127, 127, 127));
            TreeMapFieldSettings country = treeMapModel.getSettings().getFieldSettings(treeMapModel.getTreeMapField((Object)"Country"));
            country.setHeaderFont((CPFont)new SwingFont("Tahoma", 0, 11));
            country.setHeaderForeground((CPColor)new SwingColor(92, 92, 92));
            treeMapModel.getSettings().setGroupByByNames(new String[]{"Continent", "Country"});
            treeMapModel.getSettings().setSizeByName("Net Worth");
            treeMapModel.getSettings().setLabelsByNames(new String[]{"Last Name"});
            treeMapModel.getSettings().getFieldSettings(treeMapModel.getTreeMapField((Object)"Last Name")).getLabelingResizeTextToFitShapeProperty().setValue((Object)Boolean.TRUE);
            TreeMapFieldSettings gender = treeMapModel.getSettings().getFieldSettings(treeMapModel.getTreeMapField((Object)"Gender"));
            MutableColorMap genderColorMap = treeMapModel.getCategoricalColorMap((Object)"Gender");
            genderColorMap.setColor((Object)"F", (CPColor)new SwingColor(255, 153, 204));
            genderColorMap.setColor((Object)"M", (CPColor)new SwingColor(153, 204, 255));
            genderColorMap.setNullColor((CPColor)new SwingColor(153, 153, 153));
            gender.setColorMap(genderColorMap);
            treeMapModel.getSettings().setColorByName("Gender");
            treeMapModel.setFormatPattern(dataFrame.getColumnAddress((Object)"Net Worth"), "#,##0.00 $bil");
            for (int c = 0; c < treeMapModel.getDataFrame().getColumnCount(); ++c) {
                TreeMapField field = treeMapModel.getTreeMapField(c);
                treeMapModel.getSettings().setShowPopup(field, !field.getName().equals("Forbes Webpage") && !field.getName().equals("Rank"));
                treeMapModel.getSettings().getFieldSettings(field).setShowLabel(true);
            }
            SwingTreeMapApplication.saveDocument(document, file, (FileType)TreeMapFileType.getInstance());
            SwingTreeMapApplication.saveDocument(document, new File("/Users/luc/macrofocus/dataset/treemap/Forbes World's Billionaires 2018.json"), (FileType)JsonFileType.getInstance());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    String unescape(String s) {
        s = s.replace("%20", " ");
        s = StringEscapeUtils.unescapeHtml((String)s);
        return s;
    }

    Number toBillions(String s) {
        s = s.replace(",", "");
        if ((s = s.replace("$", "")).endsWith("B")) {
            if ((s = s.replace("B", "")).equals("- ")) {
                return null;
            }
            return Double.parseDouble(s);
        }
        if (s.endsWith("M")) {
            s = s.replace("M", "");
            return new BigDecimal(Double.parseDouble(s)).divide(new BigDecimal(1000), 4, 4).doubleValue();
        }
        return null;
    }

    public static void main(String[] args) {
        new Billionaires();
    }
}

