/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.presentation.implementation.treedee;

import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;
import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.media.j3d.Transform3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;

public class EyeMouseRotate
extends MouseBehavior {
    private double verticalAngle;
    private double horizontalAngle;
    private double verticalAngleAbs;
    private double horizontalAngleAbs;
    private double preRotationAngle;
    private double x_factor = 0.03;
    private double y_factor = 0.03;
    private boolean rotateHorizontal = false;
    private static int BUFFER_SIZE = 10;
    private int[] dBufferX = new int[BUFFER_SIZE];
    private int[] dBufferY = new int[BUFFER_SIZE];
    private int dBufferIndex = 0;
    private MouseBehaviorCallback callback = null;

    public EyeMouseRotate() {
        super(0);
    }

    public EyeMouseRotate(double preRotationAngle) {
        super(0);
        this.preRotationAngle = preRotationAngle;
    }

    public void initialize() {
        super.initialize();
        this.verticalAngle = 0.0;
        this.horizontalAngle = 0.0;
        this.verticalAngleAbs = this.preRotationAngle;
        this.horizontalAngleAbs = 0.0;
        if ((this.flags & 2) == 2) {
            this.invert = true;
            this.x_factor *= -1.0;
            this.y_factor *= -1.0;
        }
    }

    public double getXFactor() {
        return this.x_factor;
    }

    public double getYFactor() {
        return this.y_factor;
    }

    public void setFactor(double factor) {
        this.x_factor = this.y_factor = factor;
    }

    public void setFactor(double xFactor, double yFactor) {
        this.x_factor = xFactor;
        this.y_factor = yFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration criteria) {
        block3: while (criteria.hasMoreElements()) {
            MouseEvent evt;
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (wakeup instanceof WakeupOnAWTEvent) {
                AWTEvent[] events = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
                if (events.length <= 0) continue;
                evt = (MouseEvent)events[events.length - 1];
                this.doProcess(evt);
                continue;
            }
            if (!(wakeup instanceof WakeupOnBehaviorPost)) continue;
            while (true) {
                LinkedList linkedList = this.mouseq;
                synchronized (linkedList) {
                    if (this.mouseq.isEmpty()) {
                        continue block3;
                    }
                    evt = (MouseEvent)this.mouseq.remove(0);
                    while (evt.getID() == 506 && !this.mouseq.isEmpty() && ((MouseEvent)this.mouseq.get(0)).getID() == 506) {
                        evt = (MouseEvent)this.mouseq.remove(0);
                    }
                }
                this.doProcess(evt);
            }
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    void doProcess(MouseEvent evt) {
        this.processMouseEvent(evt);
        if (this.buttonPress && (this.flags & 1) == 0 || this.wakeUp && (this.flags & 1) != 0) {
            int id = evt.getID();
            if (id == 506 && !evt.isMetaDown() && !evt.isAltDown()) {
                this.x = evt.getX();
                this.y = evt.getY();
                int dx = this.x - this.x_last;
                int dy = this.y - this.y_last;
                this.dBufferX[this.dBufferIndex] = Math.abs(dx);
                this.dBufferY[this.dBufferIndex] = Math.abs(dy);
                ++this.dBufferIndex;
                if (this.dBufferIndex >= BUFFER_SIZE) {
                    this.dBufferIndex = 0;
                }
                int dx_sum = 0;
                int dy_sum = 0;
                for (int i1 : this.dBufferX) {
                    dx_sum += i1;
                }
                for (int i1 : this.dBufferY) {
                    dy_sum += i1;
                }
                if (this.rotateHorizontal) {
                    if (dy_sum > dx_sum) {
                        this.rotateHorizontal = false;
                    }
                } else if (dx_sum > dy_sum) {
                    this.rotateHorizontal = true;
                }
                if (!this.reset) {
                    if (this.rotateHorizontal) {
                        this.horizontalAngle = (double)dx * this.x_factor;
                        this.horizontalAngleAbs += this.horizontalAngle;
                    } else {
                        this.verticalAngle = (double)dy * this.y_factor;
                        this.verticalAngleAbs += this.verticalAngle;
                        this.verticalAngleAbs = Math.min(this.verticalAngleAbs, 1.5550883635269477);
                        this.verticalAngleAbs = Math.max(this.verticalAngleAbs, 0.0);
                    }
                    this.currXform.setIdentity();
                    this.transformX.rotX(this.verticalAngleAbs);
                    this.currXform.mul(this.currXform, this.transformX);
                    this.transformY.rotY(this.horizontalAngleAbs);
                    this.currXform.mul(this.currXform, this.transformY);
                    this.transformGroup.setTransform(this.currXform);
                    this.transformChanged(this.currXform);
                    if (this.callback != null) {
                        this.callback.transformChanged(0, this.currXform);
                    }
                } else {
                    this.reset = false;
                }
                this.x_last = this.x;
                this.y_last = this.y;
            } else if (id == 501) {
                this.x_last = evt.getX();
                this.y_last = evt.getY();
            }
        }
    }

    public void transformChanged(Transform3D transform) {
    }

    public void setupCallback(MouseBehaviorCallback callback) {
        this.callback = callback;
    }
}

