/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.presentation.implementation.treedee;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.awt.TextRenderer;
import com.macrofocus.geom.Rectangle2D;
import com.treemap.NoTreeMapField;
import com.treemap.ThreeDTreeMapView;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import com.treemap.app.swing.presentation.implementation.treedee.ThreeDeeListener;
import com.treemap.app.swing.presentation.implementation.treedee.TreeDeeModel;
import com.treemap.app.swing.presentation.implementation.treedee.TreeDeeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public class OpenGLPanel2<N, Row, Column>
extends GLJPanel
implements TreeDeeView<N, Row, Column>,
ThreeDTreeMapView<N, Row, Column, Color, Font, JComponent> {
    private boolean _showTiming = false;
    private static float FLOOR_SIZE = 10.0f;
    private static float EYE_DISTANCE_FACTOR = 2.0f;
    private static float FIELD_OF_VIEW = 50.0f;
    private static float Z_NEAR = 1.0f;
    private static float Z_FAR = 100.0f;
    private static float DEFAULT_HEIGHT = 1.0f;
    private static float HEIGHT_ASPECT_RATIO = 0.5f;
    private static float PRE_ROTATION_ANGLE = -60.0f;
    private static float X_ROTATION_FACTOR = 1.0f;
    private static float Y_ROTATION_FACTOR = 1.0f;
    private float verticalAngle = PRE_ROTATION_ANGLE;
    private float horizontalAngle = 0.0f;
    private float cameraDistance = FLOOR_SIZE * EYE_DISTANCE_FACTOR;
    private boolean cameraDistanceChanged = false;
    private int x_last;
    private int y_last;
    private GLU glu = new GLU();
    private GL2 gl2;
    private TreeDeeModel<N, Row, Column> treeDeeModel;
    private Map<Integer, N> nodeIndexMap;
    private Map<N, Integer> nodeMap;
    private int pickX;
    private int pickY;
    private boolean handlePick = false;
    private TextRenderer renderer;
    private final int fontSize = 16;
    private Projection perspectiveMode = Projection.Perspective;

    public OpenGLPanel2() {
        this(OpenGLPanel2.createCapabilities());
    }

    private static GLCapabilities createCapabilities() {
        GLProfile glprofile = GLProfile.getDefault();
        GLCapabilities glcapabilities = new GLCapabilities(glprofile);
        glcapabilities.setAlphaBits(8);
        glcapabilities.setSampleBuffers(true);
        glcapabilities.setNumSamples(4);
        glcapabilities.setAccumAlphaBits(16);
        glcapabilities.setAccumBlueBits(16);
        glcapabilities.setAccumGreenBits(16);
        glcapabilities.setAccumRedBits(16);
        return glcapabilities;
    }

    public OpenGLPanel2(GLCapabilities capabilities) {
        super((GLCapabilitiesImmutable)capabilities);
        this.addGLEventListener(new GLEventListener(){

            public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
                OpenGLPanel2.this.setupProjection(drawable.getGL().getGL2());
            }

            public void init(GLAutoDrawable drawable) {
                OpenGLPanel2.this.initRendering(drawable.getGL().getGL2());
            }

            public void dispose(GLAutoDrawable drawable) {
            }

            public void display(GLAutoDrawable drawable) {
                if (OpenGLPanel2.this.handlePick) {
                    Object node = OpenGLPanel2.this.getNodeAt(OpenGLPanel2.this.pickX, OpenGLPanel2.this.pickY);
                    OpenGLPanel2.this.treeDeeModel.getTreeMapModel().getProbing().setSelected(node);
                    OpenGLPanel2.this.handlePick = false;
                }
                OpenGLPanel2.this.render(drawable.getGL().getGL2());
            }
        });
        this.defineNavigation();
        this.treeDeeModel = new TreeDeeModel();
        this.treeDeeModel.addListener(new ThreeDeeListener(){

            @Override
            public void modelChanged() {
                OpenGLPanel2.this.nodeIndexMap = new HashMap();
                OpenGLPanel2.this.nodeMap = new HashMap();
                TreeMapModel treeMapModel = OpenGLPanel2.this.treeDeeModel.getTreeMapModel();
                if (treeMapModel != null) {
                    Object rootNode = treeMapModel.getRoot();
                    int i = 0;
                    if (rootNode != null) {
                        for (Object node : treeMapModel.preorderEnumeration(rootNode)) {
                            OpenGLPanel2.this.nodeIndexMap.put(i, node);
                            OpenGLPanel2.this.nodeMap.put(node, i);
                            ++i;
                        }
                    }
                }
                OpenGLPanel2.this.repaint();
            }
        });
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setModel(TreeMapModel<N, Row, Column, Color, Font> treeMapModel) {
        this.treeDeeModel.setTreeMapModel(treeMapModel);
    }

    private void setupProjection(GL2 gl2) {
        double alpha = 45.0;
        double[] cavalier = new double[]{1.0, 0.0, -1.0 * Math.cos(Math.toRadians(alpha)), 0.0, 0.0, 1.0, Math.sin(Math.toRadians(alpha)), 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        gl2.glMatrixMode(5889);
        gl2.glLoadIdentity();
        float aspectRatio = (float)this.getWidth() / (float)this.getHeight();
        float halfExtentWidth = 1.5f * FLOOR_SIZE / 2.0f;
        float halfExtentHeight = 1.5f * (halfExtentWidth / aspectRatio);
        switch (this.perspectiveMode) {
            case Perspective: {
                this.glu.gluPerspective(FIELD_OF_VIEW, aspectRatio, Z_NEAR, Z_FAR);
                this.glu.gluLookAt(0.0f, 0.0f, this.cameraDistance, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
                break;
            }
            case Orthographic: {
                gl2.glOrthof(-halfExtentWidth, halfExtentWidth, -halfExtentHeight, halfExtentHeight, -100.0f, 100.0f);
                break;
            }
            case PerspectiveCavalier: {
                this.glu.gluPerspective(90.0f, aspectRatio, 1.0f, 100000.0f);
                this.glu.gluLookAt((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), 400.0f, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2), 0.0f, 0.0f, 1.0f, 0.0f);
                gl2.glMultTransposeMatrixd(cavalier, 0);
                break;
            }
            case OrthographicCavalier: {
                gl2.glOrthof(-halfExtentWidth, halfExtentWidth, -halfExtentHeight, halfExtentHeight, -100.0f, 100.0f);
                gl2.glMultTransposeMatrixd(cavalier, 0);
            }
        }
    }

    private void initRendering(GL2 gl2) {
        this.gl2 = gl2;
        this.renderer = new TextRenderer(new Font("SansSerif", 0, 16));
        gl2.glEnable(2929);
        gl2.glFrontFace(2305);
        gl2.glEnable(2884);
        gl2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        float[] args = new float[]{-1.0f, 0.0f, 1.0f, 0.0f};
        gl2.glLightfv(16384, 4611, args, 0);
        args[0] = 1.0f;
        args[1] = 1.0f;
        args[2] = 1.0f;
        args[3] = 1.0f;
        gl2.glLightfv(16384, 4609, args, 0);
        gl2.glLightfv(16384, 4610, args, 0);
        gl2.glEnable(16384);
        args[0] = 1.0f;
        args[1] = 0.0f;
        args[2] = 1.0f;
        args[3] = 0.0f;
        gl2.glLightfv(16385, 4611, args, 0);
        args[0] = 0.3f;
        args[1] = 0.3f;
        args[2] = 0.3f;
        args[3] = 0.3f;
        gl2.glLightfv(16385, 4609, args, 0);
        gl2.glLightfv(16385, 4610, args, 0);
        gl2.glEnable(16385);
        gl2.glEnable(2896);
        gl2.glEnable(2903);
        gl2.glColorMaterial(1032, 5634);
        gl2.glEnable(2977);
        gl2.glEnable(32925);
        gl2.glShadeModel(7425);
        gl2.glHint(3153, 4354);
        gl2.glHint(3154, 4354);
        gl2.glHint(3155, 4354);
        gl2.glHint(3152, 4354);
    }

    private void render(GL2 gl2) {
        Rectangle2D rootBounds;
        Object rootNode;
        if (this.cameraDistanceChanged) {
            this.setupProjection(gl2);
            this.cameraDistanceChanged = false;
        }
        gl2.glMatrixMode(5888);
        gl2.glLoadIdentity();
        TreeMapModel<N, Row, Column, Color, Font> treeMapModel = this.treeDeeModel.getTreeMapModel();
        if (treeMapModel != null && (rootNode = treeMapModel.getRoot()) != null && (rootBounds = treeMapModel.getBounds(rootNode)) != null) {
            float verticalScalingFactor;
            gl2.glClear(16640);
            gl2.glLoadIdentity();
            float rootWidth = (float)rootBounds.getWidth();
            float rootHeight = (float)rootBounds.getHeight();
            float lateralScalingFactor = FLOOR_SIZE / Math.max(rootWidth, rootHeight);
            TreeMapField field = (TreeMapField)treeMapModel.getSettings().getHeightVariableSelection().getSelected();
            if (field instanceof NoTreeMapField) {
                verticalScalingFactor = 0.0f;
            } else {
                float maxHeight = treeMapModel.getNumericMax(field).floatValue();
                verticalScalingFactor = 1.0f / maxHeight * FLOOR_SIZE * ((float)treeMapModel.getSettings().getMaximumHeight() * 2.0f);
            }
            gl2.glRotatef(this.horizontalAngle, 0.0f, 1.0f, 0.0f);
            gl2.glRotatef(this.verticalAngle, 1.0f, 0.0f, 0.0f);
            gl2.glScalef(lateralScalingFactor, lateralScalingFactor, verticalScalingFactor);
            gl2.glTranslatef(-rootWidth / 2.0f, -rootHeight / 2.0f, 0.0f);
            this.drawBoxes(gl2, treeMapModel);
        }
    }

    private void drawBoxes(GL2 gl2, TreeMapModel<N, Row, Column, Color, ?> treeMapModel) {
        Object rootNode = treeMapModel.getRoot();
        Rectangle2D rootBounds = treeMapModel.getBounds(rootNode);
        float xMax = (float)rootBounds.getWidth();
        float yMax = (float)rootBounds.getHeight();
        TreeMapField field = (TreeMapField)treeMapModel.getSettings().getHeightVariableSelection().getSelected();
        for (Object node : treeMapModel.preorderEnumeration(rootNode)) {
            String text;
            Rectangle2D bounds = treeMapModel.getBounds(node);
            if (bounds == null) continue;
            float width = (float)bounds.getWidth();
            float height = (float)bounds.getHeight();
            float x = (float)bounds.getX();
            float y = (float)bounds.getY();
            if (treeMapModel.hasNoChildren(node)) {
                Color colorBase;
                Color colorTop;
                Object value;
                gl2.glPushName(this.nodeMap.get(node).intValue());
                float size = DEFAULT_HEIGHT;
                if (!(field instanceof NoTreeMapField) && (value = field.getValue(node)) != null) {
                    size = ((Number)value).floatValue();
                }
                float p1x = x;
                float p1y = yMax - y;
                float p2x = x + width;
                float p2y = yMax - y;
                float p3x = x + width;
                float p3y = yMax - (y + height);
                float p4x = x;
                float p4y = yMax - (y + height);
                if (treeMapModel.getProbing().getSelected() == node) {
                    colorTop = Color.yellow;
                    colorBase = Color.yellow;
                } else {
                    colorTop = (Color)treeMapModel.getColor(node).getNativeColor();
                    colorBase = Color.gray;
                }
                gl2.glNormal3f(0.0f, 0.0f, 1.0f);
                gl2.glColor3f((float)colorTop.getRed() / 255.0f, (float)colorTop.getGreen() / 255.0f, (float)colorTop.getBlue() / 255.0f);
                gl2.glBegin(7);
                gl2.glVertex3f(p4x, p4y, size);
                gl2.glVertex3f(p3x, p3y, size);
                gl2.glVertex3f(p2x, p2y, size);
                gl2.glVertex3f(p1x, p1y, size);
                gl2.glEnd();
                gl2.glColor3f((float)colorBase.getRed() / 255.0f, (float)colorBase.getGreen() / 255.0f, (float)colorBase.getBlue() / 255.0f);
                gl2.glNormal3f(-1.0f, 0.0f, 0.0f);
                gl2.glBegin(7);
                gl2.glVertex3f(p1x, p1y, 0.0f);
                gl2.glVertex3f(p4x, p4y, 0.0f);
                gl2.glVertex3f(p4x, p4y, size);
                gl2.glVertex3f(p1x, p1y, size);
                gl2.glEnd();
                gl2.glNormal3f(1.0f, 0.0f, 0.0f);
                gl2.glBegin(7);
                gl2.glVertex3f(p3x, p3y, 0.0f);
                gl2.glVertex3f(p2x, p2y, 0.0f);
                gl2.glVertex3f(p2x, p2y, size);
                gl2.glVertex3f(p3x, p3y, size);
                gl2.glEnd();
                gl2.glNormal3f(0.0f, 1.0f, 0.0f);
                gl2.glBegin(7);
                gl2.glVertex3f(p2x, p2y, 0.0f);
                gl2.glVertex3f(p1x, p1y, 0.0f);
                gl2.glVertex3f(p1x, p1y, size);
                gl2.glVertex3f(p2x, p2y, size);
                gl2.glEnd();
                gl2.glNormal3f(0.0f, -1.0f, 0.0f);
                gl2.glBegin(7);
                gl2.glVertex3f(p4x, p4y, 0.0f);
                gl2.glVertex3f(p3x, p3y, 0.0f);
                gl2.glVertex3f(p3x, p3y, size);
                gl2.glVertex3f(p4x, p4y, size);
                gl2.glEnd();
                gl2.glNormal3f(0.0f, 0.0f, -1.0f);
                gl2.glBegin(7);
                gl2.glVertex3f(p1x, p1y, 0.0f);
                gl2.glVertex3f(p2x, p2y, 0.0f);
                gl2.glVertex3f(p3x, p3y, 0.0f);
                gl2.glVertex3f(p4x, p4y, 0.0f);
                gl2.glEnd();
                gl2.glPopName();
                continue;
            }
            if (treeMapModel.isRoot(node) || (text = node.toString()) == null || text.length() <= 0 || !(16.0 <= (double)height * 0.2)) continue;
            this.renderer.begin3DRendering();
            this.renderer.setColor(Color.lightGray);
            this.renderer.draw3D(text, (float)((int)x), (float)((int)(yMax - y - 16.0f)), 0.0f, 1.0f);
            this.renderer.end3DRendering();
        }
    }

    private void defineNavigation() {
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 38: {
                        OpenGLPanel2.this.verticalAngle -= Y_ROTATION_FACTOR;
                        break;
                    }
                    case 40: {
                        OpenGLPanel2.this.verticalAngle += Y_ROTATION_FACTOR;
                        break;
                    }
                    case 37: {
                        OpenGLPanel2.this.horizontalAngle -= X_ROTATION_FACTOR;
                        break;
                    }
                    case 39: {
                        OpenGLPanel2.this.horizontalAngle += X_ROTATION_FACTOR;
                    }
                }
                OpenGLPanel2.this.repaint();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                OpenGLPanel2.this.x_last = e.getX();
                OpenGLPanel2.this.y_last = e.getY();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                OpenGLPanel2.this.pickX = e.getX();
                OpenGLPanel2.this.pickY = OpenGLPanel2.this.getHeight() - e.getY();
                OpenGLPanel2.this.handlePick = true;
                OpenGLPanel2.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int dx = e.getX() - OpenGLPanel2.this.x_last;
                int dy = e.getY() - OpenGLPanel2.this.y_last;
                float dHorizontalAngle = (float)dx * X_ROTATION_FACTOR;
                float dVerticalAngle = (float)dy * Y_ROTATION_FACTOR;
                OpenGLPanel2.this.horizontalAngle += dHorizontalAngle;
                OpenGLPanel2.this.verticalAngle += dVerticalAngle;
                OpenGLPanel2.this.verticalAngle = Math.max(OpenGLPanel2.this.verticalAngle, -90.0f);
                OpenGLPanel2.this.verticalAngle = Math.min(OpenGLPanel2.this.verticalAngle, 0.0f);
                OpenGLPanel2.this.x_last = e.getX();
                OpenGLPanel2.this.y_last = e.getY();
                OpenGLPanel2.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                OpenGLPanel2.this.pickX = e.getX();
                OpenGLPanel2.this.pickY = OpenGLPanel2.this.getHeight() - e.getY();
                OpenGLPanel2.this.handlePick = true;
                OpenGLPanel2.this.repaint();
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                int amount = event.getWheelRotation();
                double zoomSensitivity = 0.01;
                double zoomFactor = 1.0 + (double)amount * zoomSensitivity;
                OpenGLPanel2.this.cameraDistance = (float)((double)OpenGLPanel2.this.cameraDistance * zoomFactor);
                OpenGLPanel2.this.cameraDistance = Math.min(OpenGLPanel2.this.cameraDistance, FLOOR_SIZE * EYE_DISTANCE_FACTOR);
                OpenGLPanel2.this.cameraDistance = Math.max(OpenGLPanel2.this.cameraDistance, FLOOR_SIZE);
                OpenGLPanel2.this.cameraDistanceChanged = true;
                OpenGLPanel2.this.repaint();
            }
        });
    }

    private N getNodeAt(int x, int y) {
        int[] selectBuffer = new int[this.nodeMap.size() * 4];
        this.gl2.glSelectBuffer(selectBuffer.length, Buffers.newDirectIntBuffer((int[])selectBuffer));
        int[] viewport = new int[4];
        this.gl2.glGetIntegerv(2978, viewport, 0);
        this.gl2.glRenderMode(7170);
        this.gl2.glInitNames();
        this.gl2.glMatrixMode(5889);
        this.gl2.glPushMatrix();
        this.gl2.glLoadIdentity();
        this.glu.gluPickMatrix((float)x, (float)y, 1.0f, 1.0f, viewport, 0);
        float aspectRatio = (float)this.getWidth() / (float)this.getHeight();
        this.glu.gluPerspective(FIELD_OF_VIEW, aspectRatio, Z_NEAR, Z_FAR);
        this.glu.gluLookAt(0.0f, 0.0f, this.cameraDistance, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.gl2.glMatrixMode(5888);
        this.render(this.gl2);
        this.gl2.glMatrixMode(5889);
        this.gl2.glPopMatrix();
        this.gl2.glMatrixMode(5888);
        this.gl2.glFlush();
        int hits = this.gl2.glRenderMode(7168);
        return this.getClosestHit(hits, selectBuffer);
    }

    private N getClosestHit(int hits, int[] selectBuffer) {
        long minDistance = Long.MAX_VALUE;
        int closestName = -1;
        for (int i = 0; i < hits; ++i) {
            long min = (long)selectBuffer[i * 4 + 1] & 0xFFFFFFFFL;
            int name = selectBuffer[i * 4 + 3];
            if (min >= minDistance) continue;
            minDistance = min;
            closestName = name;
        }
        N node = this.nodeIndexMap.get(closestName);
        return node;
    }

    public void paint(Graphics g) {
        long current = System.currentTimeMillis();
        super.paint(g);
        if (this._showTiming) {
            g.setColor(Color.red);
            String str = System.currentTimeMillis() - current + " milliseconds";
            g.drawString(str, 5, this.getSize().height - 5);
            System.out.println(str);
        }
    }

    public void setStyleClass(String ... styleClasses) {
    }

    public JComponent getNativeComponent() {
        return this;
    }

    static enum Projection {
        Perspective,
        Orthographic,
        PerspectiveCavalier,
        OrthographicCavalier;

    }
}

