/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.v4.action;

import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.resources.ResourcesModel;
import com.treemap.TreeMapModel;
import com.treemap.swing.SwingTreeMapView;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class DrillUpAction<N, Row, Column>
extends AbstractAction {
    private final SwingTreeMapView<N, Row, Column> view;

    public DrillUpAction(SwingTreeMapView<N, Row, Column> view) {
        this(view, null);
    }

    private DrillUpAction(SwingTreeMapView<N, Row, Column> view, ResourcesModel resourcesModel) {
        super("Drill Up");
        URL url;
        this.view = view;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 0));
        if (resourcesModel != null && (url = resourcesModel.getUrl("Up16.gif")) != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeMapModel model = this.view.getModel();
        model.getProbing().clearSelection();
        if (!model.isRoot(model.getCurrentRoot())) {
            MutableBoundedInterval xRange = this.view.getXRangeModel();
            MutableBoundedInterval yRange = this.view.getYRangeModel();
            this.view.zoom(false, xRange.getMinimum(), xRange.getMaximum(), yRange.getMinimum(), yRange.getMaximum());
            Object root = model.getParent(model.getCurrentRoot());
            model.setCurrentRoot(root);
        }
    }
}

