/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.v4.settings.algorithm;

import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.AbstractAlgorithm;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapWorker;
import java.awt.Dimension;

public class QuantumAlgorithm
extends AbstractAlgorithm {
    public static final int INDEX_BY_MIDDLE = 1;
    public static final int INDEX_BY_SPLIT_SIZE = 2;
    public static final int INDEX_BY_BIGGEST = 3;
    public static final double EXPECTED_WASTE_FACTOR = 1.15;
    public static boolean debug = true;
    public static boolean squarified = true;
    protected int indexType = 1;
    protected int[] origSizes;
    protected Rectangle origBox;
    protected double origiar;
    protected int numQuadLayouts;
    protected int numSnake3Layouts;
    protected int numSnake4Layouts;
    protected int numSnake5Layouts;
    protected Rectangle[] resultRects = null;
    boolean debugBoxEvening = false;

    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        Rectangle2D bounds = shape.getBounds2D();
        int[] sizes = new int[children.length];
        for (int i = 0; i < children.length; ++i) {
            MutableTreeMapNode area = children[i];
            sizes[i] = (int)area.getSize();
        }
        this.origSizes = sizes;
        this.origiar = 1.0;
        this.origBox = new Rectangle((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        Rectangle[] rectangles = this.quantumLayout();
        for (int i = 0; i < rectangles.length; ++i) {
            Rectangle rectangle = rectangles[i];
            children[i].setShape((Shape)rectangle);
        }
        return false;
    }

    public Rectangle[] quantumLayout() {
        this.numQuadLayouts = 0;
        this.numSnake3Layouts = 0;
        this.numSnake4Layouts = 0;
        this.numSnake5Layouts = 0;
        int area = this.computeSize(this.origSizes);
        area = (int)((double)area * 1.15);
        double ar = this.computeAspectRatio(this.origBox) / this.origiar;
        int h = (int)Math.ceil(Math.sqrt((double)area / ar));
        int w = (int)Math.ceil((double)area / (double)h);
        Rectangle box = new Rectangle(this.origBox.x, this.origBox.y, w, h);
        QuantumAlgorithm.debugPrintln("Orig box = " + this.origBox + ", Image AR = " + this.origiar);
        double boxAR = this.computeAspectRatio(box);
        boolean growWide = boxAR >= 1.0;
        this.resultRects = this.quantumLayout(this.origSizes, box, growWide);
        return this.resultRects;
    }

    public Rectangle[] getResult() {
        return this.resultRects;
    }

    public Rectangle getResultBox() {
        return this.computeUnion(this.resultRects);
    }

    public void printStatistics() {
        if (this.resultRects == null) {
            System.out.println("Layout hasn't been computed yet");
        } else {
            System.out.print("Sizes: ");
            for (int i = 0; i < this.origSizes.length; ++i) {
                System.out.print(this.origSizes[i] + " ");
            }
            System.out.println();
            System.out.println("Requested Box = " + this.origBox);
            System.out.println("Final Box = " + this.computeUnion(this.resultRects));
            System.out.println("Average aspect ratio: " + this.getAverageAspectRatio());
            System.out.println("Wasted Space: " + this.getWastedSpace() + "%");
        }
    }

    public double getAverageAspectRatio() {
        double aar = 0.0;
        if (this.resultRects == null) {
            System.out.println("Layout hasn't been computed yet");
        } else {
            aar = this.computeAverageAspectRatio(this.resultRects);
        }
        return aar;
    }

    public double getWastedSpace() {
        double wastedSpace = 0.0;
        if (this.resultRects == null) {
            System.out.println("Layout hasn't been computed yet");
        } else {
            double origAR;
            Rectangle finalBox = this.computeUnion(this.resultRects);
            double ar = this.computeAspectRatio(finalBox);
            if (ar > (origAR = this.computeAspectRatio(this.origBox) / this.origiar)) {
                int newHeight;
                finalBox.height = newHeight = (int)((double)finalBox.width / origAR);
            } else {
                int newWidth;
                finalBox.width = newWidth = (int)((double)finalBox.height * origAR);
            }
            double totalArea = this.computeArea(finalBox);
            double usedArea = this.computeSize(this.origSizes);
            wastedSpace = 100.0 * (totalArea - usedArea) / totalArea;
        }
        return wastedSpace;
    }

    public static Dimension layoutElements(int numElements, double ar) {
        int c1 = (int)Math.floor(Math.sqrt((double)numElements * ar));
        if (c1 == 0) {
            c1 = 1;
        }
        int r1 = (int)Math.ceil((double)numElements / (double)c1);
        double ar1 = (double)c1 / (double)r1;
        int c2 = (int)Math.ceil(Math.sqrt((double)numElements * ar));
        if (c2 == 0) {
            c2 = 1;
        }
        int r2 = (int)Math.ceil((double)numElements / (double)c2);
        double ar2 = (double)c2 / (double)r2;
        Dimension dim = Math.max(ar1 / ar, ar / ar1) > Math.max(ar2 / ar, ar / ar2) ? new Dimension(c2, r2) : new Dimension(c1, r1);
        return dim;
    }

    protected Rectangle[] quantumLayout(int[] sizes, Rectangle box, boolean growWide) {
        boolean newGrowWide;
        Rectangle box2;
        int i;
        int[] l1 = null;
        int[] l2 = null;
        int[] l3 = null;
        int l1Size = 0;
        int l2Size = 0;
        int l3Size = 0;
        Rectangle r1 = null;
        Rectangle r2 = null;
        Rectangle r3 = null;
        Rectangle rp = null;
        Rectangle[] boxes = null;
        Dimension dim1 = null;
        Dimension dim2 = null;
        Dimension dim3 = null;
        Rectangle l1finalbox = null;
        Rectangle l2finalbox = null;
        Rectangle[] l1boxes = null;
        Rectangle[] l2boxes = null;
        Rectangle[] l3boxes = null;
        int numBoxes = 0;
        int pivotIndex = this.computePivotIndex(sizes);
        int pivotSize = sizes[pivotIndex];
        double boxAR = this.computeAspectRatio(box);
        QuantumAlgorithm.debugPrintln("Items=" + sizes.length + ", box=" + box + ", pivotIndex = " + pivotIndex);
        QuantumAlgorithm.debugPrint("Sizes: ");
        for (i = 0; i < sizes.length; ++i) {
            QuantumAlgorithm.debugPrint(sizes[i] + " ");
        }
        QuantumAlgorithm.debugPrintln("");
        if (sizes.length == 1) {
            boxes = new Rectangle[]{box};
            QuantumAlgorithm.debugPrintln("Stop 1: box = " + box);
            return boxes;
        }
        if (sizes.length == 2) {
            boxes = new Rectangle[2];
            double ratio = (double)sizes[0] / (double)(sizes[0] + sizes[1]);
            if (growWide) {
                dim1 = this.computeTableLayout(sizes[0], boxAR * ratio);
                dim2 = this.computeTableLayout(sizes[1], boxAR * (1.0 - ratio));
                int h = Math.max(dim1.height, dim2.height);
                dim2 = this.computeTableLayoutGivenHeight(sizes[1], h);
                boxes[0] = new Rectangle(box.x, box.y, dim1.width, h);
                boxes[1] = new Rectangle(box.x + dim1.width, box.y, dim2.width, dim2.height);
            } else {
                dim1 = this.computeTableLayout(sizes[0], boxAR / ratio);
                dim2 = this.computeTableLayout(sizes[1], boxAR / (1.0 - ratio));
                int w = Math.max(dim1.width, dim2.width);
                dim2 = this.computeTableLayoutGivenWidth(sizes[1], w);
                boxes[0] = new Rectangle(box.x, box.y, w, dim1.height);
                boxes[1] = new Rectangle(box.x, box.y + dim1.height, dim2.width, dim2.height);
            }
            QuantumAlgorithm.debugPrintln("Stop 2: box[0] = " + boxes[0]);
            QuantumAlgorithm.debugPrintln("Stop 2: box[1] = " + boxes[1]);
            return boxes;
        }
        if (pivotIndex > 0) {
            l1 = new int[pivotIndex];
            System.arraycopy(sizes, 0, l1, 0, pivotIndex);
            l1Size = this.computeSize(l1);
            int b2Size = this.computeSize(sizes, pivotIndex, sizes.length - 1);
            if (growWide) {
                dim1 = this.computeTableLayoutGivenHeight(l1Size, box.height);
                dim2 = this.computeTableLayoutGivenHeight(b2Size, box.height);
                r1 = new Rectangle(box.x, box.y, dim1.width, dim1.height);
                box2 = new Rectangle(box.x + dim1.width, box.y, dim2.width, dim2.height);
            } else {
                dim1 = this.computeTableLayoutGivenWidth(l1Size, box.width);
                dim2 = this.computeTableLayoutGivenWidth(b2Size, box.width);
                r1 = new Rectangle(box.x, box.y, dim1.width, dim1.height);
                box2 = new Rectangle(box.x, box.y + dim1.height, dim2.width, dim2.height);
            }
        } else {
            box2 = new Rectangle(box.x, box.y, box.width, box.height);
        }
        QuantumAlgorithm.debugPrintln("r1 = " + r1);
        if (l1 != null) {
            if (l1.length > 1) {
                QuantumAlgorithm.debugPrintln("Recurse on R1");
                double r1AR = this.computeAspectRatio(r1);
                newGrowWide = r1AR == 1.0 ? growWide : r1AR >= 1.0;
                l1boxes = this.quantumLayout(l1, r1, newGrowWide);
            } else {
                l1boxes = new Rectangle[]{r1};
            }
            l1finalbox = this.computeUnion(l1boxes);
            if (growWide) {
                box2.height = r1.height;
            } else {
                box2.width = r1.width;
            }
            QuantumAlgorithm.debugPrintln("Final R1 Box = " + l1finalbox + ", Orig R1 Box = " + r1);
            QuantumAlgorithm.debugPrintln("box2 = " + box2);
        }
        double box2AR = this.computeAspectRatio(box2);
        boolean first = true;
        double bestAR = 0.0;
        Dimension bestdim1 = null;
        int bestl2Size = 0;
        boolean bestl3Size = false;
        int bestIndex = 0;
        for (i = pivotIndex + 1; i < sizes.length; ++i) {
            l2Size = this.computeSize(sizes, pivotIndex + 1, i);
            double ratio = (double)pivotSize / (double)(pivotSize + l2Size);
            if (growWide) {
                int h1 = (int)Math.ceil(ratio * (double)box2.height);
                dim1 = this.computeTableLayoutGivenHeight(pivotSize, h1);
            } else {
                int w1 = (int)Math.ceil(ratio * (double)box2.width);
                dim1 = this.computeTableLayoutGivenWidth(pivotSize, w1);
            }
            double pivotAR = Math.max((double)dim1.width / (double)dim1.height, (double)dim1.height / (double)dim1.width);
            if (!first && !(pivotAR < bestAR)) continue;
            first = false;
            bestAR = pivotAR;
            bestdim1 = dim1;
            bestl2Size = l2Size;
            bestIndex = i;
        }
        QuantumAlgorithm.debugPrintln("best split: pivot=" + pivotIndex + ", bestIndex=" + bestIndex + ", bestDim=" + bestdim1 + ", bestAR=" + bestAR);
        if (bestIndex > 0) {
            l2 = new int[bestIndex - pivotIndex];
            System.arraycopy(sizes, pivotIndex + 1, l2, 0, l2.length);
            if (sizes.length - 1 - bestIndex > 0) {
                l3 = new int[sizes.length - 1 - bestIndex];
                System.arraycopy(sizes, bestIndex + 1, l3, 0, l3.length);
            }
        }
        if (l2 != null) {
            if (growWide) {
                dim2 = this.computeTableLayoutGivenHeight(bestl2Size, box2.height - bestdim1.height);
                rp = new Rectangle(box2.x, box2.y, bestdim1.width, bestdim1.height);
                r2 = new Rectangle(box2.x, box2.y + dim1.height, dim2.width, dim2.height);
                if (l3 != null) {
                    l3Size = this.computeSize(sizes, bestIndex + 1, sizes.length - 1);
                    dim3 = this.computeTableLayoutGivenHeight(l3Size, box2.height);
                    r3 = new Rectangle(box2.x + dim2.width, box2.y, dim3.width, dim3.height);
                }
            } else {
                dim2 = this.computeTableLayoutGivenWidth(bestl2Size, box2.width - bestdim1.width);
                rp = new Rectangle(box2.x, box2.y, bestdim1.width, bestdim1.height);
                r2 = new Rectangle(box2.x + dim1.width, box2.y, dim2.width, dim2.height);
                if (l3 != null) {
                    l3Size = this.computeSize(sizes, bestIndex + 1, sizes.length - 1);
                    dim3 = this.computeTableLayoutGivenWidth(l3Size, box2.width);
                    r3 = new Rectangle(box2.x, box2.y + dim2.height, dim3.width, dim3.height);
                }
            }
        } else {
            dim1 = growWide ? this.computeTableLayoutGivenHeight(pivotSize, r1.height) : this.computeTableLayoutGivenWidth(pivotSize, r1.width);
            rp = new Rectangle(box2.x, box2.y, dim1.width, dim1.height);
        }
        QuantumAlgorithm.debugPrintln("DIM1 = " + dim1);
        QuantumAlgorithm.debugPrintln("DIM2 = " + dim2);
        QuantumAlgorithm.debugPrintln("DIM3 = " + dim3);
        QuantumAlgorithm.debugPrintln("rp = " + rp);
        if (l2 != null) {
            QuantumAlgorithm.debugPrintln("r2 = " + r2);
        }
        if (l3 != null) {
            QuantumAlgorithm.debugPrintln("r3 = " + r3);
        }
        if (l2 != null) {
            if (l2.length > 1) {
                QuantumAlgorithm.debugPrintln("Recurse on R2");
                double r2AR = this.computeAspectRatio(r2);
                newGrowWide = r2AR == 1.0 ? growWide : r2AR >= 1.0;
                l2boxes = this.quantumLayout(l2, r2, newGrowWide);
            } else {
                l2boxes = new Rectangle[]{r2};
            }
            l2finalbox = this.computeUnion(l2boxes);
            QuantumAlgorithm.debugPrintln("Final R2 Box = " + l2finalbox);
        }
        if (l3 != null) {
            if (l3.length > 1) {
                QuantumAlgorithm.debugPrintln("Recurse on R3");
                double r3AR = this.computeAspectRatio(r3);
                newGrowWide = r3AR == 1.0 ? growWide : r3AR >= 1.0;
                l3boxes = this.quantumLayout(l3, r3, newGrowWide);
            } else if (l3.length == 1) {
                l3boxes = new Rectangle[]{r3};
            }
        }
        if (growWide) {
            if (l1 != null) {
                rp.x = l1finalbox.x + l1finalbox.width;
                rp.y = l1finalbox.y;
            }
            if (l2 != null) {
                this.translateBoxesTo(l2boxes, rp.x, rp.y + rp.height);
                this.evenBoxWidth(rp, l2boxes);
                if (l3 != null) {
                    l2finalbox = this.computeUnion(l2boxes);
                    this.translateBoxesTo(l3boxes, l2finalbox.x + l2finalbox.width, rp.y);
                }
                this.evenBoxHeight(l1boxes, l2boxes, l3boxes);
            } else {
                this.evenBoxHeight(rp, l1boxes);
            }
        } else {
            if (l1 != null) {
                rp.x = l1finalbox.x;
                rp.y = l1finalbox.y + l1finalbox.height;
            }
            if (l2 != null) {
                this.translateBoxesTo(l2boxes, rp.x + rp.width, rp.y);
                this.evenBoxHeight(rp, l2boxes);
                if (l3 != null) {
                    l2finalbox = this.computeUnion(l2boxes);
                    this.translateBoxesTo(l3boxes, rp.x, l2finalbox.y + l2finalbox.height);
                }
                this.evenBoxWidth(l1boxes, l2boxes, l3boxes);
            } else {
                this.evenBoxWidth(rp, l1boxes);
            }
        }
        numBoxes = 0;
        if (l1 != null) {
            numBoxes += l1.length;
        }
        ++numBoxes;
        if (l2 != null) {
            numBoxes += l2.length;
        }
        if (l3 != null) {
            numBoxes += l3.length;
        }
        boxes = new Rectangle[numBoxes];
        i = 0;
        if (l1 != null) {
            System.arraycopy(l1boxes, 0, boxes, 0, l1boxes.length);
            i += l1boxes.length;
        }
        boxes[i] = rp;
        ++i;
        if (l2 != null) {
            System.arraycopy(l2boxes, 0, boxes, i, l2boxes.length);
            i += l2boxes.length;
        }
        if (l3 != null) {
            System.arraycopy(l3boxes, 0, boxes, i, l3boxes.length);
        }
        if ((boxAR = this.computeAspectRatio(box)) == 1.0) {
            newGrowWide = growWide;
        } else {
            boolean bl = newGrowWide = boxAR >= 1.0;
        }
        if (squarified) {
            boxes = this.tryAlternativeLayouts(sizes, box, boxes, newGrowWide);
        }
        QuantumAlgorithm.debugPrintln("return numBoxes=" + boxes.length);
        return boxes;
    }

    protected Rectangle[] tryAlternativeLayouts(int[] sizes, Rectangle box, Rectangle[] origBoxes, boolean growWide) {
        Dimension dim4;
        double wasteSavings;
        double arSavings;
        int newWastedSpace;
        int origWastedSpace;
        double newAvgAR;
        double origAvgAR;
        int w;
        Dimension dim3;
        Dimension dim2;
        Dimension dim1;
        int h;
        Rectangle[] boxes = origBoxes;
        Rectangle[] nboxes = null;
        double boxAR = this.computeAspectRatio(box);
        if (sizes.length == 3) {
            nboxes = new Rectangle[3];
            if (growWide) {
                h = box.height;
                dim1 = this.computeTableLayoutGivenHeight(sizes[0], h);
                dim2 = this.computeTableLayoutGivenHeight(sizes[1], h);
                dim3 = this.computeTableLayoutGivenHeight(sizes[2], h);
                nboxes[0] = new Rectangle(box.x, box.y, dim1.width, h);
                nboxes[1] = new Rectangle(box.x + dim1.width, box.y, dim2.width, h);
                nboxes[2] = new Rectangle(box.x + dim1.width + dim2.width, box.y, dim3.width, h);
            } else {
                w = box.width;
                dim1 = this.computeTableLayoutGivenWidth(sizes[0], w);
                dim2 = this.computeTableLayoutGivenWidth(sizes[1], w);
                dim3 = this.computeTableLayoutGivenWidth(sizes[2], w);
                nboxes[0] = new Rectangle(box.x, box.y, w, dim1.height);
                nboxes[1] = new Rectangle(box.x, box.y + dim1.height, w, dim2.height);
                nboxes[2] = new Rectangle(box.x, box.y + dim1.height + dim2.height, w, dim3.height);
            }
            origAvgAR = this.computeAverageAspectRatio(boxes);
            newAvgAR = this.computeAverageAspectRatio(nboxes);
            origWastedSpace = this.computeWastedSpace(sizes, boxes);
            newWastedSpace = this.computeWastedSpace(sizes, nboxes);
            arSavings = 100.0 * (origAvgAR / newAvgAR - 1.0);
            wasteSavings = 100.0 * (double)(origWastedSpace - newWastedSpace) / (double)this.computeSize(sizes);
            if (wasteSavings > 0.0 && arSavings > 0.0 || wasteSavings > -arSavings) {
                ++this.numSnake3Layouts;
                boxes = nboxes;
                QuantumAlgorithm.debugPrintln("Snake 3:  boxes[0] = " + boxes[0]);
                QuantumAlgorithm.debugPrintln("Snake 3:  boxes[1] = " + boxes[1]);
                QuantumAlgorithm.debugPrintln("Snake 3:  boxes[2] = " + boxes[2]);
            }
        }
        if (sizes.length == 4) {
            nboxes = new Rectangle[4];
            double ratio1 = (double)(sizes[0] + sizes[1]) / (double)(sizes[0] + sizes[1] + sizes[2] + sizes[3]);
            if (growWide) {
                int w1 = (int)Math.ceil(ratio1 * (double)box.width);
                dim1 = this.computeTableLayoutGivenWidth(sizes[0], w1);
                dim2 = this.computeTableLayoutGivenWidth(sizes[1], w1);
                int w2 = box.width - w1;
                dim3 = this.computeTableLayoutGivenWidth(sizes[2], w2);
                dim4 = this.computeTableLayoutGivenWidth(sizes[3], w2);
                int bottom = Math.max(dim1.height + dim2.height, dim3.height + dim4.height);
                dim1 = this.computeTableLayoutGivenHeight(sizes[0], dim1.height);
                dim2 = this.computeTableLayoutGivenHeight(sizes[1], bottom - dim1.height);
                w1 = Math.max(dim1.width, dim2.width);
                dim3 = this.computeTableLayoutGivenHeight(sizes[2], dim3.height);
                dim4 = this.computeTableLayoutGivenHeight(sizes[3], bottom - dim3.height);
                w2 = Math.max(dim3.width, dim4.width);
                nboxes[0] = new Rectangle(box.x, box.y, w1, dim1.height);
                nboxes[1] = new Rectangle(box.x, box.y + dim1.height, w1, dim2.height);
                nboxes[2] = new Rectangle(box.x + w1, box.y, w2, dim3.height);
                nboxes[3] = new Rectangle(box.x + w1, box.y + dim3.height, w2, dim4.height);
            } else {
                int h1 = (int)Math.ceil(ratio1 * (double)box.height);
                dim1 = this.computeTableLayoutGivenHeight(sizes[0], h1);
                dim2 = this.computeTableLayoutGivenHeight(sizes[1], h1);
                int h2 = (int)Math.ceil((1.0 - ratio1) * (double)box.height);
                dim3 = this.computeTableLayoutGivenHeight(sizes[2], h2);
                dim4 = this.computeTableLayoutGivenHeight(sizes[3], h2);
                int right = Math.max(dim1.width + dim2.width, dim3.width + dim4.width);
                dim1 = this.computeTableLayoutGivenWidth(sizes[0], dim1.width);
                dim2 = this.computeTableLayoutGivenWidth(sizes[1], right - dim1.width);
                h1 = Math.max(dim1.height, dim2.height);
                dim3 = this.computeTableLayoutGivenWidth(sizes[2], dim3.width);
                dim4 = this.computeTableLayoutGivenWidth(sizes[3], right - dim3.width);
                h2 = Math.max(dim3.height, dim4.height);
                nboxes[0] = new Rectangle(box.x, box.y, dim1.width, h1);
                nboxes[1] = new Rectangle(box.x + dim1.width, box.y, dim2.width, h1);
                nboxes[2] = new Rectangle(box.x, box.y + h1, dim3.width, h2);
                nboxes[3] = new Rectangle(box.x + dim3.width, box.y + h1, dim4.width, h2);
            }
            origAvgAR = this.computeAverageAspectRatio(boxes);
            newAvgAR = this.computeAverageAspectRatio(nboxes);
            origWastedSpace = this.computeWastedSpace(sizes, boxes);
            newWastedSpace = this.computeWastedSpace(sizes, nboxes);
            arSavings = 100.0 * (origAvgAR / newAvgAR - 1.0);
            wasteSavings = 100.0 * (double)(origWastedSpace - newWastedSpace) / (double)this.computeSize(sizes);
            if (wasteSavings > 0.0 && arSavings > 0.0 || wasteSavings > -arSavings) {
                ++this.numQuadLayouts;
                boxes = nboxes;
                QuantumAlgorithm.debugPrintln("Quad:  boxes[0] = " + boxes[0]);
                QuantumAlgorithm.debugPrintln("Quad:  boxes[1] = " + boxes[1]);
                QuantumAlgorithm.debugPrintln("Quad:  boxes[2] = " + boxes[2]);
                QuantumAlgorithm.debugPrintln("Quad:  boxes[3] = " + boxes[3]);
            }
            nboxes = new Rectangle[4];
            if (growWide) {
                h = box.height;
                dim1 = this.computeTableLayoutGivenHeight(sizes[0], h);
                dim2 = this.computeTableLayoutGivenHeight(sizes[1], h);
                dim3 = this.computeTableLayoutGivenHeight(sizes[2], h);
                dim4 = this.computeTableLayoutGivenHeight(sizes[3], h);
                nboxes[0] = new Rectangle(box.x, box.y, dim1.width, h);
                nboxes[1] = new Rectangle(box.x + dim1.width, box.y, dim2.width, h);
                nboxes[2] = new Rectangle(box.x + dim1.width + dim2.width, box.y, dim3.width, h);
                nboxes[3] = new Rectangle(box.x + dim1.width + dim2.width + dim3.width, box.y, dim4.width, h);
            } else {
                w = box.width;
                dim1 = this.computeTableLayoutGivenWidth(sizes[0], w);
                dim2 = this.computeTableLayoutGivenWidth(sizes[1], w);
                dim3 = this.computeTableLayoutGivenWidth(sizes[2], w);
                dim4 = this.computeTableLayoutGivenWidth(sizes[3], w);
                nboxes[0] = new Rectangle(box.x, box.y, w, dim1.height);
                nboxes[1] = new Rectangle(box.x, box.y + dim1.height, w, dim2.height);
                nboxes[2] = new Rectangle(box.x, box.y + dim1.height + dim2.height, w, dim3.height);
                nboxes[3] = new Rectangle(box.x, box.y + dim1.height + dim2.height + dim3.height, w, dim4.height);
            }
            origAvgAR = this.computeAverageAspectRatio(boxes);
            newAvgAR = this.computeAverageAspectRatio(nboxes);
            origWastedSpace = this.computeWastedSpace(sizes, boxes);
            newWastedSpace = this.computeWastedSpace(sizes, nboxes);
            arSavings = 100.0 * (origAvgAR / newAvgAR - 1.0);
            wasteSavings = 100.0 * (double)(origWastedSpace - newWastedSpace) / (double)this.computeSize(sizes);
            if (wasteSavings > 0.0 && arSavings > 0.0 || wasteSavings > -arSavings) {
                ++this.numSnake4Layouts;
                boxes = nboxes;
                QuantumAlgorithm.debugPrintln("Snake 4:  boxes[0] = " + boxes[0]);
                QuantumAlgorithm.debugPrintln("Snake 4:  boxes[1] = " + boxes[1]);
                QuantumAlgorithm.debugPrintln("Snake 4:  boxes[2] = " + boxes[2]);
                QuantumAlgorithm.debugPrintln("Snake 4:  boxes[3] = " + boxes[3]);
            }
        }
        if (sizes.length == 5) {
            nboxes = new Rectangle[5];
            if (growWide) {
                h = box.height;
                dim1 = this.computeTableLayoutGivenHeight(sizes[0], h);
                dim2 = this.computeTableLayoutGivenHeight(sizes[1], h);
                dim3 = this.computeTableLayoutGivenHeight(sizes[2], h);
                dim4 = this.computeTableLayoutGivenHeight(sizes[3], h);
                Dimension dim5 = this.computeTableLayoutGivenHeight(sizes[4], h);
                nboxes[0] = new Rectangle(box.x, box.y, dim1.width, h);
                nboxes[1] = new Rectangle(box.x + dim1.width, box.y, dim2.width, h);
                nboxes[2] = new Rectangle(box.x + dim1.width + dim2.width, box.y, dim3.width, h);
                nboxes[3] = new Rectangle(box.x + dim1.width + dim2.width + dim3.width, box.y, dim4.width, h);
                nboxes[4] = new Rectangle(box.x + dim1.width + dim2.width + dim3.width + dim4.width, box.y, dim5.width, h);
            } else {
                w = box.width;
                dim1 = this.computeTableLayoutGivenWidth(sizes[0], w);
                dim2 = this.computeTableLayoutGivenWidth(sizes[1], w);
                dim3 = this.computeTableLayoutGivenWidth(sizes[2], w);
                dim4 = this.computeTableLayoutGivenWidth(sizes[3], w);
                Dimension dim5 = this.computeTableLayoutGivenWidth(sizes[4], w);
                nboxes[0] = new Rectangle(box.x, box.y, w, dim1.height);
                nboxes[1] = new Rectangle(box.x, box.y + dim1.height, w, dim2.height);
                nboxes[2] = new Rectangle(box.x, box.y + dim1.height + dim2.height, w, dim3.height);
                nboxes[3] = new Rectangle(box.x, box.y + dim1.height + dim2.height + dim3.height, w, dim4.height);
                nboxes[4] = new Rectangle(box.x, box.y + dim1.height + dim2.height + dim3.height + dim4.height, w, dim5.height);
            }
            origAvgAR = this.computeAverageAspectRatio(boxes);
            newAvgAR = this.computeAverageAspectRatio(nboxes);
            origWastedSpace = this.computeWastedSpace(sizes, boxes);
            newWastedSpace = this.computeWastedSpace(sizes, nboxes);
            arSavings = 100.0 * (origAvgAR / newAvgAR - 1.0);
            wasteSavings = 100.0 * (double)(origWastedSpace - newWastedSpace) / (double)this.computeSize(sizes);
            if (wasteSavings > 0.0 && arSavings > 0.0 || wasteSavings > -arSavings) {
                ++this.numSnake5Layouts;
                boxes = nboxes;
                QuantumAlgorithm.debugPrintln("Snake 5:  boxes[0] = " + boxes[0]);
                QuantumAlgorithm.debugPrintln("Snake 5:  boxes[1] = " + boxes[1]);
                QuantumAlgorithm.debugPrintln("Snake 5:  boxes[2] = " + boxes[2]);
                QuantumAlgorithm.debugPrintln("Snake 5:  boxes[3] = " + boxes[3]);
                QuantumAlgorithm.debugPrintln("Snake 5:  boxes[4] = " + boxes[4]);
            }
        }
        return boxes;
    }

    protected void setPivotIndexType(int indexType) {
        this.indexType = indexType;
    }

    protected int computePivotIndex(int[] sizes) {
        int index = 0;
        double bestRatio = 0.0;
        boolean first = true;
        switch (this.indexType) {
            case 1: {
                index = (sizes.length - 1) / 2;
                break;
            }
            case 2: {
                int leftSize = 0;
                int rightSize = this.computeSize(sizes);
                for (int i = 0; i < sizes.length; ++i) {
                    double ratio = Math.max((double)leftSize / (double)rightSize, (double)rightSize / (double)leftSize);
                    if (first || ratio < bestRatio) {
                        first = false;
                        bestRatio = ratio;
                        index = i;
                    }
                    leftSize += sizes[i];
                    rightSize -= sizes[i];
                }
                break;
            }
            case 3: {
                int biggest = 0;
                for (int i = 0; i < sizes.length; ++i) {
                    if (!first && sizes[i] <= biggest) continue;
                    first = false;
                    biggest = sizes[i];
                    index = i;
                }
                break;
            }
        }
        return index;
    }

    protected double computeAspectRatio(Rectangle rect) {
        return (double)rect.width / (double)rect.height;
    }

    protected int computeArea(Rectangle rect) {
        return rect.width * rect.height;
    }

    protected int computeSize(int[] sizes) {
        int size = 0;
        if (sizes != null) {
            for (int i = 0; i < sizes.length; ++i) {
                size += sizes[i];
            }
        }
        return size;
    }

    protected Rectangle computeUnion(Rectangle[] boxes) {
        Rectangle box = new Rectangle(boxes[0]);
        for (int i = 1; i < boxes.length; ++i) {
            int x1 = Math.min(box.x, boxes[i].x);
            int x2 = Math.max(box.x + box.width, boxes[i].x + boxes[i].width);
            int y1 = Math.min(box.y, boxes[i].y);
            int y2 = Math.max(box.y + box.height, boxes[i].y + boxes[i].height);
            box = new Rectangle(x1, y1, x2 - x1, y2 - y1);
        }
        return box;
    }

    protected void translateBoxesTo(Rectangle[] boxes, int x, int y) {
        Rectangle box = this.computeUnion(boxes);
        int dx = x - box.x;
        int dy = y - box.y;
        for (int i = 0; i < boxes.length; ++i) {
            boxes[i].x += dx;
            boxes[i].y += dy;
        }
    }

    protected void evenBoxWidth(Rectangle b1, Rectangle[] b2) {
        if (this.debugBoxEvening) {
            return;
        }
        if (b1 == null || b2 == null) {
            return;
        }
        Rectangle[] b1boxes = new Rectangle[]{b1};
        this.evenBoxWidth(b1boxes, b2, null);
    }

    protected void evenBoxWidth(Rectangle[] b1, Rectangle[] b2, Rectangle[] b3) {
        int i;
        int right;
        if (this.debugBoxEvening) {
            return;
        }
        int dx = 0;
        Object b = null;
        Object bBounds = null;
        Rectangle b1Bounds = b1 != null ? this.computeUnion(b1) : new Rectangle();
        Rectangle b2Bounds = b2 != null ? this.computeUnion(b2) : new Rectangle();
        Rectangle b3Bounds = b3 != null ? this.computeUnion(b3) : new Rectangle();
        int newRight = Math.max(Math.max(b1Bounds.x + b1Bounds.width, b2Bounds.x + b2Bounds.width), b3Bounds.x + b3Bounds.width);
        if (b1 != null && b1Bounds.x + b1Bounds.width != newRight) {
            dx = newRight - (b1Bounds.x + b1Bounds.width);
            right = b1Bounds.x + b1Bounds.width;
            for (i = 0; i < b1.length; ++i) {
                if (b1[i].x + b1[i].width != right) continue;
                b1[i].width += dx;
            }
        }
        if (b2 != null && b2Bounds.x + b2Bounds.width != newRight) {
            dx = newRight - (b2Bounds.x + b2Bounds.width);
            right = b2Bounds.x + b2Bounds.width;
            for (i = 0; i < b2.length; ++i) {
                if (b2[i].x + b2[i].width != right) continue;
                b2[i].width += dx;
            }
        }
        if (b3 != null && b3Bounds.x + b3Bounds.width != newRight) {
            dx = newRight - (b3Bounds.x + b3Bounds.width);
            right = b3Bounds.x + b3Bounds.width;
            for (i = 0; i < b3.length; ++i) {
                if (b3[i].x + b3[i].width != right) continue;
                b3[i].width += dx;
            }
        }
    }

    protected void evenBoxHeight(Rectangle b1, Rectangle[] b2) {
        if (this.debugBoxEvening) {
            return;
        }
        if (b1 == null || b2 == null) {
            return;
        }
        Rectangle[] b1boxes = new Rectangle[]{b1};
        this.evenBoxHeight(b1boxes, b2, null);
    }

    protected void evenBoxHeight(Rectangle[] b1, Rectangle[] b2, Rectangle[] b3) {
        int i;
        int bottom;
        if (this.debugBoxEvening) {
            return;
        }
        int dy = 0;
        Object b = null;
        Object bBounds = null;
        Rectangle b1Bounds = b1 != null ? this.computeUnion(b1) : new Rectangle();
        Rectangle b2Bounds = b2 != null ? this.computeUnion(b2) : new Rectangle();
        Rectangle b3Bounds = b3 != null ? this.computeUnion(b3) : new Rectangle();
        int newBottom = Math.max(Math.max(b1Bounds.y + b1Bounds.height, b2Bounds.y + b2Bounds.height), b3Bounds.y + b3Bounds.height);
        if (b1 != null && b1Bounds.y + b1Bounds.height != newBottom) {
            dy = newBottom - (b1Bounds.y + b1Bounds.height);
            bottom = b1Bounds.y + b1Bounds.height;
            for (i = 0; i < b1.length; ++i) {
                if (b1[i].y + b1[i].height != bottom) continue;
                b1[i].height += dy;
            }
        }
        if (b2 != null && b2Bounds.y + b2Bounds.height != newBottom) {
            dy = newBottom - (b2Bounds.y + b2Bounds.height);
            bottom = b2Bounds.y + b2Bounds.height;
            for (i = 0; i < b2.length; ++i) {
                if (b2[i].y + b2[i].height != bottom) continue;
                b2[i].height += dy;
            }
        }
        if (b3 != null && b3Bounds.y + b3Bounds.height != newBottom) {
            dy = newBottom - (b3Bounds.y + b3Bounds.height);
            bottom = b3Bounds.y + b3Bounds.height;
            for (i = 0; i < b3.length; ++i) {
                if (b3[i].y + b3[i].height != bottom) continue;
                b3[i].height += dy;
            }
        }
    }

    protected int computeSize(int[] sizes, int i1, int i2) {
        int size = 0;
        for (int i = i1; i <= i2; ++i) {
            size += sizes[i];
        }
        return size;
    }

    protected double computeAverageAspectRatio(Rectangle[] rects) {
        double totAR = 0.0;
        int numRects = 0;
        for (int i = 0; i < rects.length; ++i) {
            int w = rects[i].width;
            int h = rects[i].height;
            if (w == 0 || h == 0) continue;
            double ar = Math.max((double)w / (double)h, (double)h / (double)w);
            totAR += ar;
            ++numRects;
        }
        return totAR /= (double)numRects;
    }

    protected int computeWastedSpace(int[] sizes, Rectangle[] rects) {
        int wastedSpace = 0;
        for (int i = 0; i < rects.length; ++i) {
            int area = this.computeArea(rects[i]);
            wastedSpace += area - sizes[i];
        }
        return wastedSpace;
    }

    protected Dimension computeTableLayout(int numItems, double ar) {
        int w;
        int h;
        if (ar >= 1.0) {
            h = (int)Math.ceil(Math.sqrt((double)numItems / ar));
            if (h == 0) {
                h = 1;
            }
            if (h * (w = numItems / h) < numItems) {
                ++w;
                --h;
            }
            while (h * w < numItems) {
                ++h;
            }
        } else {
            w = (int)Math.ceil(Math.sqrt((double)numItems * ar));
            if (w == 0) {
                w = 1;
            }
            if ((h = numItems / w) * w < numItems) {
                ++h;
                --w;
            }
            while (h * w < numItems) {
                ++w;
            }
        }
        return new Dimension(w, h);
    }

    protected Dimension computeTableLayoutGivenWidth(int numItems, int width) {
        if (width < 1) {
            width = 1;
        }
        int h = (int)Math.ceil((double)numItems / (double)width);
        return new Dimension(width, h);
    }

    protected Dimension computeTableLayoutGivenHeight(int numItems, int height) {
        if (height < 1) {
            height = 1;
        }
        int w = (int)Math.ceil((double)numItems / (double)height);
        return new Dimension(w, height);
    }

    protected static void debugPrint(String str) {
        if (debug) {
            System.out.print(str);
        }
    }

    protected static void debugPrintln(String str) {
        if (debug) {
            System.out.println(str);
        }
    }

    public boolean isCompatible(Shape shape) {
        return shape instanceof Rectangle2D;
    }

    public String toString() {
        return "Quantum";
    }
}

