/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.v4.view;

import com.macrofocus.common.interval.MutableBoundedInterval;
import org.jdesktop.core.animation.timing.Animator;
import org.jdesktop.core.animation.timing.TimingTarget;

public class BoundedIntervalTimingTarget
implements TimingTarget {
    private MutableBoundedInterval from;
    private double toRangeMin;
    private double toRangeMax;

    public BoundedIntervalTimingTarget(MutableBoundedInterval from, double toRangeMin, double toRangeMax) {
        this.from = from;
        this.toRangeMin = toRangeMin;
        this.toRangeMax = toRangeMax;
    }

    public void timingEvent(Animator source, double v) {
        if (this.from.getStart() != this.toRangeMin || this.from.getStart() + this.from.getExtent() != this.toRangeMax) {
            double min = BoundedIntervalTimingTarget.inter(this.from.getStart(), this.toRangeMin, v);
            double max = BoundedIntervalTimingTarget.inter(this.from.getStart() + this.from.getExtent(), this.toRangeMax, v);
            this.setWorld(min, max);
        }
    }

    private static double inter(double f, double t, double v) {
        return f + (t - f) * v;
    }

    public void begin(Animator source) {
        if (this.from.getStart() != this.toRangeMin || this.from.getStart() + this.from.getExtent() != this.toRangeMax) {
            // empty if block
        }
    }

    public void end(Animator source) {
        this.setWorld(this.toRangeMin, this.toRangeMax);
    }

    public void repeat(Animator source) {
    }

    public void reverse(Animator source) {
    }

    private void setWorld(double min, double max) {
        this.from.setValue(min, max - min);
    }
}

