/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.util.Synthetica2DUtils;
import de.javasoft.synthetica.simple2d.SyntheticaSimple2DLookAndFeel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.synth.SynthContext;

public class ComboBoxPainter
extends de.javasoft.plaf.synthetica.painter.ComboBoxPainter {
    private static final float ARC = SyntheticaSimple2DLookAndFeel.ARC;

    public void paintComboBoxBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        boolean hover;
        boolean innerBorderIsDefault;
        JComboBox combo = (JComboBox)sc.getComponent();
        Color bg = ComboBoxPainter.getSyntheticaBackgroundColor((JComponent)combo);
        Synthetica2DUtils.BlendMode bm = ComboBoxPainter.getSyntheticaBackgroundBlendMode((JComponent)combo);
        boolean disabled = (sc.getComponentState() & 8) > 0;
        Border border = combo.getBorder();
        Border defaultBorder = SyntheticaLookAndFeel.findDefaultBorder((Border)border);
        boolean defaultBorderIsSynth = defaultBorder == null ? false : defaultBorder.getClass().getName().equals("javax.swing.plaf.synth.SynthBorder");
        boolean bl = innerBorderIsDefault = border instanceof CompoundBorder && ((CompoundBorder)border).getInsideBorder() == defaultBorder;
        if (!SyntheticaLookAndFeel.isOpaque((JComponent)combo)) {
            return;
        }
        Graphics2D g2 = this.prepareGraphics2D(sc, g, x, y, true);
        Shape shape = this.createShape(0.0f, 0.0f, ComboBoxPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), ComboBoxPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), this.scaleArc(ARC));
        float borderWidth = 1.0f;
        if (!defaultBorderIsSynth) {
            BasicStroke stroke = (BasicStroke)g2.getStroke();
            float offset = stroke.getLineWidth() / 2.0f;
            Insets ins = combo.getInsets();
            float x_ = (float)(x + ins.left) - offset;
            float y_ = (float)(x + ins.top) - offset;
            float w_ = w - ins.left - ins.right;
            float h_ = h - ins.top - ins.bottom;
            shape = new Rectangle2D.Float(x_, y_, w_, h_);
        } else if (innerBorderIsDefault) {
            Insets ins = combo.getInsets();
            Insets ins_ = defaultBorder.getBorderInsets(combo);
            float x_ = x + ins.left - ins_.left;
            float y_ = y + ins.top - ins_.top;
            float w_ = w - (ins.left - ins_.left + ins.right - ins_.right);
            float h_ = h - (ins.top - ins_.top + ins.bottom - ins_.bottom);
            AffineTransform at = new AffineTransform();
            at.translate(x_, y_);
            at.scale(w_ / (float)w, h_ / (float)h);
            g2.transform(at);
        }
        if (disabled) {
            g2.setPaint(new Color(0xEFEFEF));
        } else if (combo.isEditable()) {
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, h - 1, -borderWidth), new float[]{0.0f, 0.25f, 1.0f}, new Color[]{ComboBoxPainter.blend((Color)new Color(0xEBEBEB), (Color)bg, (Synthetica2DUtils.BlendMode)bm), ComboBoxPainter.blend((Color)new Color(0xFBFBFB), (Color)bg, (Synthetica2DUtils.BlendMode)bm), ComboBoxPainter.blend((Color)new Color(0xFFFFFF), (Color)bg, (Synthetica2DUtils.BlendMode)bm)}));
        } else {
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, h - 1, -borderWidth), new float[]{0.0f, 0.5f, 0.75f, 1.0f}, new Color[]{ComboBoxPainter.blend((Color)new Color(0x40F0F0F0), (Color)bg, (Synthetica2DUtils.BlendMode)bm), ComboBoxPainter.blend((Color)new Color(1088940007), (Color)bg, (Synthetica2DUtils.BlendMode)bm), ComboBoxPainter.blend((Color)new Color(1088545249), (Color)bg, (Synthetica2DUtils.BlendMode)bm), ComboBoxPainter.blend((Color)new Color(1087558354), (Color)bg, (Synthetica2DUtils.BlendMode)bm)}));
        }
        this.doFill(g2, shape, defaultBorderIsSynth);
        boolean bl2 = hover = combo.getClientProperty("Synthetica.MOUSE_OVER") == null ? false : (Boolean)combo.getClientProperty("Synthetica.MOUSE_OVER");
        if (hover && !disabled) {
            g2.setPaint(SyntheticaSimple2DLookAndFeel.getHoverColor());
            this.doFill(g2, shape, defaultBorderIsSynth);
        }
        this.restoreGraphics2D(g2);
    }

    private void doFill(Graphics2D g2, Shape shape, boolean defaultBorderIsSynth) {
        if (defaultBorderIsSynth) {
            g2.fill(ComboBoxPainter.subtractStroke((Graphics2D)g2, (Shape)shape));
        } else {
            g2.fill(shape);
        }
    }

    public void paintComboBoxBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        boolean focused;
        JComponent c = sc.getComponent();
        boolean locked = c instanceof JComboBox ? !((JComboBox)c).isEditable() : false;
        boolean disabled = (sc.getComponentState() & 8) > 0;
        boolean bl = focused = c instanceof JComboBox ? this.hasFocus((JComboBox)c) : false;
        if (!SyntheticaLookAndFeel.isOpaque((JComponent)c)) {
            return;
        }
        Graphics2D g2 = this.prepareGraphics2D(sc, g, x, y, true);
        Shape shape = this.createShape(0.0f, 0.0f, ComboBoxPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), ComboBoxPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), this.scaleArc(ARC));
        if (disabled) {
            g2.setPaint(new Color(0xC4C4C4));
        } else if (!locked) {
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 1.0f}, new Color[]{new Color(0xAAAAAA), new Color(0xCCCCCC)}));
        } else {
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 1.0f}, new Color[]{new Color(0xCCCCCC), new Color(0xAAAAAA)}));
        }
        g2.draw(shape);
        if (locked && !focused && !disabled) {
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 1.0f}, new Color[]{new Color(Integer.MAX_VALUE, true), new Color(0x3FFFFFFF, true)}));
            shape = this.createShape(this.calcRelativePos(g2, 0.0f, 1.0f), this.calcRelativePos(g2, 0.0f, 1.0f), ComboBoxPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)-2.0f), ComboBoxPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)-2.0f), this.calcRelativeArc(g2, this.scaleArc(ARC), -2.0f));
            g2.draw(shape);
        }
        boolean paintFocus = (Boolean)SyntheticaLookAndFeel.getClientProperty((String)"Synthetica.paintFocus", (JComponent)c, (Object)true);
        if (focused && paintFocus) {
            g2.setPaint(SyntheticaSimple2DLookAndFeel.getFocusColor());
            g2.draw(shape);
            Shape s = this.createShape(this.getScale(), this.getScale(), ComboBoxPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)-2.0f), ComboBoxPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)-2.0f), this.calcRelativeArc(g2, this.scaleArc(ARC), -2.0f));
            g2.draw(s);
        }
        this.restoreGraphics2D(g2);
    }

    private Shape createShape(float x, float y, float w, float h, float arc) {
        return new RoundRectangle2D.Float(x, y, w, h, arc, arc);
    }
}

