/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.util.Synthetica2DUtils;
import de.javasoft.synthetica.simple2d.ButtonPainter;
import de.javasoft.synthetica.simple2d.SyntheticaSimple2DLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.synth.SynthContext;

public class ToggleButtonPainter
extends de.javasoft.plaf.synthetica.painter.ToggleButtonPainter {
    private static final float ARC = SyntheticaSimple2DLookAndFeel.ARC;

    public void paintToggleButtonBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCheck(sc) || (float)h <= this.getScale() * 2.0f + 1.0f || (float)w <= this.getScale() * 2.0f + 1.0f) {
            return;
        }
        this.paintToggleButtonBackground(sc.getComponent(), new SyntheticaState(sc.getComponentState()), (String)sc.getComponent().getClientProperty("JButton.segmentPosition"), g, x, y, w, h);
    }

    public void paintToggleButtonBackground(JComponent c, SyntheticaState state, String segmentPosition, Graphics g, int x, int y, int w, int h) {
        Graphics2D g2 = this.prepareGraphics2D(null, g, x, y, false);
        Shape shape = this.createShape(0.0f, 0.0f, ToggleButtonPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), ToggleButtonPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), this.scaleArc(ARC), segmentPosition, false, false);
        float borderWidth = 1.0f;
        Color bg = ToggleButtonPainter.getSyntheticaBackgroundColor((JComponent)c);
        Synthetica2DUtils.BlendMode bm = ToggleButtonPainter.getSyntheticaBackgroundBlendMode((JComponent)c);
        if (state.isSet(SyntheticaState.State.DISABLED)) {
            g2.setPaint(new Color(0xEFEFEF));
        } else if (state.isSet(SyntheticaState.State.PRESSED) || state.isSet(SyntheticaState.State.SELECTED)) {
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, h - 1, -borderWidth), new float[]{0.0f, 0.05f, 1.0f}, new Color[]{ToggleButtonPainter.blend((Color)new Color(0xB1B1B1), (Color)bg, (Synthetica2DUtils.BlendMode)bm), ToggleButtonPainter.blend((Color)new Color(0xC2C2C2), (Color)bg, (Synthetica2DUtils.BlendMode)bm), ToggleButtonPainter.blend((Color)new Color(0xD1D1D1), (Color)bg, (Synthetica2DUtils.BlendMode)bm)}));
        } else {
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, h - 1, -borderWidth), new float[]{0.0f, 0.5f, 0.75f, 1.0f}, new Color[]{ToggleButtonPainter.blend((Color)new Color(0xF0F0F0), (Color)bg, (Synthetica2DUtils.BlendMode)bm), ToggleButtonPainter.blend((Color)new Color(0xE7E7E7), (Color)bg, (Synthetica2DUtils.BlendMode)bm), ToggleButtonPainter.blend((Color)new Color(0xE1E1E1), (Color)bg, (Synthetica2DUtils.BlendMode)bm), ToggleButtonPainter.blend((Color)new Color(0xD2D2D2), (Color)bg, (Synthetica2DUtils.BlendMode)bm)}));
        }
        g2.fill(ToggleButtonPainter.subtractStroke((Graphics2D)g2, (Shape)shape));
        if (state.isSet(SyntheticaState.State.HOVER)) {
            if (state.isSet(SyntheticaState.State.PRESSED) || state.isSet(SyntheticaState.State.SELECTED)) {
                g2.setPaint(new Color(0x17000000, true));
            } else {
                g2.setPaint(SyntheticaSimple2DLookAndFeel.getHoverColor());
            }
            g2.fill(ToggleButtonPainter.subtractStroke((Graphics2D)g2, (Shape)shape));
        }
        this.restoreGraphics2D(g2);
        g2 = this.prepareGraphics2D(null, g, x, y, true);
        float arc = this.scaleArc(ARC);
        if (SyntheticaLookAndFeel.isOpaque((JComponent)c)) {
            this.paintBorder(c, state, g2, x, y, w, h, segmentPosition, arc);
        }
        this.paintFocus(c, state, g2, x, y, w, h, segmentPosition, arc);
        this.restoreGraphics2D(g2);
    }

    private void paintBorder(JComponent c, SyntheticaState state, Graphics2D g2, int x, int y, int w, int h, String segmentPosition, float arc) {
        if (state.isSet(SyntheticaState.State.DISABLED)) {
            g2.setPaint(new Color(0xC4C4C4));
        } else if (state.isSet(SyntheticaState.State.PRESSED) || state.isSet(SyntheticaState.State.SELECTED)) {
            float y_ = arc / 2.0f / (float)h;
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, y_, 1.0f - y_, 1.0f}, new Color[]{new Color(0x808080), new Color(0x909090), new Color(0xAAAAAA), new Color(0xFCFCFC)}));
        } else {
            Color bg = ToggleButtonPainter.getSyntheticaBackgroundColor((JComponent)c);
            Synthetica2DUtils.BlendMode bm = ToggleButtonPainter.getSyntheticaBackgroundBlendMode((JComponent)c);
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 1.0f}, new Color[]{ToggleButtonPainter.blend((Color)new Color(0xCCCCCC), (Color)bg, (Synthetica2DUtils.BlendMode)bm), ToggleButtonPainter.blend((Color)new Color(0x808080), (Color)bg, (Synthetica2DUtils.BlendMode)bm)}));
        }
        Shape shape = this.createShape(0.0f, 0.0f, ToggleButtonPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), ToggleButtonPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), arc, segmentPosition, true, false);
        g2.draw(shape);
        if (!state.isSet(SyntheticaState.State.SELECTED) && !state.isSet(SyntheticaState.State.DISABLED)) {
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 1.0f}, new Color[]{new Color(Integer.MAX_VALUE, true), new Color(0x3FFFFFFF, true)}));
            shape = this.createShape(this.calcRelativePos(g2, 0.0f, 1.0f), this.calcRelativePos(g2, 0.0f, 1.0f), ToggleButtonPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)-2.0f), ToggleButtonPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)-2.0f), this.calcRelativeArc(g2, arc, -2.0f), segmentPosition, true, false);
            g2.draw(shape);
        }
    }

    private void paintFocus(JComponent c, SyntheticaState state, Graphics2D g2, int x, int y, int w, int h, String segmentPosition, float arc) {
        boolean paintFocus = (Boolean)SyntheticaLookAndFeel.getClientProperty((String)"Synthetica.paintFocus", (JComponent)c, (Object)true);
        if (state.isSet(SyntheticaState.State.FOCUSED) && ((AbstractButton)c).isFocusPainted() && paintFocus) {
            g2.setPaint(SyntheticaSimple2DLookAndFeel.getFocusColor());
            Shape shape = this.createShape(0.0f, 0.0f, ToggleButtonPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), ToggleButtonPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), arc, segmentPosition, true, true);
            g2.draw(shape);
            shape = this.createShape(this.getScale(), this.getScale(), ToggleButtonPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)-2.0f), ToggleButtonPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)-2.0f), this.calcRelativeArc(g2, arc, -2.0f), segmentPosition, true, true);
            g2.draw(shape);
        }
    }

    private Shape createShape(float x, float y, float w, float h, float arc, String segmentPosition, boolean isBorder, boolean hasFocus) {
        return ((ButtonPainter)ButtonPainter.getInstance()).createShape(x, y, w, h, arc, segmentPosition, isBorder, hasFocus);
    }
}

