/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.highlighter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.PainterHighlighter;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

public class ColorTextHighlighter
extends PainterHighlighter {
    private Color background;
    private Color foreground;
    private Color selectedBackground;
    private Color selectedForeground;
    private TextBackgroundPainter<JComponent> backgroundPainter;

    public ColorTextHighlighter(HighlightPredicate predicate, Color background, Color foreground) {
        this(predicate, background, foreground, null, null);
    }

    public ColorTextHighlighter(HighlightPredicate predicate, Color background, Color foreground, Color selectedBackground, Color selectedForeground) {
        super(predicate, null);
        this.background = background;
        this.foreground = foreground;
        this.selectedBackground = selectedBackground;
        this.selectedForeground = selectedForeground;
        this.backgroundPainter = new TextBackgroundPainter(background);
        this.setPainter((Painter)this.backgroundPainter);
    }

    protected Component doHighlight(Component renderer, ComponentAdapter adapter) {
        Color background;
        Color color = background = adapter.isSelected() ? this.getSelectedBackground() : this.getBackground();
        if (background != null) {
            this.backgroundPainter.setColor(background);
            super.doHighlight(renderer, adapter);
        }
        this.applyForeground(renderer, adapter);
        return renderer;
    }

    protected void applyForeground(Component renderer, ComponentAdapter adapter) {
        Color foreground;
        Color color = foreground = adapter.isSelected() ? this.getSelectedForeground() : this.getForeground();
        if (foreground != null) {
            renderer.setForeground(foreground);
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        if (this.areEqual(background, this.getBackground())) {
            return;
        }
        this.background = background;
        this.fireStateChanged();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        if (this.areEqual(foreground, this.getForeground())) {
            return;
        }
        this.foreground = foreground;
        this.fireStateChanged();
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setSelectedBackground(Color background) {
        if (this.areEqual(background, this.getSelectedBackground())) {
            return;
        }
        this.selectedBackground = background;
        this.fireStateChanged();
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public void setSelectedForeground(Color foreground) {
        if (this.areEqual(foreground, this.getSelectedForeground())) {
            return;
        }
        this.selectedForeground = foreground;
        this.fireStateChanged();
    }

    private static class TextBackgroundPainter<T extends JComponent>
    extends AbstractPainter<T> {
        private Rectangle paintIconR = new Rectangle();
        private Rectangle paintViewR = new Rectangle();
        private Rectangle paintTextR = new Rectangle();
        private Insets insetss = SyntheticaLookAndFeel.getInstance().scaleInsets(0, 0, 0, 0);
        private Color background;

        public TextBackgroundPainter(Color background) {
            this.background = background;
        }

        protected void doPaint(Graphics2D g, JComponent comp, int width, int height) {
            if (!(comp instanceof JLabel)) {
                return;
            }
            JLabel label = (JLabel)comp;
            Insets insets = label.getInsets(this.insetss);
            this.paintViewR.x = insets.left;
            this.paintViewR.y = insets.top;
            this.paintViewR.width = width - (insets.left + insets.right);
            this.paintViewR.height = height - (insets.top + insets.bottom);
            this.paintIconR.height = 0;
            this.paintIconR.width = 0;
            this.paintIconR.y = 0;
            this.paintIconR.x = 0;
            this.paintTextR.height = 0;
            this.paintTextR.width = 0;
            this.paintTextR.y = 0;
            this.paintTextR.x = 0;
            SwingUtilities.layoutCompoundLabel(label, label.getFontMetrics(label.getFont()), label.getText(), null, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), this.paintViewR, this.paintIconR, this.paintTextR, label.getIconTextGap());
            this.doPaint(g, this.paintViewR);
        }

        private void doPaint(Graphics2D g, Rectangle r) {
            Color old = g.getColor();
            g.setColor(this.background);
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(old);
        }

        public void setColor(Color background) {
            this.background = background;
        }
    }
}

