/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.plaf.synthetica.SyntheticaDefaultTableCellEditor;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractTableCellEditor<T extends JComponent>
extends AbstractCellEditor
implements TableCellEditor {
    protected TableCellEditor delegate;
    protected T editorComponent;
    protected boolean useRendererBorder;
    protected boolean modelDriven;
    protected boolean acceptNullValue;
    private int clicksToEdit;

    public AbstractTableCellEditor(TableCellEditor defaultEditor) {
        this(defaultEditor, false);
    }

    public AbstractTableCellEditor(TableCellEditor defaultEditor, boolean acceptNullValue) {
        this.delegate = defaultEditor;
        this.acceptNullValue = acceptNullValue;
        this.editorComponent = this.createEditorComponent();
        if (this.editorComponent != null && ((Component)this.editorComponent).getName() == null) {
            ((Component)this.editorComponent).setName("Table.editor");
        }
    }

    public abstract T createEditorComponent();

    public T getEditorComponent() {
        return this.editorComponent;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setCellEditorValue(value);
        ((JComponent)this.editorComponent).setBorder(this.getEditorComponentBorder(table, value, isSelected, row, column));
        return this.editorComponent;
    }

    protected Border getEditorComponentBorder(JTable table, Object value, boolean isSelected, int row, int column) {
        Border border = null;
        if (this.useRendererBorder) {
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            JComponent c = (JComponent)renderer.getTableCellRendererComponent(table, value, isSelected, true, row, column);
            if (c != null) {
                border = c.getBorder();
            }
        } else {
            JComponent c = (JComponent)this.delegate.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (c != null) {
                border = c.getBorder();
            }
        }
        return border;
    }

    @Override
    public abstract Object getCellEditorValue();

    public abstract void setCellEditorValue(Object var1);

    @Override
    public boolean isCellEditable(EventObject evt) {
        if (evt instanceof MouseEvent) {
            return ((MouseEvent)evt).getClickCount() >= this.clicksToEdit;
        }
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.getCellEditorValue() == null && !this.acceptNullValue) {
            this.applyErrorBorder();
            return false;
        }
        return super.stopCellEditing();
    }

    protected void applyErrorBorder() {
        Color errorColor = SyntheticaLookAndFeel.getColor((String)"Synthetica.table.cellEditor.focus.errorColor", null, (Color)new Color(0xE70000));
        ((JComponent)this.editorComponent).setBorder((Border)new SyntheticaDefaultTableCellEditor.CellFocusBorder(errorColor));
    }

    public void setClicksToEdit(int clicks) {
        this.clicksToEdit = clicks;
    }

    public int getClicksToEdit() {
        return this.clicksToEdit;
    }
}

