/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.syntheticaaddons.table.AbstractTableCellEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class ComboBoxTableCellEditor
extends AbstractTableCellEditor<JComboBox<Object>> {
    public ComboBoxTableCellEditor(TableCellEditor defaultEditor) {
        this(defaultEditor, false);
    }

    public ComboBoxTableCellEditor(TableCellEditor defaultEditor, boolean editable) {
        super(defaultEditor);
        ((JComboBox)this.editorComponent).setEditable(editable);
    }

    @Override
    public JComboBox<Object> createEditorComponent() {
        JComboBox<Object> c = new JComboBox<Object>();
        c.putClientProperty("Synthetica.opaque", false);
        c.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComboBoxTableCellEditor.this.stopCellEditing();
            }
        });
        return c;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (((JComboBox)ComboBoxTableCellEditor.this.editorComponent).isEditable()) {
                    ((JComboBox)ComboBoxTableCellEditor.this.editorComponent).getEditor().getEditorComponent().requestFocusInWindow();
                } else {
                    ((JComboBox)ComboBoxTableCellEditor.this.editorComponent).requestFocusInWindow();
                }
            }
        });
        return c;
    }

    @Override
    public void setCellEditorValue(Object value) {
        this.modelDriven = value instanceof ComboBoxModel;
        DefaultComboBoxModel m = new DefaultComboBoxModel();
        if (this.modelDriven) {
            ComboBoxModel model = (ComboBoxModel)value;
            int i = 0;
            while (i < model.getSize()) {
                m.addElement(model.getElementAt(i));
                ++i;
            }
            m.setSelectedItem(model.getSelectedItem());
        } else {
            ComboBoxModel model = ((JComboBox)this.editorComponent).getModel();
            int i = 0;
            while (i < model.getSize()) {
                m.addElement(model.getElementAt(i));
                ++i;
            }
            m.setSelectedItem(value);
        }
        ((JComboBox)this.editorComponent).setModel(m);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.modelDriven) {
            return ((JComboBox)this.editorComponent).getModel();
        }
        return ((JComboBox)this.editorComponent).getSelectedItem();
    }
}

