/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.syntheticaaddons.table.FormattedTextFieldTableCellEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.text.DefaultFormatterFactory;

public class IntegerGroupTableCellEditor
extends FormattedTextFieldTableCellEditor {
    private String delimiter;
    private int numberOfNumbers;
    private Class<?> dataClass;

    public IntegerGroupTableCellEditor(TableCellEditor defaultEditor, Class<?> dataClass, int numbers) {
        this(defaultEditor, dataClass, numbers, ',');
    }

    public IntegerGroupTableCellEditor(TableCellEditor defaultEditor, Class<?> dataClass, int numbers, char delimiter) {
        super(defaultEditor);
        this.delimiter = String.valueOf(delimiter);
        this.numberOfNumbers = numbers;
        this.dataClass = dataClass;
        ((JFormattedTextField)this.editorComponent).setFormatterFactory(new DefaultFormatterFactory(new Formatter()));
    }

    private class Formatter
    extends JFormattedTextField.AbstractFormatter {
        private Formatter() {
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            String[] numbers = text.split(IntegerGroupTableCellEditor.this.delimiter);
            int[] vals = new int[IntegerGroupTableCellEditor.this.numberOfNumbers];
            if (numbers.length != IntegerGroupTableCellEditor.this.numberOfNumbers) {
                throw new ParseException("Required number: " + IntegerGroupTableCellEditor.this.numberOfNumbers, -1);
            }
            int i = 0;
            while (i < vals.length) {
                try {
                    vals[i] = Integer.parseInt(numbers[i].trim());
                }
                catch (NumberFormatException e) {
                    throw new ParseException(e.getMessage(), -1);
                }
                ++i;
            }
            Serializable o = null;
            if (IntegerGroupTableCellEditor.this.dataClass == Integer.class) {
                o = vals[0];
            } else if (IntegerGroupTableCellEditor.this.dataClass == Point.class) {
                o = new Point(vals[0], vals[1]);
            } else if (IntegerGroupTableCellEditor.this.dataClass == Dimension.class) {
                o = new Dimension(vals[0], vals[1]);
            } else if (IntegerGroupTableCellEditor.this.dataClass == Rectangle.class) {
                o = new Rectangle(vals[0], vals[1], vals[2], vals[3]);
            } else if (IntegerGroupTableCellEditor.this.dataClass == Insets.class) {
                o = new Insets(vals[0], vals[1], vals[2], vals[3]);
            } else if (IntegerGroupTableCellEditor.this.dataClass == Color.class) {
                try {
                    o = vals.length == 3 ? new Color(vals[0], vals[1], vals[2]) : new Color(vals[0], vals[1], vals[2], vals[3]);
                }
                catch (IllegalArgumentException e) {
                    throw new ParseException(e.getMessage(), -1);
                }
            }
            return o;
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value == null) {
                return null;
            }
            String s = null;
            if (value.getClass() == Integer.class) {
                s = value.toString();
            } else if (value.getClass() == Point.class) {
                Point p = (Point)value;
                s = String.valueOf(p.x) + IntegerGroupTableCellEditor.this.delimiter + " " + p.y;
            } else if (value.getClass() == Dimension.class) {
                Dimension d = (Dimension)value;
                s = String.valueOf(d.width) + IntegerGroupTableCellEditor.this.delimiter + " " + d.height;
            } else if (value.getClass() == Rectangle.class) {
                Rectangle r = (Rectangle)value;
                s = String.valueOf(r.x) + IntegerGroupTableCellEditor.this.delimiter + " " + r.y + IntegerGroupTableCellEditor.this.delimiter + " " + r.width + IntegerGroupTableCellEditor.this.delimiter + " " + r.height;
            } else if (value.getClass() == Insets.class) {
                Insets insets = (Insets)value;
                s = String.valueOf(insets.top) + IntegerGroupTableCellEditor.this.delimiter + " " + insets.left + IntegerGroupTableCellEditor.this.delimiter + " " + insets.bottom + IntegerGroupTableCellEditor.this.delimiter + " " + insets.right;
            } else if (value.getClass() == Color.class) {
                Color color = (Color)value;
                s = String.valueOf(color.getRed()) + IntegerGroupTableCellEditor.this.delimiter + " " + color.getGreen() + IntegerGroupTableCellEditor.this.delimiter + " " + color.getBlue() + IntegerGroupTableCellEditor.this.delimiter + " " + color.getAlpha();
            }
            return s;
        }
    }
}

