/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.syntheticaaddons.table.AbstractTableCellEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class ObjectTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected TableCellEditor delegate;
    protected HashMap<String, TableCellEditor> editors = new HashMap();
    protected TableCellEditor activeEditor;
    private int clicksToEdit;

    public ObjectTableCellEditor(TableCellEditor defaultEditor) {
        this.delegate = defaultEditor;
        this.setClicksToEdit(1);
    }

    public void setClicksToEdit(int clicks) {
        this.clicksToEdit = clicks;
    }

    public int getClicksToEdit() {
        return this.clicksToEdit;
    }

    public void addEditor(Class<?> dataClass, TableCellEditor editor) {
        this.editors.put(this.getEditorKey(dataClass), editor);
        this.installActionListener(editor);
    }

    public void removeEditor(Class<?> dataClass) {
        this.editors.remove(this.getEditorKey(dataClass));
    }

    public TableCellEditor getEditor(Class<?> dataClass) {
        return this.editors.get(this.getEditorKey(dataClass));
    }

    public void addEditor(int row, int column, TableCellEditor editor) {
        this.editors.put(this.getEditorKey(row, column), editor);
        this.installActionListener(editor);
    }

    public void removeEditor(int row, int column) {
        this.editors.remove(this.getEditorKey(row, column));
    }

    public TableCellEditor getEditor(int row, int column) {
        return this.editors.get(this.getEditorKey(row, column));
    }

    private String getEditorKey(Class<?> dataClass) {
        return this.getEditorKey(dataClass, -1, -1);
    }

    private String getEditorKey(int row, int column) {
        return this.getEditorKey(null, row, column);
    }

    private String getEditorKey(Class<?> dataClass, int row, int column) {
        return dataClass + "/" + row + "/" + column;
    }

    private void installActionListener(TableCellEditor editor) {
        if (editor instanceof AbstractTableCellEditor) {
            Object c = ((AbstractTableCellEditor)editor).getEditorComponent();
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ObjectTableCellEditor.this.stopCellEditing();
                }
            };
            if (c instanceof JComboBox) {
                ((JComboBox)c).addActionListener(al);
            } else if (c instanceof JTextField) {
                ((JTextField)c).addActionListener(al);
            }
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.activeEditor = this.getEditor(table.convertRowIndexToModel(row), table.convertColumnIndexToModel(column));
        if (this.activeEditor == null) {
            this.activeEditor = this.getEditor(value == null ? Object.class : value.getClass());
        }
        if (this.activeEditor == null) {
            TableCellEditor tableCellEditor = this.activeEditor = value == null ? null : this.getEditor(value.getClass().getSuperclass());
        }
        if (this.activeEditor == null) {
            return this.delegate.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
        return this.activeEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this.activeEditor == null ? this.delegate.getCellEditorValue() : this.activeEditor.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        if (evt instanceof MouseEvent) {
            return ((MouseEvent)evt).getClickCount() >= this.clicksToEdit;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject evt) {
        return this.activeEditor == null ? this.delegate.shouldSelectCell(evt) : this.activeEditor.shouldSelectCell(evt);
    }

    @Override
    public boolean stopCellEditing() {
        boolean result;
        boolean bl = result = this.activeEditor == null ? this.delegate.stopCellEditing() : this.activeEditor.stopCellEditing();
        if (result) {
            super.stopCellEditing();
        }
        return result;
    }

    @Override
    public void cancelCellEditing() {
        if (this.activeEditor == null) {
            this.delegate.stopCellEditing();
        } else {
            this.activeEditor.cancelCellEditing();
        }
        super.cancelCellEditing();
    }
}

