/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.TextAreaLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellRenderer;

public class TextAreaLabelCellRenderer
extends TextAreaLabel
implements TableCellRenderer {
    private static final long serialVersionUID = -1203988462132771832L;
    private Border noFocusBorder;
    private Border focusBorder;

    public TextAreaLabelCellRenderer() {
        this.putClientProperty("Synthetica.opaque", Boolean.TRUE);
        JComponent defaultRendererComponent = (JComponent)new JTable().getDefaultRenderer(Object.class).getTableCellRendererComponent(new JTable(new Object[][]{{""}}, new Object[]{""}), "", false, false, 0, 0);
        Border dBorder = defaultRendererComponent.getBorder();
        Border fBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
        Insets fInsets = SyntheticaLookAndFeel.getInstance().scaleInsets(fBorder.getBorderInsets(null));
        Insets dInsets = dBorder.getBorderInsets(null);
        Insets insets = new Insets(dInsets.top - fInsets.top, dInsets.left - fInsets.left, dInsets.bottom - fInsets.bottom, dInsets.right - fInsets.right);
        this.focusBorder = new CompoundBorder(fBorder, SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, false));
        this.noFocusBorder = new CompoundBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(fInsets, false), SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, false));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setText(value == null ? "" : value.toString());
        int colWidth = table.getColumnModel().getColumn(column).getWidth();
        this.setSize(new Dimension(colWidth, Integer.MAX_VALUE));
        int height = this.getPreferredSize().height;
        if (height != table.getRowHeight(row)) {
            table.setRowHeight(row, height);
        }
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(new Color(table.getSelectionBackground().getRGB()));
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(new Color(table.getBackground().getRGB()));
        }
        if (hasFocus) {
            this.setBorder(this.focusBorder);
        } else {
            this.setBorder(this.noFocusBorder);
        }
        return this;
    }
}

