/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.syntheticaaddons.ui.painter.TaskPanePainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;

public class TaskPaneUI
extends BasicTaskPaneUI {
    private static final String CONTENT_PANE_DEFAULT_NAME = "JXTaskPane.contentPane";
    private PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if ("name".equals(name)) {
                TaskPaneUI.this.group.setBorder(TaskPaneUI.this.createPaneBorder());
                ((JComponent)TaskPaneUI.this.group.getContentPane()).setBorder(TaskPaneUI.this.createContentPaneBorder());
                Container contentPane = TaskPaneUI.this.group.getContentPane();
                contentPane.setName("JXTaskPane.contentPane." + evt.getNewValue());
                if (SyntheticaLookAndFeel.get((String)"TaskPane.font", (Component)TaskPaneUI.this.group) != null && TaskPaneUI.this.group.getFont() instanceof UIResource) {
                    TaskPaneUI.this.group.setFont((Font)SyntheticaLookAndFeel.get((String)"TaskPane.font", (Component)TaskPaneUI.this.group));
                }
            }
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new TaskPaneUI();
    }

    protected Border createPaneBorder() {
        return new TaskPaneBorder();
    }

    public void installDefaults() {
        super.installDefaults();
        this.group.setOpaque(false);
        this.group.getContentPane().setName(CONTENT_PANE_DEFAULT_NAME);
    }

    protected void installListeners() {
        super.installListeners();
        this.group.addPropertyChangeListener(this.propertyListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.group.removePropertyChangeListener(this.propertyListener);
    }

    protected void configure(JXHyperlink link) {
        link.setOpaque(false);
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"Synthetica.taskPane.link.insets", (Component)this.group, (Insets)new Insets(2, 2, 2, 2), (boolean)true);
        link.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, false));
        link.setBorderPainted(false);
        link.setFocusPainted(true);
        Color foreground = SyntheticaLookAndFeel.getColor((String)"Synthetica.taskPane.link.foreground", (Component)link, (Color)UIManager.getColor("TaskPane.titleForeground"));
        link.setForeground(foreground);
    }

    protected int getTitleHeight(Component c) {
        Insets titleInsets = this.getTitleInsets();
        return super.getTitleHeight(c) + titleInsets.top + titleInsets.bottom;
    }

    protected Border createContentPaneBorder() {
        Color borderColor = UIManager.getColor("TaskPane.borderColor");
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"Synthetica.taskPane.contentPane.insets", (Component)this.group, (Insets)new Insets(10, 10, 10, 10), (boolean)true);
        boolean imageBorder = SyntheticaLookAndFeel.get((String)"Synthetica.taskPane.contentPane.image", (Component)this.group) != null;
        return imageBorder ? new TaskPaneContentBorder() : new CompoundBorder((Border)new BasicTaskPaneUI.ContentPaneBorder(borderColor), SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, false));
    }

    private Insets getTitleInsets() {
        return SyntheticaLookAndFeel.getInsets((String)"Synthetica.taskPane.title.insets", (Component)this.group, (Insets)new Insets(0, 3, 0, 0), (boolean)true);
    }

    protected class TaskPaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        public TaskPaneBorder() {
            super((BasicTaskPaneUI)TaskPaneUI.this);
            this.borderColor = SyntheticaLookAndFeel.getColor((String)"TaskPane.borderColor", (Component)TaskPaneUI.this.group);
            this.titleForeground = SyntheticaLookAndFeel.getColor((String)"TaskPane.titleForeground", (Component)TaskPaneUI.this.group);
            this.specialTitleBackground = SyntheticaLookAndFeel.getColor((String)"TaskPane.specialTitleBackground", (Component)TaskPaneUI.this.group);
            this.specialTitleForeground = SyntheticaLookAndFeel.getColor((String)"TaskPane.specialTitleForeground", (Component)TaskPaneUI.this.group);
            this.titleBackgroundGradientStart = SyntheticaLookAndFeel.getColor((String)"TaskPane.titleBackgroundGradientStart", (Component)TaskPaneUI.this.group);
            this.titleBackgroundGradientEnd = SyntheticaLookAndFeel.getColor((String)"TaskPane.titleBackgroundGradientEnd", (Component)TaskPaneUI.this.group);
            this.titleOver = SyntheticaLookAndFeel.getColor((String)"TaskPane.titleOver", (Component)TaskPaneUI.this.group);
            if (this.titleOver == null) {
                this.titleOver = this.specialTitleBackground.brighter();
            }
            this.specialTitleOver = SyntheticaLookAndFeel.getColor((String)"TaskPane.specialTitleOver", (Component)TaskPaneUI.this.group);
            if (this.specialTitleOver == null) {
                this.specialTitleOver = this.specialTitleBackground.brighter();
            }
        }

        protected void paintTitleBackground(JXTaskPane group, Graphics g) {
            SyntheticaState state = new SyntheticaState(TaskPaneUI.this.mouseOver ? SyntheticaState.State.HOVER.toInt() : 0);
            TaskPanePainter.getInstance().paintTaskPaneTitleBackground((JComponent)group, state, group.isSpecial(), !group.isCollapsed(), g, 0, 0, group.getWidth(), TaskPaneUI.this.getTitleHeight((Component)group));
        }

        protected void paintExpandedControls(JXTaskPane group, Graphics g, int x, int y, int width, int height) {
            SyntheticaState state = new SyntheticaState(TaskPaneUI.this.mouseOver ? SyntheticaState.State.HOVER.toInt() : 0);
            TaskPanePainter.getInstance().paintTaskPaneExpandedControl((JComponent)group, state, group.isSpecial(), !group.isCollapsed(), g, x, y, width, height);
        }

        protected void paintFocus(Graphics g, Color paintColor, int x, int y, int width, int height) {
            TaskPanePainter.getInstance().paintTaskPaneFocus((JComponent)TaskPaneUI.this.group, new SyntheticaState(SyntheticaState.State.FOCUSED.toInt()), g, x - 3, y - 3, width + 6, height + 6);
        }

        protected boolean isMouseOverBorder() {
            return true;
        }

        public Dimension getPreferredSize(JXTaskPane group) {
            this.configureLabel(group);
            Dimension dim = this.label.getPreferredSize();
            Insets titleInsets = TaskPaneUI.this.getTitleInsets();
            dim.width += titleInsets.left + titleInsets.right;
            dim.width += TaskPaneUI.this.getTitleHeight((Component)group);
            dim.width += SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(3)).intValue();
            dim.height = TaskPaneUI.this.getTitleHeight((Component)group);
            return dim;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JXTaskPane group = (JXTaskPane)c;
            boolean ltr = group.getComponentOrientation().isLeftToRight();
            Insets titleInsets = TaskPaneUI.this.getTitleInsets();
            int controlWidth = TaskPaneUI.this.getTitleHeight((Component)group) - 2 * TaskPaneUI.this.getRoundHeight();
            int controlX = group.getWidth() - TaskPaneUI.this.getTitleHeight((Component)group) - titleInsets.right;
            int controlY = TaskPaneUI.this.getRoundHeight() - 1;
            int titleX = titleInsets.left;
            int titleY = titleInsets.top;
            int titleWidth = group.getWidth() - TaskPaneUI.this.getTitleHeight((Component)group) - titleInsets.left - titleInsets.right;
            int titleHeight = TaskPaneUI.this.getTitleHeight((Component)group);
            if (!ltr) {
                controlX = group.getWidth() - controlX - controlWidth;
                titleX = group.getWidth() - titleX - titleWidth;
            }
            this.paintTitleBackground(group, g);
            this.paintExpandedControls(group, g, controlX, controlY, controlWidth, controlWidth);
            Color paintColor = this.getPaintColor(group);
            if (group.hasFocus()) {
                this.paintFocus(g, paintColor, 3, 3, width - 6, TaskPaneUI.this.getTitleHeight((Component)group) - 6);
            }
            this.paintTitle(group, g, paintColor, titleX, titleY, titleWidth, titleHeight);
        }
    }

    private class TaskPaneContentBorder
    implements Border,
    UIResource {
        private Insets insets;

        private TaskPaneContentBorder() {
            this.insets = SyntheticaLookAndFeel.getInsets((String)"Synthetica.taskPane.contentPane.insets", (Component)TaskPaneUI.this.group, (boolean)false, (boolean)true);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            TaskPanePainter.getInstance().paintTaskPaneContentPaneBackground((JComponent)TaskPaneUI.this.group, new SyntheticaState(0), g, x, y, width, height);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

